/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.leadcapture.Utils;
import org.exoplatform.leadcapture.dao.FieldDAO;
import org.exoplatform.leadcapture.dao.FormDAO;
import org.exoplatform.leadcapture.dao.LeadDAO;
import org.exoplatform.leadcapture.dao.ResponseDAO;
import org.exoplatform.leadcapture.dto.FieldDTO;
import org.exoplatform.leadcapture.dto.FormDTO;
import org.exoplatform.leadcapture.dto.FormInfo;
import org.exoplatform.leadcapture.dto.LeadCaptureSettings;
import org.exoplatform.leadcapture.dto.LeadDTO;
import org.exoplatform.leadcapture.dto.ResponseDTO;
import org.exoplatform.leadcapture.entity.FieldEntity;
import org.exoplatform.leadcapture.entity.FormEntity;
import org.exoplatform.leadcapture.entity.LeadEntity;
import org.exoplatform.leadcapture.entity.ResponseEntity;
import org.exoplatform.leadcapture.services.LeadCaptureSettingsService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.TaskUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LeadsManagementService {
    private final Log LOG = ExoLogger.getLogger(LeadsManagementService.class);
    private LeadDAO leadDAO;
    private FormDAO formDAO;
    private FieldDAO fieldDAO;
    private ResponseDAO responseDAO;
    private ListenerService listenerService;
    private TaskService taskService;
    private StatusService statusService;
    private ProjectService projectService;
    private LeadCaptureSettingsService leadCaptureSettingsService;

    public LeadsManagementService(LeadDAO leadDAO, FormDAO formDAO, FieldDAO fieldDAO, ResponseDAO responseDAO, TaskService taskService, StatusService statusService, ProjectService projectService, LeadCaptureSettingsService leadCaptureSettingsService, ListenerService listenerService) {
        this.leadDAO = leadDAO;
        this.formDAO = formDAO;
        this.fieldDAO = fieldDAO;
        this.responseDAO = responseDAO;
        this.listenerService = listenerService;
        this.taskService = taskService;
        this.statusService = statusService;
        this.projectService = projectService;
        this.leadCaptureSettingsService = leadCaptureSettingsService;
    }

    public LeadEntity addLeadInfo(FormInfo leadInfo, boolean broadcast) throws Exception {
        LeadEntity leadEntity = null;
        LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
        try {
            LeadDTO lead = leadInfo.getLead();
            leadEntity = this.leadDAO.getLeadByMail(lead.getMail());
            if (leadEntity == null) {
                if (lead.getCreatedDate() == null) {
                    lead.setCreatedDate(new Date());
                }
                if (lead.getUpdatedDate() == null) {
                    lead.setUpdatedDate(new Date());
                }
                if (lead.getStatus() == null) {
                    lead.setStatus("Raw");
                    if (leadInfo.getResponse() != null && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{settings.getAutoOpeningForms()}) && settings.getAutoOpeningForms().contains(leadInfo.getResponse().getFormName())) {
                        lead.setStatus("Open");
                    }
                }
                if (lead.getBlogSubscription() != null && lead.getBlogSubscription().booleanValue()) {
                    lead.setBlogSubscriptionDate(new Date());
                    lead.setCaptureMethod("Blog");
                    lead.setCaptureType("Blog subscription");
                }
                if (leadInfo.getResponse() != null) {
                    FieldDTO fieldDTO;
                    Iterator<FieldDTO> iterator;
                    lead.setCaptureMethod(leadInfo.getResponse().getFormName());
                    if (settings.getResourcesIdentifier() != null && (iterator = leadInfo.getResponse().getFields().iterator()).hasNext() && Utils.isResourceRequest((fieldDTO = iterator.next()).getValue())) {
                        lead.setCaptureType(fieldDTO.getValue());
                    }
                }
                leadEntity = this.createLead(lead);
                if (broadcast) {
                    this.listenerService.broadcast("leadCapture.newLead.event", (Object)leadEntity, (Object)"");
                }
            } else {
                Task task_;
                leadEntity = this.mergeLead(leadEntity, lead);
                leadEntity.setUpdatedDate(new Date());
                if ((leadEntity.getTaskId() == null || leadEntity.getTaskId() == 0L) && leadEntity.getStatus().equals("Raw") && settings.getAutoOpeningForms() != null && leadInfo.getResponse() != null && settings.getAutoOpeningForms().contains(leadInfo.getResponse().getFormName()) && (task_ = this.createTask(leadEntity)) != null) {
                    leadEntity.setTaskId(task_.getId());
                    leadEntity.setTaskUrl(TaskUtil.buildTaskURL((Task)task_));
                    leadEntity.setStatus("Open");
                }
                this.leadDAO.update(leadEntity);
            }
            if (leadInfo.getResponse() != null) {
                this.addResponse(leadInfo.getResponse(), leadEntity);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to synchronize lead", (Throwable)e);
            throw e;
        }
        return leadEntity;
    }

    public LeadEntity createLead(LeadDTO lead) {
        return (LeadEntity)this.leadDAO.create(this.toLeadEntity(lead));
    }

    public void deleteLead(LeadEntity lead) throws Exception {
        try {
            List<ResponseEntity> responseEntities = this.responseDAO.getResponsesByLead(lead.getId());
            for (ResponseEntity responseEntity : responseEntities) {
                this.fieldDAO.deleteAll(this.fieldDAO.getFieldsByResponse(responseEntity.getId()));
            }
            this.responseDAO.deleteAll(responseEntities);
            if (lead.getTaskId() != null && lead.getTaskId() != 0L) {
                this.taskService.removeTask(lead.getTaskId().longValue());
            }
            this.leadDAO.delete(lead);
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw e;
        }
    }

    public void updateLead(LeadDTO lead) throws Exception {
        try {
            lead.setUpdatedDate(new Date());
            this.leadDAO.update(this.toLeadEntity(lead));
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw e;
        }
    }

    public void assigneLead(Long leadId, String assignee) throws Exception {
        try {
            LeadEntity leadEntity = (LeadEntity)this.leadDAO.find(leadId);
            leadEntity.setUpdatedDate(new Date());
            leadEntity.setAssignee(assignee);
            this.leadDAO.update(leadEntity);
            if (leadEntity.getTaskId() != null && leadEntity.getTaskId() != 0L) {
                Task task = this.taskService.getTask(leadEntity.getTaskId().longValue());
                task.setAssignee(assignee);
                this.taskService.updateTask(task);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw e;
        }
    }

    public void suspendLead(Long leadId) throws Exception {
        try {
            LeadEntity leadEntity = (LeadEntity)this.leadDAO.find(leadId);
            leadEntity.setUpdatedDate(new Date());
            leadEntity.setMarketingSuspended(true);
            leadEntity.setMarketingSuspendedCause("Unsubscribed");
            this.leadDAO.update(leadEntity);
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw e;
        }
    }

    public LeadEntity updateStatus(Long leadId, String status) throws Exception {
        try {
            Task task_;
            LeadEntity leadEntity = (LeadEntity)this.leadDAO.find(leadId);
            leadEntity.setUpdatedDate(new Date());
            leadEntity.setStatus(status);
            if (!(leadEntity.getTaskId() != null && leadEntity.getTaskId() != 0L || status.equals("Raw") || (task_ = this.createTask(leadEntity)) == null)) {
                leadEntity.setTaskId(task_.getId());
                leadEntity.setTaskUrl(TaskUtil.buildTaskURL((Task)task_));
            }
            if ((leadEntity = (LeadEntity)this.leadDAO.update(leadEntity)).getTaskId() != null && leadEntity.getTaskId() != 0L) {
                this.updateTaskStatus(leadEntity.getTaskId(), status);
            }
            return leadEntity;
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw e;
        }
    }

    public List<LeadDTO> getLeads() {
        ArrayList<LeadDTO> leadsList = new ArrayList<LeadDTO>();
        List leadsEntities = this.leadDAO.findAll();
        if (leadsEntities != null) {
            for (LeadEntity leadEntity : leadsEntities) {
                if (leadEntity == null) continue;
                leadsList.add(this.toLeadDto(leadEntity));
            }
        }
        return leadsList;
    }

    public JSONArray getResponses(long leadId) {
        JSONArray formResponsesList = new JSONArray();
        List formEntities = this.formDAO.findAll();
        for (FormEntity formEntity : formEntities) {
            try {
                JSONObject formResponse = new JSONObject();
                formResponse.put("form", (Object)this.toFormJson(formEntity));
                List<ResponseEntity> responsesEntities = this.responseDAO.getResponsesByForm(formEntity.getId(), leadId);
                if (responsesEntities == null || responsesEntities.size() <= 0) continue;
                JSONArray responsesList = new JSONArray();
                for (ResponseEntity responseEntity : responsesEntities) {
                    if (responseEntity == null) continue;
                    responseEntity.setFilelds(this.fieldDAO.getFieldsByResponse(responseEntity.getId()));
                    responsesList.put((Object)Utils.toResponseJson(responseEntity));
                }
                formResponse.put("responses", (Object)responsesList);
                formResponsesList.put((Object)formResponse);
            }
            catch (Exception e) {
                this.LOG.error("Cannot get responses for form {}", new Object[]{formEntity.getName(), e});
            }
        }
        return formResponsesList;
    }

    public void addResponse(ResponseDTO responseDTO, LeadEntity leadEntity) throws Exception {
        try {
            String fields;
            FormEntity formEntity = this.formDAO.getFormByName(responseDTO.getFormName());
            if (formEntity == null) {
                fields = responseDTO.getFields().stream().map(n -> n.getName()).collect(Collectors.joining(","));
                if (!fields.contains("createdDate")) {
                    fields = fields.concat(",createdDate");
                }
                formEntity = this.createForm(new FormEntity(responseDTO.getFormName(), fields));
            } else {
                fields = formEntity.getFields();
                ArrayList<String> fieldList = new ArrayList<String>(Arrays.asList(fields.split(",")));
                if (!fieldList.contains("createdDate")) {
                    fieldList.add("createdDate");
                }
                boolean changed = false;
                for (FieldDTO field : responseDTO.getFields()) {
                    if (fieldList.contains(field.getName())) continue;
                    fieldList.add(field.getName());
                    changed = true;
                }
                if (changed) {
                    fields = fieldList.stream().collect(Collectors.joining(","));
                    formEntity.setFields(fields);
                    this.updateForm(formEntity);
                }
            }
            ResponseEntity responseEntity = new ResponseEntity(formEntity, leadEntity);
            if (responseDTO.getCreatedDate() != null) {
                responseEntity.setCreatedDate(responseDTO.getCreatedDate());
            }
            responseEntity = this.createResponse(responseEntity);
            for (FieldDTO field : responseDTO.getFields()) {
                FieldEntity fieldEntity = new FieldEntity(field.getName(), field.getValue(), responseEntity);
                this.fieldDAO.create(fieldEntity);
            }
            this.listenerService.broadcast("leadCapture.newResponse.event", (Object)leadEntity, (Object)responseEntity);
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to add response", (Throwable)e);
            throw e;
        }
    }

    public List<ResponseEntity> getAllResponses() {
        return this.responseDAO.findAll();
    }

    public FormEntity createForm(FormEntity formEntity) {
        return (FormEntity)this.formDAO.create(formEntity);
    }

    public FormEntity updateForm(FormEntity formEntity) {
        return (FormEntity)this.formDAO.update(formEntity);
    }

    public ResponseEntity createResponse(ResponseEntity responseEntity) {
        if (responseEntity.getCreatedDate() == null) {
            responseEntity.setCreatedDate(new Date());
        }
        return (ResponseEntity)this.responseDAO.create(responseEntity);
    }

    public LeadEntity getLeadbyId(long id) {
        return (LeadEntity)this.leadDAO.find(Long.valueOf(id));
    }

    public LeadEntity getLeadByMail(String mail) {
        return this.leadDAO.getLeadByMail(mail);
    }

    public LeadEntity getLeadByTask(Long taslId) {
        return this.leadDAO.getLeadByTask(taslId);
    }

    public JSONArray getTaskComments(long taskId) {
        return Utils.getCommentsJson((ListAccess<Comment>)this.taskService.getComments(taskId));
    }

    public JSONObject addTaskComment(long taskId, String username, String comment) throws Exception {
        try {
            Comment comment_ = this.taskService.addComment(taskId, username, comment);
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            return Utils.commentToJson(comment_, comment_.getAuthor(), organizationService.getUserHandler().findUserByName(comment_.getAuthor()).getDisplayName());
        }
        catch (EntityNotFoundException enf) {
            this.LOG.error((Object)"Cannot Add Comment", (Throwable)enf);
            throw enf;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Cannot conevert comment to json", (Throwable)e);
            throw e;
        }
    }

    public void updateTaskStatus(Long taskId, String status) throws Exception {
        try {
            LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
            Task task = this.taskService.getTask(taskId.longValue());
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space uxSpace = spaceService.getSpaceByPrettyName(settings.getUserExperienceSpace());
            List statuses = this.statusService.getStatuses(Utils.getTaskProject(uxSpace.getGroupId(), settings.getLeadTaskProject()).getId());
            Status newStatus = null;
            for (Status status_ : statuses) {
                if (!status_.getName().equals(status)) continue;
                newStatus = status_;
            }
            if (newStatus != null) {
                task.setStatus(newStatus);
                this.taskService.updateTask(task);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"Cannot update Task status", (Throwable)e);
            throw e;
        }
    }

    public Task createTask(LeadEntity lead) throws Exception {
        LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space uxSpace = spaceService.getSpaceByPrettyName(settings.getUserExperienceSpace());
        if (uxSpace != null) {
            Status status = this.statusService.getDefaultStatus(Utils.getTaskProject(uxSpace.getGroupId(), settings.getLeadTaskProject()).getId());
            Task task = new Task();
            task.setTitle(lead.getMail());
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{lead.getFirstName()}) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{lead.getLastName()})) {
                task.setTitle(lead.getFirstName() + " " + lead.getLastName());
            }
            task.setDescription("<a  href=\"" + this.leadCaptureSettingsService.getSettings().getLeadManagementAppUrl() + "?leadid=" + lead.getId() + "\">" + lead.getFirstName() + " " + lead.getLastName() + " </a>");
            task.setStatus(status);
            task.setCreatedBy(settings.getUserExperienceBotUserName());
            task.setCreatedTime(new Date());
            task = this.taskService.createTask(task);
            return task;
        }
        return null;
    }

    public LeadEntity mergeLead(LeadEntity leadEntity, LeadDTO leadDTO) {
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getFirstName())) {
            leadEntity.setFirstName(leadDTO.getFirstName());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getLastName())) {
            leadEntity.setLastName(leadDTO.getLastName());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getCompany())) {
            leadEntity.setCompany(leadDTO.getCompany());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getPosition())) {
            leadEntity.setPosition(leadDTO.getPosition());
        }
        if (!(StringUtils.isEmpty((CharSequence)leadDTO.getInferredCountry()) || !StringUtils.isEmpty((CharSequence)leadEntity.getGeographiqueZone()) && leadDTO.getInferredCountry().equals(leadEntity.getCountry()))) {
            leadDTO.setGeographiqueZone(Utils.getGeoZone(this.toLeadEntity(leadDTO)));
            leadEntity.setGeographiqueZone(leadDTO.getGeographiqueZone());
            leadEntity.setCountry(leadDTO.getInferredCountry());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getPhone())) {
            leadEntity.setPhone(leadDTO.getPhone());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getLanguage())) {
            leadEntity.setLanguage(leadDTO.getLanguage());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getAssignee())) {
            leadEntity.setAssignee(leadDTO.getAssignee());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getCaptureMethod())) {
            leadEntity.setCaptureMethod(leadDTO.getCaptureMethod());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getCaptureType())) {
            leadEntity.setCaptureType(leadDTO.getCaptureType());
        }
        if (!(leadEntity.getBlogSubscription() != null && leadEntity.getBlogSubscription().booleanValue() || leadDTO.getBlogSubscription() == null)) {
            leadEntity.setBlogSubscription(true);
            leadEntity.setBlogSubscriptionDate(new Date());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getCommunityUserName())) {
            leadEntity.setCommunityUserName(leadDTO.getCommunityUserName());
        }
        if (leadDTO.getCommunityRegistration() != null) {
            leadEntity.setCommunityRegistration(leadDTO.getCommunityRegistration());
        }
        if (!StringUtils.isEmpty((CharSequence)leadDTO.getCommunityRegistrationMethod())) {
            leadEntity.setCommunityRegistrationMethod(leadDTO.getCommunityRegistrationMethod());
        }
        if (leadDTO.getCommunityRegistrationDate() != null) {
            leadEntity.setCommunityRegistrationDate(leadDTO.getCommunityRegistrationDate());
        }
        return leadEntity;
    }

    public JSONObject toFormJson(FormEntity formEntity) throws JSONException {
        JSONObject formJson = new JSONObject();
        formJson.put("id", (Object)formEntity.getId());
        formJson.put("name", (Object)formEntity.getName());
        formJson.put("fields", (Object)formEntity.getFields().split(","));
        return formJson;
    }

    public LeadDTO toLeadDto(LeadEntity leadEntity) {
        LeadDTO leadDTO = new LeadDTO();
        leadDTO.setId(leadEntity.getId());
        leadDTO.setMail(leadEntity.getMail());
        leadDTO.setFirstName(leadEntity.getFirstName());
        leadDTO.setLastName(leadEntity.getLastName());
        leadDTO.setCompany(leadEntity.getCompany());
        leadDTO.setPosition(leadEntity.getPosition());
        leadDTO.setInferredCountry(leadEntity.getCountry());
        leadDTO.setStatus(leadEntity.getStatus());
        leadDTO.setPhone(leadEntity.getPhone());
        if (leadEntity.getCreatedDate() != null) {
            leadDTO.setCreatedDate(leadEntity.getCreatedDate());
            leadDTO.setFormattedCreatedDate(Utils.formatter.format(leadEntity.getCreatedDate()));
        }
        if (leadEntity.getUpdatedDate() != null) {
            leadDTO.setUpdatedDate(leadEntity.getUpdatedDate());
            leadDTO.setFormattedUpdatedDate(Utils.formatter.format(leadEntity.getUpdatedDate()));
        }
        leadDTO.setLanguage(leadEntity.getLanguage());
        leadDTO.setAssignee(leadEntity.getAssignee());
        leadDTO.setGeographiqueZone(leadEntity.getGeographiqueZone());
        leadDTO.setMarketingSuspended(leadEntity.getMarketingSuspended());
        leadDTO.setMarketingSuspendedCause(leadEntity.getMarketingSuspendedCause());
        leadDTO.setCaptureMethod(leadEntity.getCaptureMethod());
        leadDTO.setCaptureType(leadEntity.getCaptureType());
        leadDTO.setBlogSubscription(leadEntity.getBlogSubscription());
        leadDTO.setBlogSubscriptionDate(leadEntity.getBlogSubscriptionDate());
        if (leadEntity.getBlogSubscriptionDate() != null) {
            leadDTO.setFormattedBlogSubscriptionDate(Utils.formatter.format(leadEntity.getBlogSubscriptionDate()));
        }
        leadDTO.setCommunityUserName(leadEntity.getCommunityUserName());
        leadDTO.setCommunityRegistration(leadEntity.getCommunityRegistration());
        leadDTO.setCommunityRegistrationMethod(leadEntity.getCommunityRegistrationMethod());
        leadDTO.setCommunityRegistrationDate(leadEntity.getCommunityRegistrationDate());
        if (leadEntity.getCommunityRegistrationDate() != null) {
            leadDTO.setFormattedCommunityRegistrationDate(Utils.formatter.format(leadEntity.getCommunityRegistrationDate()));
        }
        leadDTO.setPersonSource(leadEntity.getPersonSource());
        leadDTO.setLandingPageInfo(leadEntity.getLandingPageInfo());
        leadDTO.setCaptureSourceInfo(leadEntity.getCaptureSourceInfo());
        leadDTO.setPersonIp(leadEntity.getPersonIp());
        leadDTO.setOriginalReferrer(leadEntity.getOriginalReferrer());
        leadDTO.setTaskId(leadEntity.getTaskId());
        leadDTO.setTaskUrl(leadEntity.getTaskUrl());
        leadDTO.setActivityId(leadEntity.getActivityId());
        leadDTO.setGoal(leadEntity.getGoal());
        leadDTO.setUsersNumber(leadEntity.getUsersNumber());
        leadDTO.setInteractionSummary(leadEntity.getInteractionSummary());
        leadDTO.setCurrentSolution(leadEntity.getCurrentSolution());
        leadDTO.setHowHear(leadEntity.getHowHear());
        leadDTO.setSolutionType(leadEntity.getSolutionType());
        leadDTO.setSolutionRequirements(leadEntity.getSolutionRequirements());
        leadDTO.setShortlistVendors(leadEntity.getShortlistVendors());
        leadDTO.setCompanyWebsite(leadEntity.getCompanyWebsite());
        leadDTO.setEmployeesNumber(leadEntity.getEmployeesNumber());
        leadDTO.setIndustry(leadEntity.getIndustry());
        return leadDTO;
    }

    public LeadEntity toLeadEntity(LeadDTO leadDTO) {
        LeadEntity leadEntity = new LeadEntity();
        leadEntity.setId(leadDTO.getId());
        leadEntity.setMail(leadDTO.getMail());
        leadEntity.setFirstName(leadDTO.getFirstName());
        leadEntity.setLastName(leadDTO.getLastName());
        leadEntity.setCompany(leadDTO.getCompany());
        leadEntity.setPosition(leadDTO.getPosition());
        leadEntity.setCountry(leadDTO.getInferredCountry());
        leadEntity.setStatus(leadDTO.getStatus());
        leadEntity.setPhone(leadDTO.getPhone());
        leadEntity.setCreatedDate(leadDTO.getCreatedDate());
        leadEntity.setUpdatedDate(leadDTO.getUpdatedDate());
        leadEntity.setLanguage(leadDTO.getLanguage());
        leadEntity.setAssignee(leadDTO.getAssignee());
        leadEntity.setGeographiqueZone(leadDTO.getGeographiqueZone());
        leadEntity.setMarketingSuspended(leadDTO.getMarketingSuspended());
        leadEntity.setMarketingSuspendedCause(leadDTO.getMarketingSuspendedCause());
        leadEntity.setCaptureMethod(leadDTO.getCaptureMethod());
        leadEntity.setCaptureType(leadDTO.getCaptureType());
        leadEntity.setBlogSubscription(leadDTO.getBlogSubscription());
        leadEntity.setBlogSubscriptionDate(leadDTO.getBlogSubscriptionDate());
        leadEntity.setCommunityUserName(leadDTO.getCommunityUserName());
        leadEntity.setCommunityRegistration(leadDTO.getCommunityRegistration());
        leadEntity.setCommunityRegistrationMethod(leadDTO.getCommunityRegistrationMethod());
        leadEntity.setCommunityRegistrationDate(leadDTO.getCommunityRegistrationDate());
        leadEntity.setPersonSource(leadDTO.getPersonSource());
        leadEntity.setLandingPageInfo(leadDTO.getLandingPageInfo());
        leadEntity.setCaptureSourceInfo(leadDTO.getCaptureSourceInfo());
        leadEntity.setPersonIp(leadDTO.getPersonIp());
        leadEntity.setOriginalReferrer(leadDTO.getOriginalReferrer());
        leadEntity.setTaskId(leadDTO.getTaskId());
        leadEntity.setTaskUrl(leadDTO.getTaskUrl());
        leadEntity.setActivityId(leadDTO.getActivityId());
        leadEntity.setGoal(leadDTO.getGoal());
        leadEntity.setUsersNumber(leadDTO.getUsersNumber());
        leadEntity.setInteractionSummary(leadDTO.getInteractionSummary());
        leadEntity.setCurrentSolution(leadDTO.getCurrentSolution());
        leadEntity.setHowHear(leadDTO.getHowHear());
        leadEntity.setSolutionType(leadDTO.getSolutionType());
        leadEntity.setSolutionRequirements(leadDTO.getSolutionRequirements());
        leadEntity.setShortlistVendors(leadDTO.getShortlistVendors());
        leadEntity.setCompanyWebsite(leadDTO.getCompanyWebsite());
        leadEntity.setEmployeesNumber(leadDTO.getEmployeesNumber());
        leadEntity.setIndustry(leadDTO.getIndustry());
        return leadEntity;
    }

    public FieldDTO toFieldDto(FieldEntity fieldEntity) {
        FieldDTO fieldDTO = new FieldDTO();
        fieldDTO.setId(fieldEntity.getId());
        fieldDTO.setName(fieldEntity.getName());
        fieldDTO.setValue(fieldEntity.getValue());
        return fieldDTO;
    }

    public FieldEntity toFieldEntity(FieldDTO fieldDTO) {
        FieldEntity fieldEntity = new FieldEntity();
        fieldEntity.setId(fieldDTO.getId());
        fieldEntity.setName(fieldDTO.getName());
        fieldEntity.setValue(fieldDTO.getValue());
        return fieldEntity;
    }

    public FormDTO toFormDto(FormEntity formEntity) {
        FormDTO formDTO = new FormDTO();
        formDTO.setId(formEntity.getId());
        formDTO.setName(formEntity.getName());
        formDTO.setFields(formEntity.getFields());
        return formDTO;
    }

    public FormEntity toFormEntity(FormDTO formDTO) {
        FormEntity formEntity = new FormEntity();
        formEntity.setId(formDTO.getId());
        formEntity.setName(formDTO.getName());
        formEntity.setFields(formDTO.getFields());
        return formEntity;
    }

    public ResponseDTO toResponseDto(ResponseEntity responseEntity) {
        ResponseDTO responseDTO = new ResponseDTO();
        responseDTO.setId(responseEntity.getId());
        responseDTO.setCreatedDate(responseEntity.getCreatedDate());
        responseDTO.setForm(this.toFormDto(responseEntity.getFormEntity()));
        responseDTO.setFormName(responseEntity.getFormEntity().getName());
        ArrayList<FieldDTO> fields = new ArrayList<FieldDTO>();
        for (FieldEntity fieald : this.fieldDAO.getFieldsByResponse(responseEntity.getId())) {
            fields.add(this.toFieldDto(fieald));
        }
        responseDTO.setFields(fields);
        return responseDTO;
    }

    public ResponseEntity toResponseEntity(ResponseDTO responseDTO) {
        ResponseEntity responseEntity = new ResponseEntity();
        responseEntity.setId(responseDTO.getId());
        responseEntity.setFormEntity(this.toFormEntity(responseDTO.getForm()));
        ArrayList<FieldEntity> fields = new ArrayList<FieldEntity>();
        for (FieldDTO fieald : responseDTO.getFields()) {
            fields.add(this.toFieldEntity(fieald));
        }
        responseEntity.setFilelds(fields);
        return responseEntity;
    }
}

