/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.listeners;

import java.util.Date;
import org.exoplatform.leadcapture.dao.LeadDAO;
import org.exoplatform.leadcapture.entity.LeadEntity;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

@Asynchronous
public class NewUserListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(NewUserListener.class);
    private LeadDAO leadDAO;

    public NewUserListener(LeadDAO leadDAO) throws Exception {
        this.leadDAO = leadDAO;
    }

    public void postSave(User user, boolean isNew) throws Exception {
        try {
            LeadEntity leadEntity = this.leadDAO.getLeadByMail(user.getEmail());
            if (!(leadEntity == null || leadEntity.getCommunityRegistration() != null && leadEntity.getCommunityRegistration().booleanValue())) {
                leadEntity.setUpdatedDate(new Date());
                leadEntity.setCommunityRegistration(true);
                leadEntity.setCommunityRegistrationDate(user.getCreatedDate());
                leadEntity.setCommunityUserName(user.getUserName());
                this.leadDAO.update(leadEntity);
                LOG.info("Lead {} has been associated to the community user {}", new Object[]{leadEntity.getId(), user.getUserName()});
            }
        }
        catch (Exception e) {
            LOG.error((Object)"an error occured", (Throwable)e);
        }
    }

    public void postDelete(User user) throws Exception {
    }
}

