/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.leadcapture.dto.CompaignDTO;
import org.exoplatform.leadcapture.entity.CompaignEntity;
import org.exoplatform.leadcapture.services.CompaignManagementService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;

@Path(value="/leadcapture/lccompaigns")
@Produces(value={"application/json"})
public class CompaignsManagementRest
implements ResourceContainer {
    private final Log LOG = ExoLogger.getLogger(CompaignsManagementRest.class);
    private final String portalContainerName = "portal";
    private CompaignManagementService compaignsManagementService;

    public CompaignsManagementRest(CompaignManagementService compaignsManagementService) {
        this.compaignsManagementService = compaignsManagementService;
    }

    @GET
    @Path(value="compaigns")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response getCompaigns(@Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok(this.compaignsManagementService.getCompaigns()).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to get compaigns list", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="compaigns")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response add(@Context UriInfo uriInfo, CompaignDTO compaignDTO) throws Exception {
        try {
            this.compaignsManagementService.addCompaign(compaignDTO);
            return Response.ok((Object)"Compaign added").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to add new compaign {}", new Object[]{compaignDTO.getName(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="compaigns/{id}")
    @RolesAllowed(value={"ux-team"})
    public Response delete(@Context UriInfo uriInfo, @PathParam(value="id") Long id) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            CompaignEntity compaignEntity = this.compaignsManagementService.getCompaignById(id);
            if (compaignEntity == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Compaign not found").build();
            }
            this.compaignsManagementService.deleteCompaign(compaignEntity);
            this.LOG.info("Compaign {} deleted by {}", new Object[]{id, sourceIdentity.getRemoteId()});
            return Response.ok((Object)"Compaign deleted").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to delete Compaign {}", new Object[]{id, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="compaigns")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response update(@Context UriInfo uriInfo, CompaignDTO compaignDTO) throws Exception {
        try {
            this.compaignsManagementService.updateCompaign(compaignDTO);
            return Response.ok((Object)"Compaign updated").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to update Compaign {}", new Object[]{compaignDTO.getId(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

