/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.services;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.leadcapture.dto.LeadCaptureSettings;
import org.exoplatform.leadcapture.entity.LeadEntity;
import org.exoplatform.leadcapture.services.LeadCaptureSettingsService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;

public class LCMailService {
    private static final Log LOG = ExoLogger.getLogger(LCMailService.class);
    private MailService mailService;
    private LeadCaptureSettingsService leadCaptureSettingsService;

    public LCMailService(MailService mailService, LeadCaptureSettingsService leadCaptureSettingsService) {
        this.mailService = mailService;
        this.leadCaptureSettingsService = leadCaptureSettingsService;
    }

    public static String convertCodeHTML(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return "";
        }
        s = s.replaceAll("(<p>((\\&nbsp;)*)(\\s*)?</p>)|(<p>((\\&nbsp;)*)?(\\s*)</p>)", "<br/>").trim();
        s = s.replaceFirst("(<br/>)*", "");
        s = s.replaceAll("(\\w|\\$)(>?,?\\.?\\*?\\!?\\&?\\%?\\]?\\)?\\}?)(<br/><br/>)*", "$1$2");
        try {
            s = s.replaceAll("(https?|ftp)://", " $0").replaceAll("(=\"|='|'>|\">)( )(https?|ftp)", "$1$3").replaceAll("[^=\"|^='|^'>|^\">](https?://|ftp://)([-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])", "<a target=\"_blank\" href=\"$1$2\">$1$2</a>");
            s = s.replaceAll("&apos;", "'");
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to convert HTML" + e.getMessage()));
        }
        return s;
    }

    public void sendMail(String content, String subject, LeadEntity lead, String resource, String resourceName) throws Exception {
        LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
        if (settings.isMailingEnabled()) {
            if (lead.getMarketingSuspended() == null || !lead.getMarketingSuspended().booleanValue()) {
                String allowedMailDomain = System.getProperty("leadCapture.allowed.mail.domain");
                if (StringUtils.isEmpty((String)allowedMailDomain) || lead.getMail().contains(allowedMailDomain)) {
                    if (settings.getSenderMail() != null) {
                        Message message = new Message();
                        message.setFrom(settings.getSenderMail());
                        message.setTo(lead.getMail());
                        message.setMimeType("text/html");
                        subject = StringUtils.replace((String)subject, (String)"$RESOURCE_NAME", (String)resourceName);
                        message.setSubject(StringCommonUtils.decodeSpecialCharToHTMLnumber((String)subject));
                        message.setBody(this.getContentEmail(content, lead, resource, resourceName));
                        this.mailService.sendMessage(message);
                    } else {
                        LOG.warn("Mail sender adress is not defined, cannot send mail to lead {}", new Object[]{lead.getId()});
                    }
                } else {
                    LOG.warn("Cannot send mail to lead{}, mail domain not allowed", new Object[]{lead.getId()});
                }
            } else {
                LOG.warn("Cannot send mail to lead{}, lead marketing suspended", new Object[]{lead.getId()});
            }
        } else {
            LOG.warn("Cannot send mail to lead{}, mailing disabled", new Object[]{lead.getId()});
        }
    }

    public String getContentEmail(String content, LeadEntity lead, String resource, String resourceName) {
        String content_ = StringUtils.replace((String)content, (String)"$FIRST_NAME", (String)lead.getFirstName());
        content_ = StringUtils.replace((String)content_, (String)"$LAST_NAME", (String)lead.getLastName());
        content_ = StringUtils.replace((String)content_, (String)"$MAIL", (String)lead.getMail());
        content_ = StringUtils.replace((String)content_, (String)"$RESOURCE_NAME", (String)resourceName);
        content_ = StringUtils.replace((String)content_, (String)"$RESOURCE", (String)resource);
        content_ = StringUtils.replace((String)content_, (String)"$UNSUBSCRIBE_URL", (String)this.leadCaptureSettingsService.getSettings().getUnsubscribeUrl());
        return LCMailService.convertCodeHTML(content_);
    }
}

