/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.services;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.leadcapture.dao.MailContentDAO;
import org.exoplatform.leadcapture.dao.MailTemplateDAO;
import org.exoplatform.leadcapture.dto.MailContentDTO;
import org.exoplatform.leadcapture.dto.MailTemplateDTO;
import org.exoplatform.leadcapture.entity.MailContentEntity;
import org.exoplatform.leadcapture.entity.MailTemplateEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MailTemplatesManagementService {
    private final Log LOG = ExoLogger.getLogger(MailTemplatesManagementService.class);
    private MailTemplateDAO mailTemplateDAO;
    private MailContentDAO mailContentDAO;

    public MailTemplatesManagementService(MailTemplateDAO mailTemplateDAO, MailContentDAO mailContentDAO) {
        this.mailTemplateDAO = mailTemplateDAO;
        this.mailContentDAO = mailContentDAO;
    }

    public List<MailTemplateDTO> getTemplates() {
        ArrayList<MailTemplateDTO> mailTemplateList = new ArrayList<MailTemplateDTO>();
        List mailTemplateEntities = this.mailTemplateDAO.findAll();
        if (mailTemplateEntities != null) {
            for (MailTemplateEntity mailTemplateEntity : mailTemplateEntities) {
                if (mailTemplateEntity == null) continue;
                mailTemplateList.add(this.toMailTemplateDTO(mailTemplateEntity));
            }
        }
        return mailTemplateList;
    }

    public MailTemplateDTO addTemplate(MailTemplateDTO templateDTO) {
        List<MailContentDTO> contents = templateDTO.getContents();
        ArrayList<MailContentEntity> contentsEntities = new ArrayList<MailContentEntity>();
        templateDTO.setContents(new ArrayList<MailContentDTO>());
        MailTemplateEntity newTemplate = (MailTemplateEntity)this.mailTemplateDAO.create(this.toMailTemplateEntity(templateDTO));
        for (MailContentDTO contentDTO : contents) {
            if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{contentDTO.getContent()}) || !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{contentDTO.getSubject()})) continue;
            MailContentEntity mailContentEntity = this.toMailContentEntity(contentDTO);
            mailContentEntity.setMailTemplateEntity(newTemplate);
            MailContentEntity mailContentEntity_ = (MailContentEntity)this.mailContentDAO.create(mailContentEntity);
            contentsEntities.add(mailContentEntity_);
        }
        return this.toMailTemplateDTO(newTemplate);
    }

    public MailTemplateEntity getTemplatebyId(Long id) {
        return (MailTemplateEntity)this.mailTemplateDAO.find(id);
    }

    public List<MailTemplateEntity> getTemplatesbyEvent(String event) {
        return this.mailTemplateDAO.getTemplatesbyEvent(event);
    }

    public void deleteTemplate(MailTemplateEntity mailTemplateEntity) {
        ArrayList contents = new ArrayList();
        this.mailContentDAO.deleteAll(this.mailContentDAO.getContentByTemplate(mailTemplateEntity.getId()));
        this.mailTemplateDAO.delete(mailTemplateEntity);
    }

    public MailTemplateDTO updateTemplate(MailTemplateDTO templateDTO) {
        this.mailContentDAO.updateAll(this.toMailContentEntitiesList(templateDTO.getContents()));
        MailTemplateEntity newTemplate = (MailTemplateEntity)this.mailTemplateDAO.update(this.toMailTemplateEntity(templateDTO));
        return this.toMailTemplateDTO(newTemplate);
    }

    public List<MailContentEntity> toMailContentEntitiesList(List<MailContentDTO> contents) {
        ArrayList<MailContentEntity> mailContentEntityList = new ArrayList<MailContentEntity>();
        for (MailContentDTO mailContentDTO : contents) {
            mailContentEntityList.add(this.toMailContentEntity(mailContentDTO));
        }
        return mailContentEntityList;
    }

    public MailTemplateDTO toMailTemplateDTO(MailTemplateEntity mailTemplateEntity) {
        MailTemplateDTO mailTemplateDTO = new MailTemplateDTO();
        mailTemplateDTO.setId(mailTemplateEntity.getId());
        mailTemplateDTO.setName(mailTemplateEntity.getName());
        mailTemplateDTO.setDescription(mailTemplateEntity.getDescription());
        mailTemplateDTO.setEvent(mailTemplateEntity.getEvent());
        mailTemplateDTO.setField(mailTemplateEntity.getField());
        mailTemplateDTO.setForm(mailTemplateEntity.getForm());
        ArrayList<MailContentDTO> contents = new ArrayList<MailContentDTO>();
        for (MailContentEntity content : this.mailContentDAO.getContentByTemplate(mailTemplateEntity.getId())) {
            if (content == null) continue;
            contents.add(this.toMailContentDTO(content));
        }
        mailTemplateDTO.setContents(contents);
        return mailTemplateDTO;
    }

    public MailTemplateEntity toMailTemplateEntity(MailTemplateDTO mailTemplateDTO) {
        MailTemplateEntity mailTemplateEntity = new MailTemplateEntity();
        mailTemplateEntity.setId(mailTemplateDTO.getId());
        mailTemplateEntity.setName(mailTemplateDTO.getName());
        mailTemplateEntity.setDescription(mailTemplateDTO.getDescription());
        mailTemplateEntity.setEvent(mailTemplateDTO.getEvent());
        mailTemplateEntity.setField(mailTemplateDTO.getField());
        mailTemplateEntity.setForm(mailTemplateDTO.getForm());
        return mailTemplateEntity;
    }

    public MailContentEntity toMailContentEntity(MailContentDTO mailContentDTO) {
        MailContentEntity mailContentEntity = new MailContentEntity();
        mailContentEntity.setId(mailContentDTO.getId());
        mailContentEntity.setContent(mailContentDTO.getContent());
        mailContentEntity.setLanguage(mailContentDTO.getLanguage());
        mailContentEntity.setSubject(mailContentDTO.getSubject());
        if (mailContentDTO.getMailTemplateDTO() != null) {
            mailContentEntity.setMailTemplateEntity(this.toMailTemplateEntity(mailContentDTO.getMailTemplateDTO()));
        }
        return mailContentEntity;
    }

    public MailContentDTO toMailContentDTO(MailContentEntity mailContentEntity) {
        MailContentDTO mailContentDTO = new MailContentDTO();
        mailContentDTO.setId(mailContentEntity.getId());
        mailContentDTO.setContent(mailContentEntity.getContent());
        mailContentDTO.setLanguage(mailContentEntity.getLanguage());
        mailContentDTO.setSubject(mailContentEntity.getSubject());
        if (mailContentEntity.getMailTemplateEntity() != null) {
            MailTemplateDTO mailTemplateDTO = new MailTemplateDTO();
            mailTemplateDTO.setId(mailContentEntity.getMailTemplateEntity().getId());
            mailTemplateDTO.setEvent(mailContentEntity.getMailTemplateEntity().getEvent());
            mailTemplateDTO.setForm(mailContentEntity.getMailTemplateEntity().getForm());
            mailTemplateDTO.setField(mailContentEntity.getMailTemplateEntity().getField());
            mailTemplateDTO.setDescription(mailContentEntity.getMailTemplateEntity().getDescription());
            mailTemplateDTO.setName(mailContentEntity.getMailTemplateEntity().getForm());
            mailContentDTO.setMailTemplateDTO(mailTemplateDTO);
        }
        return mailContentDTO;
    }
}

