/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.lecko;

import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.addons.lecko.SimpleDataBuilder;
import org.exoplatform.addons.lecko.social.client.rest.connector.ExoSocialConnector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

abstract class SocialActivity {
    protected static Log LOG = ExoLogger.getLogger(SimpleDataBuilder.class);
    protected static Map<String, String> user_map = new ConcurrentHashMap<String, String>();
    ExoSocialConnector exoSocialConnector;

    SocialActivity() {
    }

    public abstract void loadActivityStream(PrintWriter var1) throws Exception;

    public static JSONArray parseJSONArray(String json, String entry) throws ParseException, JSONException {
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(json);
        JSONObject jsonObject = (JSONObject)obj;
        JSONArray listEntry = (JSONArray)jsonObject.get((Object)entry);
        return listEntry;
    }

    protected void getExoComments(String url, String placeName, String displayName, PrintWriter out) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting Comments : " + placeName));
        }
        String idEvent = "";
        String date = "";
        String idactor = "";
        String result = this.exoSocialConnector.getActivityComments(url);
        if (result == null) {
            return;
        }
        JSONArray jsonComments = SocialActivity.parseJSONArray(result, "comments");
        if (jsonComments == null || jsonComments.size() == 0) {
            return;
        }
        for (Object obj : jsonComments) {
            JSONObject js = (JSONObject)obj;
            idactor = ((String)js.get((Object)"identity")).split("/")[7];
            if (!user_map.containsKey(idactor)) {
                user_map.put(idactor, Integer.toString(user_map.size() + 1));
                idactor = user_map.get(idactor);
            } else {
                idactor = user_map.get(idactor);
            }
            out.print(idactor + ";");
            idEvent = "comment";
            out.print(idEvent + ";");
            date = (String)js.get((Object)"createDate");
            out.print(date + ";");
            out.print(placeName + ";" + displayName + ";");
            out.println();
        }
        out.flush();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("End Getting Comments : " + placeName));
        }
    }

    protected void getLikes(String url, String date, String placeName, String displayName, PrintWriter out) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting Likes : " + placeName));
        }
        String idEvent = "";
        String idactor = "";
        String result = this.exoSocialConnector.getActivityLikes(url);
        if (result == null) {
            return;
        }
        JSONArray jsonLikes = SocialActivity.parseJSONArray(result, "likes");
        if (jsonLikes == null || jsonLikes.size() == 0) {
            return;
        }
        for (Object obj : jsonLikes) {
            JSONObject js = (JSONObject)obj;
            idactor = ((String)js.get((Object)"identity")).split("/")[7];
            if (!user_map.containsKey(idactor)) {
                user_map.put(idactor, Integer.toString(user_map.size() + 1));
                idactor = user_map.get(idactor);
            } else {
                idactor = user_map.get(idactor);
            }
            out.print(idactor + ";");
            idEvent = "like";
            out.print(idEvent + ";");
            out.print(date + ";");
            out.print(placeName + ";" + displayName + ";");
            out.println();
        }
        out.flush();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("End Getting Likes : " + placeName));
        }
    }
}

