/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.lecko.social.client.rest.connector;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.exoplatform.addons.lecko.social.client.rest.connector.ExoSocialConnector;
import org.exoplatform.addons.lecko.social.client.rest.connector.HttpUtils;
import org.exoplatform.addons.lecko.social.client.rest.connector.ServiceInfo;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExoSocialConnectorImpl
implements ExoSocialConnector {
    private static final Log log = ExoLogger.getLogger(ExoSocialConnectorImpl.class);
    private String userName;
    private String password;
    private String baseUrl;
    private String defaultBaseUrl = "http://localhost:8080";

    public ExoSocialConnectorImpl(InitParams initParams) {
        this.userName = initParams.getValueParam("username").getValue();
        this.password = initParams.getValueParam("password").getValue();
        this.baseUrl = initParams.getValueParam("baseUrl").getValue();
        if (this.userName == null || this.userName.length() == 0) {
            log.warn((Object)"Property 'userName' needs to be provided.");
        }
        if (this.baseUrl == null || this.baseUrl.length() == 0) {
            this.baseUrl = this.defaultBaseUrl;
        }
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(ExoSocialConnectorImpl.this.userName, ExoSocialConnectorImpl.this.password.toCharArray());
            }
        });
    }

    @Override
    public String getUserById(String username) throws Exception {
        String url = this.baseUrl + ServiceInfo.getUserUri(username);
        String json = HttpUtils.get(url);
        return json;
    }

    @Override
    public String getSpaces(int offset, int limit) throws Exception {
        String url = this.baseUrl + ServiceInfo.getSpacesUri(offset, limit);
        String json = HttpUtils.get(url);
        return json;
    }

    @Override
    public String getUsers(int offset, int limit) throws Exception {
        String url = this.baseUrl + ServiceInfo.getUsersUri(offset, limit);
        String json = HttpUtils.get(url);
        return json;
    }

    @Override
    public String getActivitiesBySpaceID(String id, int offset, int limit) throws Exception {
        String url = this.baseUrl + ServiceInfo.getSpaceActivities(id, offset, limit);
        String json = HttpUtils.get(url);
        return json;
    }

    @Override
    public String getActivitiesByUserID(String id, int offset, int limit) throws Exception {
        String url = this.baseUrl + ServiceInfo.getUserActivities(id, offset, limit);
        String json = HttpUtils.get(url);
        return json;
    }

    @Override
    public String getActivityComments(String url) throws Exception {
        String newUrl = ServiceInfo.getActivityData(url);
        String json = HttpUtils.get(newUrl);
        return json;
    }

    @Override
    public String getActivityLikes(String url) throws Exception {
        String newUrl = ServiceInfo.getActivityData(url);
        String json = HttpUtils.get(newUrl);
        return json;
    }
}

