/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.lecko.social.rest.api;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.addons.lecko.social.rest.api.Utils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.BaseEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.CommentEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.social.rest.entity.LinkEntity;
import org.exoplatform.social.rest.entity.ProfileEntity;
import org.exoplatform.social.rest.entity.RelationshipEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;
import org.exoplatform.social.rest.entity.SpaceMembershipEntity;

public class EntityBuilder {
    public static final String USERS_TYPE = "users";
    public static final String USERS_RELATIONSHIP_TYPE = "usersRelationships";
    public static final String USER_ACTIVITY_TYPE = "user";
    public static final String IDENTITIES_TYPE = "identities";
    public static final String SPACES_TYPE = "spaces";
    public static final String SPACES_MEMBERSHIP_TYPE = "spacesMemberships";
    public static final String SPACE_ACTIVITY_TYPE = "space";
    public static final String ACTIVITIES_TYPE = "activities";
    public static final String COMMENTS_TYPE = "comments";
    public static final String LIKES_TYPE = "likes";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private static final String NEXT_ACTION = "next";
    private static final String PREV_ACTION = "prev";
    private static final String FIRST_ACTION = "first";
    private static final String LAST_ACTION = "last";
    private static final String LINK = "Link";

    public static IdentityEntity buildEntityIdentity(Identity identity, String restPath, String expand) {
        IdentityEntity idntityEntity = new IdentityEntity(identity.getId());
        idntityEntity.setHref(RestUtils.getRestUrl((String)IDENTITIES_TYPE, (String)identity.getId(), (String)restPath));
        idntityEntity.setProviderId(identity.getProviderId());
        idntityEntity.setGlobalId(identity.getGlobalId());
        idntityEntity.setDeleted(Boolean.valueOf(identity.isDeleted()));
        if ("organization".equals(identity.getProviderId())) {
            idntityEntity.setProfile(EntityBuilder.buildEntityProfile(identity.getProfile(), restPath, ""));
        }
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(identity.getId()));
        return idntityEntity;
    }

    public static IdentityEntity buildEntityIdentity(String userName, String restPath, String expand) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", userName, true);
        return EntityBuilder.buildEntityIdentity(userIdentity, restPath, expand);
    }

    public static ProfileEntity buildEntityProfile(Profile profile, String restPath, String expand) {
        ProfileEntity userEntity = new ProfileEntity(profile.getId());
        userEntity.setHref(RestUtils.getRestUrl((String)USERS_TYPE, (String)profile.getIdentity().getRemoteId(), (String)restPath));
        userEntity.setIdentity(RestUtils.getRestUrl((String)IDENTITIES_TYPE, (String)profile.getIdentity().getId(), (String)restPath));
        userEntity.setUsername(profile.getIdentity().getRemoteId());
        if (profile.getProperty("firstName") != null) {
            userEntity.setFirstname(profile.getProperty("firstName").toString());
        }
        if (profile.getProperty("lastName") != null) {
            userEntity.setLastname(profile.getProperty("lastName").toString());
        }
        userEntity.setFullname(profile.getFullName());
        userEntity.setGender(profile.getGender());
        userEntity.setPosition(profile.getPosition());
        userEntity.setEmail(profile.getEmail());
        userEntity.setAvatar(profile.getAvatarUrl());
        userEntity.setPhones(EntityBuilder.getSubListByProperties(profile.getPhones(), EntityBuilder.getPhoneProperties()));
        userEntity.setExperiences(EntityBuilder.getSubListByProperties((List)profile.getProperty("experiences"), EntityBuilder.getExperiencesProperties()));
        userEntity.setIms(EntityBuilder.getSubListByProperties((List)profile.getProperty("ims"), EntityBuilder.getImsProperties()));
        userEntity.setUrls(EntityBuilder.getSubListByProperties((List)profile.getProperty("urls"), EntityBuilder.getUrlProperties()));
        userEntity.setDeleted(Boolean.valueOf(profile.getIdentity().isDeleted()));
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(profile.getId()));
        return userEntity;
    }

    public static ProfileEntity buildEntityProfile(String userName, String restPath, String expand) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", userName, true);
        return EntityBuilder.buildEntityProfile(userIdentity.getProfile(), restPath, expand);
    }

    public static List<DataEntity> buildEntityProfiles(String[] userNames, String restPath, String expand) {
        if (userNames == null || userNames.length == 0) {
            return new ArrayList<DataEntity>();
        }
        ArrayList<DataEntity> userEntities = new ArrayList<DataEntity>();
        for (int i = 0; i < userNames.length; ++i) {
            userEntities.add(EntityBuilder.buildEntityProfile(userNames[i], restPath, expand).getDataEntity());
        }
        return userEntities;
    }

    public static SpaceEntity buildEntityFromSpace(Space space, String userId, String restPath, String expand) {
        SpaceEntity spaceEntity = new SpaceEntity(space.getId());
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId) || RestUtils.isMemberOfAdminGroup() || Utils.isMemberOfAPIAccessGroup()) {
            spaceEntity.setHref(RestUtils.getRestUrl((String)SPACES_TYPE, (String)space.getId(), (String)restPath));
            Identity spaceIdentity = identityManager.getOrCreateIdentity(SPACE_ACTIVITY_TYPE, space.getPrettyName(), true);
            LinkEntity identity = "identity".equals(expand) ? new LinkEntity((BaseEntity)EntityBuilder.buildEntityIdentity(spaceIdentity, restPath, null)) : new LinkEntity(RestUtils.getRestUrl((String)IDENTITIES_TYPE, (String)spaceIdentity.getId(), (String)restPath));
            spaceEntity.setIdentity(identity);
            spaceEntity.setGroupId(space.getGroupId());
            spaceEntity.setApplications(EntityBuilder.getSpaceApplications(space));
            LinkEntity managers = "managers".equals(expand) ? new LinkEntity(EntityBuilder.buildEntityProfiles(space.getManagers(), restPath, expand)) : new LinkEntity(EntityBuilder.getMembersSpaceRestUrl(space.getId(), true, restPath));
            spaceEntity.setManagers(managers);
            LinkEntity memebers = "members".equals(expand) ? new LinkEntity(EntityBuilder.buildEntityProfiles(space.getMembers(), restPath, expand)) : new LinkEntity(EntityBuilder.getMembersSpaceRestUrl(space.getId(), false, restPath));
            spaceEntity.setMembers(memebers);
        }
        spaceEntity.setDisplayName(space.getDisplayName());
        spaceEntity.setDescription(space.getDescription());
        spaceEntity.setUrl(LinkProvider.getSpaceUri((String)space.getPrettyName()));
        spaceEntity.setAvatarUrl(space.getAvatarUrl());
        spaceEntity.setVisibility(space.getVisibility());
        spaceEntity.setSubscription(space.getRegistration());
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(space.getId()));
        return spaceEntity;
    }

    public static SpaceMembershipEntity buildEntityFromSpaceMembership(Space space, String userId, String type, String restPath, String expand) {
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(type));
        String id = space.getPrettyName() + ":" + userId + ":" + type;
        SpaceMembershipEntity spaceMembership = new SpaceMembershipEntity(id);
        spaceMembership.setHref(RestUtils.getRestUrl((String)SPACES_MEMBERSHIP_TYPE, (String)id, (String)restPath));
        LinkEntity userEntity = USERS_TYPE.equals(expand) ? new LinkEntity((BaseEntity)EntityBuilder.buildEntityProfile(userId, restPath, "")) : new LinkEntity(RestUtils.getRestUrl((String)USERS_TYPE, (String)userId, (String)restPath));
        spaceMembership.setDataUser(userEntity);
        LinkEntity spaceEntity = SPACES_TYPE.equals(expand) ? new LinkEntity((BaseEntity)EntityBuilder.buildEntityProfile(userId, restPath, "")) : new LinkEntity(RestUtils.getRestUrl((String)SPACES_TYPE, (String)space.getId(), (String)restPath));
        spaceMembership.setDataSpace(spaceEntity);
        spaceMembership.setRole(type);
        spaceMembership.setStatus("approved");
        return spaceMembership;
    }

    public static ActivityEntity buildEntityFromActivity(ExoSocialActivity activity, String restPath, String expand) {
        LinkEntity commentLink;
        Identity poster = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getIdentity(activity.getPosterId(), true);
        ActivityEntity activityEntity = new ActivityEntity(activity);
        activityEntity.setHref(RestUtils.getRestUrl((String)ACTIVITIES_TYPE, (String)activity.getId(), (String)restPath));
        LinkEntity identityLink = expand != null && "identity".equals(expand) ? new LinkEntity((BaseEntity)EntityBuilder.buildEntityIdentity(poster, restPath, null)) : new LinkEntity(RestUtils.getRestUrl((String)IDENTITIES_TYPE, (String)activity.getPosterId(), (String)restPath));
        activityEntity.setDatIdentity(identityLink);
        activityEntity.setOwner(EntityBuilder.getActivityOwner(poster, restPath));
        activityEntity.setMentions(EntityBuilder.getActivityMentions(activity, restPath));
        activityEntity.setAttachments(new ArrayList());
        if (expand != null && COMMENTS_TYPE.equals(expand)) {
            List<DataEntity> commentsEntity = EntityBuilder.buildEntityFromComment(activity, restPath, "", 0, 0);
            commentLink = new LinkEntity(commentsEntity);
        } else {
            commentLink = new LinkEntity(EntityBuilder.getCommentsActivityRestUrl(activity.getId(), restPath));
        }
        activityEntity.setComments(commentLink);
        activityEntity.setLikes(new LinkEntity(RestUtils.getBaseRestUrl() + "/" + "v1" + "/social/activities/" + activity.getId() + "/likes"));
        activityEntity.setCreateDate(RestUtils.formatISO8601((Date)new Date(activity.getPostedTime())));
        activityEntity.setUpdateDate(RestUtils.formatISO8601((Date)activity.getUpdated()));
        EntityBuilder.updateCachedLastModifiedValue(activity.getUpdated());
        return activityEntity;
    }

    public static CommentEntity buildEntityFromComment(ExoSocialActivity comment, String restPath, String expand, boolean isBuildList) {
        Identity poster = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getIdentity(comment.getPosterId(), true);
        CommentEntity commentEntity = new CommentEntity(comment.getId());
        commentEntity.setHref(RestUtils.getRestUrl((String)ACTIVITIES_TYPE, (String)comment.getId(), (String)restPath));
        LinkEntity identityLink = expand != null && "identity".equals(expand) ? new LinkEntity((BaseEntity)EntityBuilder.buildEntityIdentity(poster, restPath, null)) : new LinkEntity(RestUtils.getRestUrl((String)IDENTITIES_TYPE, (String)comment.getPosterId(), (String)restPath));
        commentEntity.setDataIdentity(identityLink);
        commentEntity.setPoster(poster.getRemoteId());
        commentEntity.setBody(comment.getTitle());
        commentEntity.setMentions(EntityBuilder.getActivityMentions(comment, restPath));
        commentEntity.setCreateDate(RestUtils.formatISO8601((Date)new Date(comment.getPostedTime())));
        commentEntity.setUpdateDate(RestUtils.formatISO8601((Date)comment.getUpdated()));
        commentEntity.setActivity(RestUtils.getRestUrl((String)ACTIVITIES_TYPE, (String)comment.getParentId(), (String)restPath));
        if (!isBuildList) {
            EntityBuilder.updateCachedLastModifiedValue(comment.getUpdated());
        }
        return commentEntity;
    }

    public static List<DataEntity> buildEntityFromComment(ExoSocialActivity activity, String restPath, String expand, int offset, int limit) {
        ArrayList<DataEntity> commentsEntity = new ArrayList<DataEntity>();
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        RealtimeListAccess listAccess = activityManager.getCommentsWithListAccess(activity);
        List comments = listAccess.loadAsList(offset, limit);
        for (ExoSocialActivity comment : comments) {
            CommentEntity commentInfo = EntityBuilder.buildEntityFromComment(comment, restPath, expand, true);
            commentsEntity.add(commentInfo.getDataEntity());
        }
        return commentsEntity;
    }

    public static List<DataEntity> buildEntityFromLike(ExoSocialActivity activity, String restPath, String expand, int offset, int limit) {
        ArrayList<DataEntity> likesEntity = new ArrayList<DataEntity>();
        List<String> likerIds = Arrays.asList(activity.getLikeIdentityIds());
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        for (String likerId : likerIds) {
            ProfileEntity likerInfo = EntityBuilder.buildEntityProfile(identityManager.getIdentity(likerId, false).getRemoteId(), restPath, expand);
            likesEntity.add(likerInfo.getDataEntity());
        }
        return likesEntity;
    }

    public static RelationshipEntity buildEntityRelationship(Relationship relationship, String restPath, String expand, boolean isSymetric) {
        RelationshipEntity relationshipEntity = new RelationshipEntity(relationship.getId());
        relationshipEntity.setHref(RestUtils.getRestUrl((String)USERS_RELATIONSHIP_TYPE, (String)relationship.getId(), (String)restPath));
        LinkEntity sender = "sender".equals(expand) ? new LinkEntity((BaseEntity)EntityBuilder.buildEntityProfile(relationship.getSender().getProfile(), restPath, null)) : new LinkEntity(RestUtils.getRestUrl((String)USERS_TYPE, (String)relationship.getSender().getRemoteId(), (String)restPath));
        relationshipEntity.setDataSender(sender);
        LinkEntity receiver = "receiver".equals(expand) ? new LinkEntity((BaseEntity)EntityBuilder.buildEntityProfile(relationship.getReceiver().getProfile(), restPath, null)) : new LinkEntity(RestUtils.getRestUrl((String)USERS_TYPE, (String)relationship.getReceiver().getRemoteId(), (String)restPath));
        relationshipEntity.setDataReceiver(receiver);
        relationshipEntity.setStatus(relationship.getStatus().name());
        if (isSymetric) {
            relationshipEntity.setSymetric(Boolean.valueOf(relationship.isSymetric()));
        }
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(relationship.getId()));
        return relationshipEntity;
    }

    public static List<DataEntity> buildRelationshipEntities(List<Relationship> relationships, UriInfo uriInfo) {
        ArrayList<DataEntity> infos = new ArrayList<DataEntity>();
        for (Relationship relationship : relationships) {
            infos.add(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), RestUtils.getQueryParam((UriInfo)uriInfo, (String)"expand"), true).getDataEntity());
        }
        return infos;
    }

    private static DataEntity getActivityOwner(Identity owner, String restPath) {
        BaseEntity mentionEntity = new BaseEntity(owner.getId());
        mentionEntity.setHref(RestUtils.getRestUrl((String)USERS_TYPE, (String)owner.getRemoteId(), (String)restPath));
        return mentionEntity.getDataEntity();
    }

    private static List<DataEntity> getActivityMentions(ExoSocialActivity activity, String restPath) {
        ArrayList<DataEntity> mentions = new ArrayList<DataEntity>();
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        for (String mentionner : activity.getMentionedIds()) {
            String mentionnerId = mentionner.split("@")[0];
            mentions.add(EntityBuilder.getActivityOwner(identityManager.getIdentity(mentionnerId, false), restPath));
        }
        return mentions;
    }

    public static DataEntity getActivityStream(ExoSocialActivity activity, Identity authentiatedUsed) {
        DataEntity as = new DataEntity();
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity owner = identityManager.getOrCreateIdentity("organization", activity.getStreamOwner(), true);
        if (owner != null) {
            Relationship relationship = ((RelationshipManager)CommonsUtils.getService(RelationshipManager.class)).get(authentiatedUsed, owner);
            if (!(authentiatedUsed.getId().equals(activity.getPosterId()) || authentiatedUsed.getRemoteId().equals(activity.getStreamOwner()) || relationship != null && relationship.getStatus().equals((Object)Relationship.Type.CONFIRMED) || RestUtils.isMemberOfAdminGroup() || Utils.isMemberOfAPIAccessGroup())) {
                return null;
            }
            as.put((Object)"type", (Object)USER_ACTIVITY_TYPE);
        } else {
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space space = spaceService.getSpaceByPrettyName((owner = identityManager.getOrCreateIdentity(SPACE_ACTIVITY_TYPE, activity.getStreamOwner(), true)).getRemoteId());
            if (space == null || !spaceService.isMember(space, authentiatedUsed.getRemoteId()) && !Utils.isMemberOfAPIAccessGroup()) {
                return null;
            }
            as.put((Object)"type", (Object)SPACE_ACTIVITY_TYPE);
        }
        as.put((Object)"id", (Object)owner.getRemoteId());
        return as;
    }

    private static List<DataEntity> getSpaceApplications(Space space) {
        ArrayList<DataEntity> spaceApplications = new ArrayList<DataEntity>();
        String installedApps = space.getApp();
        if (installedApps != null) {
            String[] appStatuses;
            for (String appStatus : appStatuses = installedApps.split(",")) {
                String[] apps = appStatus.split(":");
                BaseEntity app = new BaseEntity(apps[0]);
                app.setProperty("displayName", (Object)(apps.length > 1 ? apps[1] : ""));
                spaceApplications.add(app.getDataEntity());
            }
        }
        return spaceApplications;
    }

    private static List<DataEntity> getSubListByProperties(List<Map<String, String>> sources, Map<String, String> properties) {
        ArrayList<DataEntity> results = new ArrayList<DataEntity>();
        if (sources == null || sources.size() == 0) {
            return results;
        }
        for (Map<String, String> map : sources) {
            if (map.isEmpty()) continue;
            BaseEntity result = new BaseEntity();
            for (Map.Entry<String, String> property : properties.entrySet()) {
                result.setProperty(property.getKey(), (Object)map.get(property.getValue()));
            }
            results.add(result.getDataEntity());
        }
        return results;
    }

    private static Map<String, String> getPhoneProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("phoneType", KEY);
        properties.put("phoneNumber", VALUE);
        return properties;
    }

    private static Map<String, String> getImsProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("imType", KEY);
        properties.put("imId", VALUE);
        return properties;
    }

    private static Map<String, String> getUrlProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("url", VALUE);
        return properties;
    }

    private static Map<String, String> getExperiencesProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("company", "company");
        properties.put("description", "description");
        properties.put("position", "position");
        properties.put("skills", "skills");
        properties.put("isCurrent", "isCurrent");
        properties.put("startDate", "startDate");
        properties.put("endDate", "endDate");
        return properties;
    }

    private static void updateCachedEtagValue(int etagValue) {
        ApplicationContext ac = ApplicationContextImpl.getCurrent();
        Map properties = ac.getProperties();
        ConcurrentHashMap props = new ConcurrentHashMap(properties);
        if (props.containsKey("ETag")) {
            props.remove("ETag");
        }
        if (props.containsKey("updateDate")) {
            props.remove("updateDate");
        }
        ac.setProperty("ETag", String.valueOf(etagValue));
        ApplicationContextImpl.setCurrent((ApplicationContext)ac);
    }

    private static void updateCachedLastModifiedValue(Date lastModifiedDate) {
        ApplicationContext ac = ApplicationContextImpl.getCurrent();
        Map properties = ac.getProperties();
        ConcurrentHashMap props = new ConcurrentHashMap(properties);
        if (props.containsKey("updateDate")) {
            props.remove("updateDate");
        }
        if (props.containsKey("ETag")) {
            props.remove("ETag");
        }
        ac.setProperty("updateDate", String.valueOf(lastModifiedDate.getTime()));
        ApplicationContextImpl.setCurrent((ApplicationContext)ac);
    }

    private static int getEtagValue(String ... properties) {
        int prime = 31;
        int result = 0;
        for (String prop : properties) {
            if (prop == null) continue;
            result = 31 * result + prop.hashCode();
        }
        return result;
    }

    public static String getMembersSpaceRestUrl(String id, boolean returnManager, String restPath) {
        StringBuffer spaceMembersRestUrl = new StringBuffer(RestUtils.getRestUrl((String)SPACES_TYPE, (String)id, (String)restPath)).append("/").append(USERS_TYPE);
        if (returnManager) {
            return spaceMembersRestUrl.append("?role=manager").toString();
        }
        return spaceMembersRestUrl.toString();
    }

    public static String getCommentsActivityRestUrl(String activityId, String restPath) {
        return new StringBuffer(RestUtils.getRestUrl((String)ACTIVITIES_TYPE, (String)activityId, (String)restPath)).append("/").append(COMMENTS_TYPE).toString();
    }

    public static Response getResponse(Object entity, UriInfo uriInfo, MediaType mediaType, Response.Status status) {
        if (entity instanceof BaseEntity) {
            entity = ((BaseEntity)entity).getDataEntity();
        }
        Response resp = Response.created((URI)uriInfo.getAbsolutePath()).entity(entity).type(mediaType.toString() + "; charset=utf-8").status(status).build();
        if (!EntityBuilder.hasPaging(entity)) {
            return resp;
        }
        Response.ResponseBuilder responseBuilder = Response.fromResponse((Response)resp);
        responseBuilder.header(LINK, EntityBuilder.buildLinkForHeader(entity, uriInfo.getAbsolutePath().toString()));
        return responseBuilder.build();
    }

    private static boolean hasPaging(Object entity) {
        if (!(entity instanceof CollectionEntity)) {
            return false;
        }
        CollectionEntity rc = (CollectionEntity)entity;
        int size = rc.getSize();
        int offset = rc.getOffset();
        int limit = rc.getLimit();
        return size > 0 && limit != 0 && offset <= size && size > limit;
    }

    public static Object buildLinkForHeader(Object entity, String requestPath) {
        CollectionEntity rc = (CollectionEntity)entity;
        int size = rc.getSize();
        int offset = rc.getOffset();
        int limit = rc.getLimit();
        StringBuilder linkHeader = new StringBuilder();
        if (EntityBuilder.hasNext(size, offset, limit)) {
            int nextOS = offset + limit;
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, nextOS, limit, NEXT_ACTION));
        }
        if (EntityBuilder.hasPrevious(size, offset, limit)) {
            int preOS = offset - limit;
            EntityBuilder.appendCommaIfNecessary(linkHeader);
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, preOS, limit, PREV_ACTION));
        }
        if (EntityBuilder.hasFirst(size, offset, limit)) {
            EntityBuilder.appendCommaIfNecessary(linkHeader);
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, 0, limit, FIRST_ACTION));
        }
        if (EntityBuilder.hasLast(size, offset, limit)) {
            int pages = (int)Math.ceil((double)size / (double)limit);
            int lastOS = (pages - 1) * limit;
            EntityBuilder.appendCommaIfNecessary(linkHeader);
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, lastOS, limit, LAST_ACTION));
        }
        return linkHeader.toString();
    }

    private static boolean hasNext(int size, int offset, int limit) {
        return size > offset + limit;
    }

    private static boolean hasPrevious(int size, int offset, int limit) {
        if (offset == 0) {
            return false;
        }
        return offset >= limit;
    }

    private static boolean hasFirst(int size, int offset, int limit) {
        return EntityBuilder.hasPrevious(size, offset, limit);
    }

    private static boolean hasLast(int size, int offset, int limit) {
        if (offset + limit == size) {
            return false;
        }
        return EntityBuilder.hasNext(size, offset, limit);
    }

    private static void appendCommaIfNecessary(StringBuilder linkHeader) {
        if (linkHeader.length() > 0) {
            linkHeader.append(", ");
        }
    }

    private static String createLinkHeader(String uri, int offset, int limit, String rel) {
        return "<" + uri + "?offset=" + offset + "&limit=" + limit + ">; rel=\"" + rel + "\"";
    }
}

