/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.lecko;

import java.io.File;
import org.exoplatform.addons.lecko.DataBuilder;
import org.exoplatform.addons.lecko.JobStatusService;
import org.exoplatform.addons.lecko.SimpleDataBuilder;
import org.exoplatform.addons.lecko.Utils.SftpClient;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="LeckoServiceController")})
@ManagedDescription(value="Lecko management jobs")
public class LeckoServiceController
implements Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.addons.lecko.LeckoServiceController");
    private static String rootPath;
    private static String fileName;
    private static final String LECKO_ENABLED = "exo.addons.lecko.job.enabled";
    private static final String LECKO_OUTPUT_NAME = "exo.addons.lecko.out.name";
    private static final String LECKO_OUTPUT_DIRECTORY_NAME = "exo.addons.lecko.directory.out.name";
    private static String path;
    private DataBuilder dataBuilder;

    public static String getRootPath() {
        return rootPath;
    }

    public static String getFileName() {
        return fileName;
    }

    public LeckoServiceController() {
        rootPath = PropertyManager.getProperty((String)LECKO_OUTPUT_DIRECTORY_NAME) != null ? PropertyManager.getProperty((String)LECKO_OUTPUT_DIRECTORY_NAME) : PropertyManager.getProperty((String)"java.io.tmpdir") + "/lecko";
        File directory = new File(rootPath);
        if (!PrivilegedFileHelper.exists((File)directory)) {
            PrivilegedFileHelper.mkdirs((File)directory);
        }
        fileName = PropertyManager.getProperty((String)LECKO_OUTPUT_NAME) != null ? PropertyManager.getProperty((String)LECKO_OUTPUT_NAME) : "dump";
        path = rootPath + "/" + (fileName != null && !fileName.isEmpty() ? fileName : "dump");
    }

    @Managed
    @ManagedDescription(value="Build lecko data.")
    public String buildLeckoData() {
        try {
            if (this.dataBuilder == null) {
                this.initDataBuilder();
            }
            if (this.dataBuilder.getBuildStatus()) {
                return "Export is already running";
            }
            new Thread(this.dataBuilder).start();
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage());
            return "Failed";
        }
        return "Job Started";
    }

    @Managed
    @ManagedDescription(value="Get Lecko Job Status.")
    public String getJobStatus() {
        if (this.dataBuilder == null) {
            this.initDataBuilder();
        }
        int percent = this.dataBuilder.getPercent();
        String result = this.dataBuilder.getBuildStatus() ? "Export is running." : "Export is stopped.";
        result = result + " Export is done at " + percent + "% for current extraction.";
        return result;
    }

    @Managed
    @ManagedDescription(value="Stop lecko export.")
    public String stopLeckoExport() {
        try {
            if (this.dataBuilder == null) {
                this.initDataBuilder();
            }
            this.dataBuilder.stopBuild();
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage());
            return "Failed";
        }
        return "Stopping job";
    }

    @Managed
    @ManagedDescription(value="Upload data to lecko server.")
    public String UploadLeckoData() {
        block8: {
            block7: {
                int percent;
                if (this.dataBuilder == null) {
                    this.initDataBuilder();
                }
                if ((percent = this.dataBuilder.getPercent()) >= 100) break block7;
                String string = "Cannot upload file, data not fully exported. Only " + percent + "% done.";
                return string;
            }
            if (!this.dataBuilder.getBuildStatus()) break block8;
            String string = "Export is running, cannot send data.";
            return string;
        }
        try {
            String string = this.doUpload();
            return string;
        }
        catch (Exception ex) {
            LOG.error("Failed send Data to lecko server", new Object[]{ex.getMessage()});
            String string = "Failed";
            return string;
        }
    }

    public String doUpload() {
        File file = new File(path);
        boolean status = false;
        if (file.exists()) {
            SftpClient client = new SftpClient();
            LOG.info((Object)"Start send Data to lecko server");
            status = client.send(file.getAbsolutePath());
            if (status) {
                LOG.info((Object)"End  send Data to lecko server");
                this.resetExtraction();
            } else {
                LOG.info((Object)"Failed send Data to lecko server");
            }
        } else {
            LOG.info("Failed send Data to lecko server file not exist : {}", new Object[]{path});
            return "Failed";
        }
        return status ? "Success" : "Failed";
    }

    @Managed
    @ManagedDescription(value="Enable/Disable lecko job. ")
    public void enableLeckoJob(@ManagedName(value="enable") boolean enable) {
        PropertyManager.setProperty((String)LECKO_ENABLED, (String)Boolean.toString(enable));
    }

    @Managed
    @ManagedDescription(value="Enable/Disable lecko job. ")
    public boolean getEnableLeckoJob() {
        return Boolean.parseBoolean(PropertyManager.getProperty((String)LECKO_ENABLED).trim());
    }

    private void initDataBuilder() {
        SpaceService spaceService = LeckoServiceController.getService(SpaceService.class);
        JobStatusService jobStatusService = LeckoServiceController.getService(JobStatusService.class);
        IdentityManager identityManager = LeckoServiceController.getService(IdentityManager.class);
        ActivityManager activityManager = LeckoServiceController.getService(ActivityManager.class);
        this.dataBuilder = new SimpleDataBuilder(spaceService, identityManager, activityManager, jobStatusService);
    }

    public static <T> T getService(Class<T> clazz) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container.getComponentInstanceOfType(clazz) == null) {
            String containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    @Managed
    @ManagedDescription(value="Reset extraction job")
    public String resetExtraction() {
        if (this.dataBuilder == null) {
            this.initDataBuilder();
        }
        this.dataBuilder.deleteDumpFile();
        JobStatusService jobStatusService = LeckoServiceController.getService(JobStatusService.class);
        return jobStatusService.resetStatus() ? "Success" : "Failed";
    }

    public void start() {
    }

    public void stop() {
    }
}

