/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.lecko;

import java.io.File;
import org.exoplatform.addons.lecko.DataBuilder;
import org.exoplatform.addons.lecko.JobStatusService;
import org.exoplatform.addons.lecko.LeckoServiceController;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SimpleDataBuilder
implements DataBuilder {
    private static Log LOG = ExoLogger.getLogger(SimpleDataBuilder.class);
    private SpaceService spaceService;
    private final String leckoTempDirectory;
    private final String leckoOutputName;
    private JobStatusService jobStatusService;
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private static boolean runBuild = false;
    private final int spaceLimit;
    private final int userLimit;

    public SimpleDataBuilder(SpaceService spaceService, IdentityManager identityManager, ActivityManager activityManager, JobStatusService jobStatusService) {
        this.spaceService = spaceService;
        this.jobStatusService = jobStatusService;
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.leckoTempDirectory = LeckoServiceController.getRootPath();
        File directory = new File(this.leckoTempDirectory);
        this.leckoOutputName = LeckoServiceController.getFileName();
        this.spaceLimit = PropertyManager.getProperty((String)"exo.addon.lecko.spaceLimit") != null ? Integer.parseInt(PropertyManager.getProperty((String)"exo.addon.lecko.spaceLimit")) : -1;
        this.userLimit = PropertyManager.getProperty((String)"exo.addon.lecko.userLimit") != null ? Integer.parseInt(PropertyManager.getProperty((String)"exo.addon.lecko.userLimit")) : -1;
    }

    @Override
    public void stopBuild() {
        runBuild = false;
    }

    @Override
    public boolean getBuildStatus() {
        return runBuild;
    }

    @Override
    public int getPercent() {
        ListAccess spaceListAccess = this.spaceService.getAllSpacesWithListAccess();
        ListAccess userListAccess = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getIdentitiesByProfileFilter("organization", new ProfileFilter(), false);
        try {
            return (int)((double)this.jobStatusService.countStatus().longValue() / (double)(spaceListAccess.getSize() + userListAccess.getSize()) * 100.0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void resumeBuild() {
        runBuild = true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean build() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void deleteDumpFile() {
        String extractOutputPath = this.leckoTempDirectory + "/" + this.leckoOutputName;
        File file = new File(extractOutputPath);
        file.delete();
    }

    @Override
    public void run() {
        EntityManagerService service = (EntityManagerService)PortalContainer.getInstance().getComponentInstanceOfType(EntityManagerService.class);
        service.startRequest((ExoContainer)PortalContainer.getInstance());
        this.build();
        LeckoServiceController.getService(LeckoServiceController.class).doUpload();
        service.endRequest((ExoContainer)PortalContainer.getInstance());
    }
}

