/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.lecko.Utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SftpClient {
    private static Log LOG = ExoLogger.getLogger(SftpClient.class);
    private static final int DEFAULT_PORT = 22;
    private static final String LECKO_HOST = "exo.addons.lecko.SftpHost";
    private static final String LECKO_USER = "exo.addons.lecko.SftpUser";
    private static final String LECKO_PASSWORD = "exo.addons.lecko.SftpPassword";
    private static final String LECKO_PORT = "exo.addons.lecko.SftPortNumber";
    private static final String LECKO_ACTIVE_PROXY = "exo.addons.lecko.SftpActiveProxy";
    private static final String LECKO_PROXY_ADDRESS = "exo.addons.leckoSftp.ProxyAddress";
    private static final String LECKO_PROXY_PORT = "exo.addons.lecko.SftpProxyPort";
    private static final String LECKO_REMOTE_PATH = "exo.addons.lecko.SftpRemotePath";
    private String host = PropertyManager.getProperty((String)"exo.addons.lecko.SftpHost");
    private String user;
    private String pwd;
    private int port = 22;
    private boolean active;
    private String remotePath;
    private String proxyAdress;
    private int proxyPort;
    private static int DEFAULT_TIMOUT = 3600000;
    private boolean isConfigured = true;

    public SftpClient() {
        String value;
        if (this.host != null) {
            this.host = this.host.trim();
        } else {
            LOG.error((Object)"Property exo.addons.lecko.SftpHost undefined, please define it in the exo.properties file");
            this.isConfigured = false;
        }
        this.user = PropertyManager.getProperty((String)LECKO_USER);
        if (this.user != null) {
            this.user = this.user.trim();
        } else {
            LOG.error((Object)"Property exo.addons.lecko.SftpUser undefined, please define it in the exo.properties file");
            this.isConfigured = false;
        }
        this.pwd = PropertyManager.getProperty((String)LECKO_PASSWORD);
        if (this.pwd != null) {
            this.pwd = this.pwd.trim();
        } else {
            LOG.error((Object)"Property exo.addons.lecko.SftpPassword undefined, please define it in the exo.properties file");
            this.isConfigured = false;
        }
        if (!this.isConfigured) {
            LOG.error((Object)"Missing mandatory properties, SFTP Client is not configured ... so the Lecko dump file will not be send to the FTP server.");
            return;
        }
        this.remotePath = PropertyManager.getProperty((String)LECKO_REMOTE_PATH);
        if (this.remotePath != null) {
            this.remotePath = this.remotePath.trim();
        }
        if ((value = PropertyManager.getProperty((String)LECKO_PORT)) != null) {
            try {
                this.port = Integer.valueOf(value);
            }
            catch (NumberFormatException ex) {
                LOG.error((Object)"Property exo.addons.lecko.SftPortNumber is invalid, using default port: 22");
                this.port = 22;
            }
        }
        value = PropertyManager.getProperty((String)LECKO_ACTIVE_PROXY);
        this.active = Boolean.valueOf(value);
        if (this.active) {
            this.proxyAdress = PropertyManager.getProperty((String)LECKO_PROXY_ADDRESS);
            if (this.proxyAdress != null) {
                this.proxyAdress = this.proxyAdress.trim();
            } else {
                LOG.error((Object)"Mode proxy is enable and property exo.addons.leckoSftp.ProxyAddress undefined");
            }
            String proxyPortString = PropertyManager.getProperty((String)LECKO_PROXY_PORT);
            if (proxyPortString != null) {
                try {
                    this.proxyPort = Integer.valueOf(proxyPortString);
                }
                catch (NumberFormatException ex) {
                    LOG.error((Object)"Mode proxy is enable and property exo.addons.lecko.SftpProxyPort is invalid");
                }
            } else {
                LOG.error((Object)"Mode proxy is enable and property exo.addons.lecko.SftpProxyPort undefined");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(String fileName) {
        Session session = null;
        Channel channel = null;
        ChannelSftp channelSftp = null;
        if (this.isConfigured) {
            try {
                JSch jsch = new JSch();
                LOG.info("Opening a session on the sftp server host={} port={} user={}", new Object[]{this.host, this.port, this.user});
                session = jsch.getSession(this.user, this.host, this.port);
                if (session == null) {
                    LOG.error((Object)"Unable to retrieve an sftp session");
                    boolean bl = false;
                    return bl;
                }
                session.setPassword(this.pwd);
                session.setTimeout(DEFAULT_TIMOUT);
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                session.setConfig(config);
                session.connect();
                LOG.info((Object)"Opening an sftp channel");
                channel = session.openChannel("sftp");
                if (channel == null) {
                    LOG.error((Object)"Unable to connect to the sftp server");
                    boolean bl = false;
                    return bl;
                }
                channel.connect(DEFAULT_TIMOUT);
                channelSftp = (ChannelSftp)channel;
                if (this.remotePath != null) {
                    LOG.info("Changing the remote directory to {}", new Object[]{this.remotePath});
                    channelSftp.cd(this.remotePath);
                }
                LOG.info("Transfering {}", new Object[]{fileName});
                File f = new File(fileName);
                channelSftp.put((InputStream)new FileInputStream(f), f.getName());
                LOG.info("Transfer of {} on the sftp server done", new Object[]{fileName});
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                LOG.error((Object)("Unable to transfer " + fileName), (Throwable)ex);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    LOG.error((Object)e);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (channelSftp != null) {
                    channelSftp.exit();
                }
                if (channel != null) {
                    channel.disconnect();
                }
                if (session != null) {
                    session.disconnect();
                }
            }
        }
        LOG.warn((Object)(" SFTP Client is not configured, Unable to transfer Lecko dump file: " + fileName));
        return false;
    }
}

