/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.lecko.Utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SftpClient {
    private static Log LOG = ExoLogger.getLogger(SftpClient.class);
    private static final int DEFAULT_PORT = 22;
    private static final String LECKO_HOST = "exo.addons.lecko.SftpHost";
    private static final String LECKO_USER = "exo.addons.lecko.SftpUser";
    private static final String LECKO_PASSWORD = "exo.addons.lecko.SftpPassword";
    private static final String LECKO_PORT = "exo.addons.lecko.SftPortNumber";
    private static final String LECKO_ACTIVE_PROXY = "exo.addons.lecko.SftpActiveProxy";
    private static final String LECKO_PROXY_ADDRESS = "exo.addons.leckoSftp.ProxyAddress";
    private static final String LECKO_PROXY_PORT = "exo.addons.lecko.SftpProxyPort";
    private static final String LECKO_REMOTE_PATH = "exo.addons.lecko.SftpRemotePath";
    private static String host;
    private static String user;
    private static String pwd;
    private static int port;
    private static boolean active;
    private static String remotePpath;
    private static String proxyAdress;
    private static String proxyPort;
    private static int DEFAULT_TIMOUT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(String fileName) {
        Session session = null;
        Channel channel = null;
        ChannelSftp channelSftp = null;
        try {
            JSch jsch = new JSch();
            session = jsch.getSession(user, host, port);
            if (session == null) {
                boolean bl = false;
                return bl;
            }
            session.setPassword(pwd);
            session.setTimeout(DEFAULT_TIMOUT);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            channel = session.openChannel("sftp");
            if (channel == null) {
                boolean bl = false;
                return bl;
            }
            channel.connect(DEFAULT_TIMOUT);
            channelSftp = (ChannelSftp)channel;
            if (remotePpath != null) {
                channelSftp.cd(remotePpath);
            }
            File f = new File(fileName);
            channelSftp.put((InputStream)new FileInputStream(f), f.getName());
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage());
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)e.getMessage());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (channelSftp != null) {
                channelSftp.exit();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    static {
        port = 22;
        DEFAULT_TIMOUT = 3600000;
        host = PropertyManager.getProperty((String)LECKO_HOST).trim();
        user = PropertyManager.getProperty((String)LECKO_USER).trim();
        pwd = PropertyManager.getProperty((String)LECKO_PASSWORD);
        remotePpath = PropertyManager.getProperty((String)LECKO_REMOTE_PATH).trim();
        String value = PropertyManager.getProperty((String)LECKO_PORT);
        if (value != null) {
            try {
                port = Integer.valueOf(value);
            }
            catch (NumberFormatException ex) {
                port = 22;
            }
        }
        if (active = Boolean.valueOf(value = PropertyManager.getProperty((String)LECKO_ACTIVE_PROXY)).booleanValue()) {
            proxyAdress = PropertyManager.getProperty((String)LECKO_PROXY_ADDRESS);
            proxyPort = PropertyManager.getProperty((String)LECKO_PROXY_PORT);
        }
    }
}

