/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.portlet.rss;

import com.google.common.base.Strings;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndLink;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.platform.portlet.rss.model.FeedItem;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RssReaderPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getExoLogger(RssReaderPortlet.class);
    public static final String RSS_URL = "RSS_URL";
    public static final String LIMIT_ENTRIES = "LIMIT_ENTRIES";

    protected void doView(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        int limit;
        PortletPreferences preferences = request.getPreferences();
        String url = preferences.getValue(RSS_URL, "http://feeds.feedburner.com/gatein");
        try {
            limit = Integer.parseInt(preferences.getValue(LIMIT_ENTRIES, "10"));
        }
        catch (NumberFormatException ex) {
            limit = 10;
        }
        if (limit < 1) {
            limit = 1;
        }
        if (limit > 100) {
            limit = 100;
        }
        String feedFavicon = this.getFavicon(url);
        String feedTitle = "";
        String feedDescription = "";
        String feedLink = "";
        List entries = new ArrayList();
        try {
            URL feedSource = new URL(url);
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed feed = input.build((Reader)new XmlReader(feedSource));
            feedTitle = Strings.nullToEmpty((String)feed.getTitle());
            feedDescription = Strings.nullToEmpty((String)feed.getDescription());
            feedLink = Strings.nullToEmpty((String)feed.getLink());
            entries = this.getEntries(feed, limit);
        }
        catch (FeedException | IOException feedSource) {
            // empty catch block
        }
        request.setAttribute("feedFavicon", (Object)feedFavicon);
        request.setAttribute("feedEntries", entries);
        request.setAttribute("feedTitle", (Object)feedTitle);
        request.setAttribute("feedDescription", (Object)feedDescription);
        request.setAttribute("feedLink", (Object)feedLink);
        PortletRequestDispatcher prDispatcher = this.getPortletContext().getRequestDispatcher("/rss-reader/index.jsp");
        prDispatcher.include(request, response);
    }

    private List<FeedItem> getEntries(SyndFeed feed, int limit) {
        ArrayList<FeedItem> entries = new ArrayList<FeedItem>();
        for (Object obj : feed.getEntries()) {
            List links;
            if (entries.size() >= limit) break;
            SyndEntry e = (SyndEntry)obj;
            FeedItem entry = new FeedItem();
            entry.setTitle(e.getTitle());
            String link = e.getLink();
            if (link == null && (links = e.getLinks()) != null && !links.isEmpty()) {
                link = ((SyndLink)links.get(0)).getHref();
            }
            entry.setLink(link);
            String summary = e.getContents() != null && !e.getContents().isEmpty() ? ((SyndContent)e.getContents().get(0)).getValue() : (e.getDescription() != null ? e.getDescription().getValue() : "");
            entry.setSummary(summary);
            Date date = e.getUpdatedDate() != null ? e.getUpdatedDate() : (e.getPublishedDate() != null ? e.getPublishedDate() : null);
            entry.setDate(date);
            entries.add(entry);
        }
        return entries;
    }

    private String getFavicon(String feedUrl) {
        Pattern p = Pattern.compile(":\\/\\/(www\\.)?([^\\/:]+)");
        Matcher m = p.matcher(feedUrl);
        String favicon = m.find(2) ? m.group(2) : "";
        favicon = "http://" + favicon + "/favicon.ico";
        return favicon;
    }
}

