/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.portlet.juzu.gettingstarted.models;

import javax.inject.Inject;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class GettingStartedService {
    @Inject
    private SpaceService spaceService;
    @Inject
    private IdentityManager identityManager;
    @Inject
    private RelationshipManager relManager;
    @Inject
    private ActivityManager activityManager;
    private static final Log LOG = ExoLogger.getLogger(GettingStartedService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hasDocuments(Node node, String userId) {
        try (SessionProvider sProvider = null;){
            sProvider = SessionProvider.createSystemProvider();
            String pathCondition = node == null ? "" : " AND jcr:path like " + node.getPath() + "/%";
            String fileQueryStatement = "SELECT * FROM nt:file WHERE exo:owner='" + userId + "'" + pathCondition;
            String ws = SessionProviderService.getRepository().getConfiguration().getDefaultWorkspaceName();
            QueryImpl query = (QueryImpl)sProvider.getSession(ws, SessionProviderService.getRepository()).getWorkspace().getQueryManager().createQuery(fileQueryStatement, "sql");
            query.setLimit(1L);
            Boolean bl = query.execute().getNodes().hasNext();
            return bl;
        }
    }

    public boolean hasAvatar(String userId) {
        try {
            IdentityManager identityManager = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
            Identity identity = identityManager.getOrCreateIdentity("organization", userId);
            Profile profile = identity.getProfile();
            return profile.getAvatarUrl() != null;
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in gettingStarted REST service: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public boolean hasSpaces(String userId) {
        try {
            ListAccess spaces = this.spaceService.getAccessibleSpacesWithListAccess(userId);
            if (spaces != null) {
                return spaces.getSize() > 0;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Can't get space number. Error during get accessible spaces", (Throwable)ex);
        }
        return false;
    }

    public boolean hasActivities(String userId) {
        RealtimeListAccess activities;
        Identity identity = this.identityManager.getOrCreateIdentity("organization", userId, false);
        if (identity != null && (activities = this.activityManager.getActivitiesWithListAccess(identity)) != null) {
            return activities.getSize() > 0;
        }
        return false;
    }

    public boolean hasContacts(String userId) {
        Identity identity = this.identityManager.getOrCreateIdentity("organization", userId, false);
        if (identity != null) {
            try {
                ListAccess identities = this.relManager.getConnections(identity);
                if (identities != null) {
                    return identities.getSize() > 0;
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Error during get connections", (Throwable)ex);
            }
        }
        return false;
    }
}

