/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/platformNavigation/portlet/UICompanyNavigationPortlet/UICompanyNavigationPortlet.gtmpl")
public class UICompanyNavigationPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getExoLogger(UICompanyNavigationPortlet.class);
    private UserNodeFilterConfig userFilterConfig;
    private BrandingService brandingService;

    public UICompanyNavigationPortlet() throws Exception {
        UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
        builder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL}).withTemporalCheck();
        this.userFilterConfig = builder.build();
        this.brandingService = (BrandingService)this.getApplicationComponent(BrandingService.class);
    }

    public UserNavigation getCurrentPortalNavigation() {
        return this.getNavigation(SiteKey.portal((String)this.getCurrentPortal()));
    }

    private UserNavigation getNavigation(SiteKey userKey) {
        UserPortal userPortal = this.getUserPortal();
        return userPortal.getNavigation(userKey);
    }

    private UserPortal getUserPortal() {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        return portalRequestContext.getUserPortal();
    }

    public String getCurrentPortal() {
        return Util.getPortalRequestContext().getPortalOwner();
    }

    public Collection<UserNode> getUserNodes() {
        UserPortal userPortal = this.getUserPortal();
        return userPortal.getNodes(SiteType.PORTAL, Scope.ALL, this.userFilterConfig);
    }

    @Deprecated
    public Collection<UserNode> getUserNodes(UserNavigation nav) {
        UserPortal userPortall = this.getUserPortal();
        if (nav != null) {
            try {
                UserNode rootNode = userPortall.getNode(nav, Scope.ALL, this.userFilterConfig, null);
                return rootNode.getChildren();
            }
            catch (Exception exp) {
                LOG.warn((Object)(nav.getKey().getName() + " has been deleted"));
            }
        }
        return Collections.emptyList();
    }

    public UserNode getSelectedPageNode() throws Exception {
        return Util.getUIPortal().getSelectedUserNode();
    }

    public Boolean isSelectedPageNode(UserNode node) throws Exception {
        UserNode selectedNode = Util.getUIPortal().getSelectedUserNode();
        if (selectedNode != null) {
            if (node.getURI().equals(selectedNode.getURI())) {
                return true;
            }
            ArrayList<String> uris = new ArrayList<String>();
            for (UserNode child : node.getChildren()) {
                uris.add(child.getURI());
            }
            if (uris != null && !uris.isEmpty()) {
                if (uris.contains(selectedNode.getURI())) {
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public String getCompanyName() {
        return this.brandingService.getCompanyName();
    }
}

