/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.platform.common.service.MenuConfiguratorService;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.gatein.common.text.EntityEncoder;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/platformNavigation/portlet/UIBreadCrumbsNavigationPortlet/UIBreadCrumbsNavigationPortlet.gtmpl")
public class UIBreadCrumbsNavigationPortlet
extends UIPortletApplication {
    private static Map<Locale, Map<String, String>> resolvedEncodeLabels = Collections.synchronizedMap(new HashMap());
    private MenuConfiguratorService menuConfiguratorService = (MenuConfiguratorService)this.getApplicationComponent(MenuConfiguratorService.class);

    public List<String> getBreadcumbs() throws Exception {
        ArrayList<String> breadcumbs = new ArrayList<String>();
        String pageRef = this.getSelectedPage();
        List nodes = this.buildBreadcumbs(pageRef, this.getPageNodes());
        for (PageNode node : nodes) {
            String label = this.getEncodedResolvedLabel(node);
            breadcumbs.add(label);
        }
        return breadcumbs;
    }

    private String getEncodedResolvedLabel(PageNode pageNode) {
        if (pageNode.getLabel() != null && !pageNode.getLabel().isEmpty()) {
            String resolvedLabel;
            Locale locale = Util.getPortalRequestContext().getLocale();
            Map<String, String> i18nizedLabels = (Map<String, String>)resolvedEncodeLabels.get(locale);
            if (i18nizedLabels == null) {
                i18nizedLabels = Collections.synchronizedMap(new HashMap());
                resolvedEncodeLabels.put(locale, i18nizedLabels);
            }
            if ((resolvedLabel = (String)i18nizedLabels.get(pageNode.getLabel())) == null) {
                PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
                ResourceBundle bundle = pcontext.getApplicationResourceBundle();
                resolvedLabel = ExpressionUtil.getExpressionValue((ResourceBundle)bundle, (String)pageNode.getLabel());
                resolvedLabel = EntityEncoder.FULL.encode(resolvedLabel);
                i18nizedLabels.put(pageNode.getLabel(), resolvedLabel);
            }
            return resolvedLabel;
        }
        return pageNode.getLabel();
    }

    private List<PageNode> buildBreadcumbs(String selectedPage, List<PageNode> nodes) {
        ArrayList<PageNode> breadcumbs = new ArrayList<PageNode>();
        if (selectedPage != null) {
            for (PageNode node : nodes) {
                List tmp;
                boolean added = false;
                if (node.getPageReference().equals(selectedPage)) {
                    breadcumbs.add(node);
                    added = true;
                }
                if (node.getChildren() == null || (tmp = this.buildBreadcumbs(selectedPage, node.getChildren())).isEmpty()) continue;
                if (!added) {
                    breadcumbs.add(node);
                }
                breadcumbs.addAll(tmp);
            }
        }
        return breadcumbs;
    }

    private String getSelectedPage() throws Exception {
        UserNavigation nav;
        UserNode node = Util.getUIPortal().getSelectedUserNode();
        UserPortal userPortal = UIBreadCrumbsNavigationPortlet.getUserPortal();
        UserNode targetNode = userPortal.resolvePath(nav = userPortal.getNavigation(node.getNavigation().getKey()), null, node.getURI());
        if (targetNode != null && targetNode.getPageRef() != null) {
            return targetNode.getPageRef().format();
        }
        return null;
    }

    private List<PageNode> getPageNodes() throws Exception {
        return this.menuConfiguratorService.getSetupMenuOriginalPageNodes();
    }

    private static UserPortal getUserPortal() {
        UserPortalConfig portalConfig = Util.getPortalRequestContext().getUserPortalConfig();
        return portalConfig.getUserPortal();
    }
}

