/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.platform.common.service.MenuConfiguratorService;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/platformNavigation/portlet/UIGroupsNavigationPortlet/UIGroupsNavigationPortlet.gtmpl")
public class UIGroupsNavigationPortlet
extends UIPortletApplication {
    private static final String SPACE_GROUP_PATTERN = "spaces";
    private MenuConfiguratorService menuConfiguratorService;
    private UserNodeFilterConfig myGroupsFilterConfig;
    private List<String> setupMenuPageReferences = null;
    private List<UserNavigation> navigationsToDisplay = new ArrayList();
    private Map<String, Collection<UserNode>> nodesToDisplay = new HashMap();
    private Map<String, Collection<UserNode>> cachedValidChildrenNodesToDisplay = new HashMap();
    public static boolean collapse = true;

    public UIGroupsNavigationPortlet() throws Exception {
        this.menuConfiguratorService = (MenuConfiguratorService)this.getApplicationComponent(MenuConfiguratorService.class);
        this.setupMenuPageReferences = this.menuConfiguratorService.getSetupMenuPageReferences();
        this.myGroupsFilterConfig = this.menuConfiguratorService.getMyGroupsFilterConfig();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.readNavigationsAndCache();
        super.processRender(context);
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        this.readNavigationsAndCache();
        super.processRender(app, context);
    }

    private void readNavigationsAndCache() {
        UserPortal userPortal = UIGroupsNavigationPortlet.getUserPortal();
        List allNavigations = userPortal.getNavigations();
        this.navigationsToDisplay.clear();
        this.nodesToDisplay.clear();
        this.cachedValidChildrenNodesToDisplay.clear();
        for (UserNavigation navigation : allNavigations) {
            UserNode rootNode;
            Collection children;
            if (!navigation.getKey().getTypeName().equals(SiteType.GROUP.getName()) || navigation.getKey().getName().indexOf("spaces") >= 0 || (children = this.loadNodesNotInSetupMenu((rootNode = userPortal.getNode(navigation, Scope.ALL, this.myGroupsFilterConfig, null)).getChildren(), 0)) == null || children.isEmpty()) continue;
            this.navigationsToDisplay.add(navigation);
            this.nodesToDisplay.put(navigation.getKey().getName(), children);
        }
    }

    public List<UserNavigation> getGroupNavigations() {
        return this.navigationsToDisplay;
    }

    public Collection<UserNode> getValidUserNodes(UserNavigation nav) {
        return (Collection)this.nodesToDisplay.get(nav.getKey().getName());
    }

    public Collection<UserNode> getValidChildren(UserNode node) {
        return (Collection)this.cachedValidChildrenNodesToDisplay.get(node.getId());
    }

    private Collection<UserNode> loadNodesNotInSetupMenu(Collection<UserNode> userNodes, int childLevel) {
        if (userNodes == null || userNodes.isEmpty() || ++childLevel > 2) {
            return null;
        }
        ArrayList<UserNode> validNodes = new ArrayList<UserNode>();
        for (UserNode userNode : userNodes) {
            Collection validChidNodes = this.loadNodesNotInSetupMenu(userNode.getChildren(), childLevel);
            this.cachedValidChildrenNodesToDisplay.put(userNode.getId(), validChidNodes);
            if (userNode.getPageRef() != null && !this.isUserNodeInSetupMenu(userNode)) {
                validNodes.add(userNode);
                continue;
            }
            if (validChidNodes == null || validChidNodes.isEmpty()) continue;
            validNodes.add(userNode);
        }
        return validNodes;
    }

    public boolean isUserNodeInSetupMenu(UserNode userNode) {
        String pageReference = userNode.getPageRef().format();
        if (pageReference != null && !pageReference.isEmpty()) {
            return this.setupMenuPageReferences.contains(pageReference);
        }
        return false;
    }

    public static UserPortal getUserPortal() {
        UserPortalConfig portalConfig = Util.getPortalRequestContext().getUserPortalConfig();
        return portalConfig.getUserPortal();
    }

    public boolean isSelectedNavigation(String name) throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        UserNode selectedNode = uiPortal.getSelectedUserNode();
        return selectedNode.getName().equals(name);
    }

    public boolean isUnfoldedNavigation(UserNode node) throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        UserNode selectedNode = uiPortal.getSelectedUserNode();
        return node.getChild(selectedNode.getName()) != null;
    }
}

