/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.component;

import java.util.Collection;
import java.util.Collections;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.NavigationURLUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/platformNavigation/portlet/UIUserPlatformToolBarPortlet/UIUserPlatformToolBarPortlet.gtmpl")
public class UIUserPlatformToolBarPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getLogger(UIUserPlatformToolBarPortlet.class);
    private String currentPortalName = null;
    private boolean socialPortal = false;
    private static final String USER = "/user/";
    private static final String WIKI_HOME = "/WikiHome";
    private static final String WIKI_REF = "wiki";

    public User getUser() throws Exception {
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        User user = service.getUserHandler().findUserByName(userName);
        return user;
    }

    private String getCurrentPortalName() {
        return Util.getPortalRequestContext().getPortalOwner();
    }

    public boolean hasSystemProfile(String profile) {
        return ExoContainer.hasProfile((String)profile);
    }

    public static UserPortal getUserPortal() {
        UserPortalConfig portalConfig = Util.getPortalRequestContext().getUserPortalConfig();
        return portalConfig.getUserPortal();
    }

    public Collection<UserNode> getUserNodes(UserNavigation nav) {
        UserPortal userPortall = UIUserPlatformToolBarPortlet.getUserPortal();
        if (nav != null) {
            try {
                UserNode rootNode = userPortall.getNode(nav, Scope.CHILDREN, null, null);
                return rootNode.getChildren();
            }
            catch (Exception exp) {
                log.warn((Object)(nav.getKey().getName() + " has been deleted"));
            }
        }
        return Collections.emptyList();
    }

    public String getAvatarURL() {
        Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", Util.getPortalRequestContext().getRemoteUser());
        String ownerAvatar = identity.getProfile().getAvatarUrl();
        if (ownerAvatar == null || ownerAvatar.isEmpty()) {
            ownerAvatar = "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png";
        }
        return ownerAvatar;
    }

    public String getWikiURL() {
        return NavigationURLUtils.getURLInCurrentPortal((String)"wiki") + "/user/" + Util.getPortalRequestContext().getRemoteUser() + "/WikiHome";
    }
}

