/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.service.plugin;

import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.common.service.MenuConfiguratorService;
import org.exoplatform.portal.config.model.ModelUnmarshaller;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.UnmarshalledObject;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MenuConfiguratorAddNodePlugin
extends BaseComponentPlugin {
    private ConfigurationManager configurationManager;
    private MenuConfiguratorService menuConfiguratorService;
    private String navPath;
    private static final String EXTENDED_SETUP_NAVIGATION_FILE = "extended.setup.navigation.file";
    private static final Log LOG = ExoLogger.getLogger(MenuConfiguratorAddNodePlugin.class);

    public MenuConfiguratorAddNodePlugin(InitParams initParams, ConfigurationManager configurationManager, MenuConfiguratorService menuConfiguratorService) {
        this.configurationManager = configurationManager;
        this.menuConfiguratorService = menuConfiguratorService;
        if (initParams.containsKey((Object)EXTENDED_SETUP_NAVIGATION_FILE)) {
            this.navPath = initParams.getValueParam(EXTENDED_SETUP_NAVIGATION_FILE).getValue();
        }
    }

    public void execute() {
        NavigationFragment extendedFragment = null;
        if (this.navPath != null && !this.navPath.isEmpty()) {
            try {
                UnmarshalledObject extendedObj = ModelUnmarshaller.unmarshall(PageNavigation.class, (InputStream)this.configurationManager.getInputStream(this.navPath));
                PageNavigation extendedPageNav = (PageNavigation)extendedObj.getObject();
                List<PageNode> setupPageNodes = this.menuConfiguratorService.getSetupMenuOriginalPageNodes();
                extendedFragment = extendedPageNav.getFragment();
                for (PageNode extendedPageNode : extendedFragment.getNodes()) {
                    this.insertExtendedNodes(extendedPageNode, setupPageNodes);
                }
            }
            catch (Exception E) {
                LOG.error((Object)("Can not load or read the file with path " + this.navPath + " Please check the path or the file structure "), (Throwable)E);
            }
        } else {
            LOG.warn((Object)"Path for extended setup navigation file not mentioned");
        }
    }

    private void insertExtendedNodes(PageNode nodeToInsert, List<PageNode> existingNodes) {
        if (existingNodes == null) {
            return;
        }
        PageNode existingPageNode = existingNodes.stream().filter(pageNode -> StringUtils.equals((CharSequence)pageNode.getName(), (CharSequence)nodeToInsert.getName())).findFirst().orElse(null);
        if (existingPageNode == null) {
            existingNodes.add(nodeToInsert);
        } else {
            existingPageNode.setPageReference(nodeToInsert.getPageReference());
            existingPageNode.setLabel(nodeToInsert.getLabel());
            List children = nodeToInsert.getChildren();
            if (children != null && !children.isEmpty()) {
                for (PageNode pageNodeToInsert : children) {
                    this.insertExtendedNodes(pageNodeToInsert, existingPageNode.getChildren());
                }
            }
        }
    }
}

