/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.LoginHistory.storage;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.platform.gadget.services.LoginHistory.LastLoginBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginCounterBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryServiceImpl;
import org.exoplatform.platform.gadget.services.LoginHistory.storage.LoginHistoryStorage;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;

public class JCRLoginHistoryStorageImpl
implements LoginHistoryStorage {
    private static final Log LOG = ExoLogger.getLogger(LoginHistoryServiceImpl.class);
    private static String HOME = "exo:LoginHistoryHome";
    private static String LOGIN_HISTORY = "loginHistory";
    private static String LOGIN_COUNTER = "loginCounter";
    private static long DAY_IN_MILLISEC = 86400000L;
    private RepositoryService repositoryService;

    public JCRLoginHistoryStorageImpl(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createHomeNode() throws RepositoryException {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            ManageableRepository currentRepo = this.repositoryService.getCurrentRepository();
            Session session = sProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
            Node rootNode = session.getRootNode();
            if (!rootNode.hasNode(HOME)) {
                Node homeNode = rootNode.addNode(HOME, "exo:LoginHisSvc_loginHistoryService");
                homeNode.addMixin("exo:privilegeable");
                HashMap<String, String[]> permissions = new HashMap<String, String[]>();
                permissions.put("*:/platform/administrators", PermissionType.ALL);
                permissions.put("*:/platform/users", new String[]{"read"});
                ((ExtendedNode)homeNode).setPermissions(permissions);
                homeNode.addMixin("exo:owneable");
                rootNode.save();
                if (homeNode.canAddMixin("exo:hiddenable")) {
                    homeNode.addMixin("exo:hiddenable");
                }
                Node globalLoginCounterNode = homeNode.addNode("AllUsers", "exo:LoginHisSvc_globalLoginCounter");
                globalLoginCounterNode.setProperty("exo:LoginHisSvc_globalLoginCounter_lastIndex", 0L);
                homeNode.save();
                LOG.info((Object)"Login history storage initialized.");
            }
        }
    }

    private Session getSession(SessionProvider sessionProvider) throws Exception {
        ManageableRepository currentRepo = this.repositoryService.getCurrentRepository();
        return sessionProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    private String getUserFullName(String userId) {
        try {
            OrganizationService service = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            return service.getUserHandler().findUserByName(userId).getFullName();
        }
        catch (Exception e) {
            return userId;
        }
    }

    private static long nextMonday(long date) {
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(date);
        int weekday = now.get(7);
        int days = weekday == 1 ? 1 : 7 - weekday + 2;
        now.add(6, days);
        return now.getTimeInMillis();
    }

    public List<LoginCounterBean> getLoginCountPerDaysInRange(String userId, long fromDate, long toDate) throws Exception {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlStatement = "SELECT * FROM exo:LoginHisSvc_loginCounterItem WHERE exo:LoginHisSvc_loginCounterItem_userId = '" + userId + "' AND (exo:LoginHisSvc_loginCounterItem_loginDate BETWEEN " + Long.toString(fromDate) + " AND " + Long.toString(toDate) + ") ORDER BY exo:LoginHisSvc_loginCounterItem_loginDate ASC";
            QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            ArrayList<LoginCounterBean> list = new ArrayList<LoginCounterBean>();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                LoginCounterBean loginCountPerDay = new LoginCounterBean();
                loginCountPerDay.setLoginDate(node.getProperty("exo:LoginHisSvc_loginCounterItem_loginDate").getLong());
                loginCountPerDay.setLoginCount(node.getProperty("exo:LoginHisSvc_loginCounterItem_loginCount").getLong());
                list.add(loginCountPerDay);
            }
            ArrayList<LoginCounterBean> arrayList = list;
            return arrayList;
        }
    }

    private int getLoginCount(String userId, long fromDate, long toDate) throws Exception {
        List<LoginCounterBean> loginCounts = this.getLoginCountPerDaysInRange(userId, fromDate, toDate);
        int sum = 0;
        Iterator<LoginCounterBean> iter = loginCounts.iterator();
        while (iter.hasNext()) {
            sum = (int)((long)sum + iter.next().getLoginCount());
        }
        return sum;
    }

    @Override
    public long getLastLogin(String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        if (!this.getSession(sProvider).getRootNode().hasNode(HOME)) {
            this.createHomeNode();
        }
        try {
            Session session = this.getSession(sProvider);
            Node homeNode = session.getRootNode().getNode(HOME);
            long l = !homeNode.hasNode(userId) ? 0L : homeNode.getNode(userId).getProperty("exo:LoginHisSvc_lastLogin").getLong();
            return l;
        }
        catch (Exception e) {
            LOG.debug((Object)("Error while retrieving " + userId + "'s last login: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public List<LastLoginBean> getLastLogins(int numLogins, String userIdFilter) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        if (!this.getSession(sProvider).getRootNode().hasNode(HOME)) {
            this.createHomeNode();
        }
        try {
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlStatement = "SELECT * FROM exo:LoginHisSvc_userProfile WHERE (UPPER(exo:LoginHisSvc_userId) LIKE '%" + userIdFilter.toUpperCase() + "%') OR (UPPER(exo:LoginHisSvc_userName) LIKE '%" + userIdFilter.toUpperCase() + "%') ORDER BY exo:LoginHisSvc_lastLogin DESC";
            QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
            query.setLimit((long)numLogins);
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            ArrayList<LastLoginBean> lastLogins = new ArrayList<LastLoginBean>();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                LastLoginBean lastLoginBean = new LastLoginBean();
                String userId = node.getName();
                String userName = node.getProperty("exo:LoginHisSvc_userName").getString();
                lastLoginBean.setUserId(userId);
                lastLoginBean.setUserName(userName.isEmpty() ? userId : userName);
                lastLoginBean.setLastLogin(node.getProperty("exo:LoginHisSvc_lastLogin").getLong());
                lastLoginBean.setBeforeLastLogin(node.getProperty("exo:LoginHisSvc_beforeLastLogin").getLong());
                lastLogins.add(lastLoginBean);
            }
            ArrayList<LastLoginBean> arrayList = lastLogins;
            return arrayList;
        }
        catch (Exception e) {
            LOG.debug((Object)("Error while retrieving last logins: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public void addLoginHistoryEntry(String userId, long loginTime) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        if (!this.getSession(sProvider).getRootNode().hasNode(HOME)) {
            this.createHomeNode();
        }
        try {
            Node loginCounterNode;
            Node loginHistoryNode;
            Node userNode;
            Session session = this.getSession(sProvider);
            Node homeNode = session.getRootNode().getNode(HOME);
            String userName = this.getUserFullName(userId);
            if (!homeNode.hasNode(userId)) {
                userNode = homeNode.addNode(userId, "exo:LoginHisSvc_userProfile");
                userNode.setProperty("exo:LoginHisSvc_userId", userId);
                userNode.setProperty("exo:LoginHisSvc_userName", userName);
                userNode.setProperty("exo:LoginHisSvc_lastLogin", 0L);
                userNode.setProperty("exo:LoginHisSvc_beforeLastLogin", 0L);
                homeNode.save();
                loginHistoryNode = userNode.addNode(LOGIN_HISTORY, "exo:LoginHisSvc_loginHistory");
                loginHistoryNode.setProperty("exo:LoginHisSvc_loginHistory_lastIndex", 0L);
                loginCounterNode = userNode.addNode(LOGIN_COUNTER, "exo:LoginHisSvc_loginCounter");
                loginCounterNode.setProperty("exo:LoginHisSvc_loginCounter_lastIndex", 0L);
                userNode.save();
            } else {
                userNode = homeNode.getNode(userId);
            }
            userNode.setProperty("exo:LoginHisSvc_userName", userName);
            userNode.setProperty("exo:LoginHisSvc_beforeLastLogin", userNode.getProperty("exo:LoginHisSvc_lastLogin").getLong());
            userNode.setProperty("exo:LoginHisSvc_lastLogin", loginTime);
            loginHistoryNode = userNode.getNode("loginHistory");
            long loginHistory_lastIndex = loginHistoryNode.getProperty("exo:LoginHisSvc_loginHistory_lastIndex").getLong();
            Node loginHistory_loginTimeNode = loginHistoryNode.addNode(Long.toString(++loginHistory_lastIndex), "exo:LoginHisSvc_loginHistoryItem");
            loginHistory_loginTimeNode.setProperty("exo:LoginHisSvc_loginHistoryItem_id", loginHistory_lastIndex);
            loginHistory_loginTimeNode.setProperty("exo:LoginHisSvc_loginHistoryItem_userId", userId);
            loginHistory_loginTimeNode.setProperty("exo:LoginHisSvc_loginHistoryItem_loginTime", loginTime);
            loginHistoryNode.setProperty("exo:LoginHisSvc_loginHistory_lastIndex", loginHistory_lastIndex);
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(loginTime);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            String loginDate = Long.toString(cal.getTimeInMillis());
            loginCounterNode = userNode.getNode("loginCounter");
            long loginCounter_lastIndex = loginCounterNode.getProperty("exo:LoginHisSvc_loginCounter_lastIndex").getLong();
            if (!loginCounterNode.hasNode(loginDate)) {
                Node loginCounter_loginDateNode = loginCounterNode.addNode(loginDate, "exo:LoginHisSvc_loginCounterItem");
                loginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_id", ++loginCounter_lastIndex);
                loginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_userId", userId);
                loginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_loginDate", Long.parseLong(loginDate));
                loginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_loginCount", 1L);
            } else {
                Node loginCounter_loginDateNode = loginCounterNode.getNode(loginDate);
                long loginCount = loginCounter_loginDateNode.getProperty("exo:LoginHisSvc_loginCounterItem_loginCount").getLong();
                loginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_loginCount", loginCount + 1L);
            }
            loginCounterNode.setProperty("exo:LoginHisSvc_loginCounter_lastIndex", loginCounter_lastIndex);
            Node globalLoginCounterNode = session.getRootNode().getNode(HOME).getNode("AllUsers");
            long globalLoginCounter_lastIndex = globalLoginCounterNode.getProperty("exo:LoginHisSvc_globalLoginCounter_lastIndex").getLong();
            if (!globalLoginCounterNode.hasNode(loginDate)) {
                Node globalLoginCounter_loginDateNode = globalLoginCounterNode.addNode(loginDate, "exo:LoginHisSvc_loginCounterItem");
                globalLoginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_id", ++globalLoginCounter_lastIndex);
                globalLoginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_userId", "AllUsers");
                globalLoginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_loginDate", Long.parseLong(loginDate));
                globalLoginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_loginCount", 1L);
            } else {
                Node globalLoginCounter_loginDateNode = globalLoginCounterNode.getNode(loginDate);
                long loginCount = globalLoginCounter_loginDateNode.getProperty("exo:LoginHisSvc_loginCounterItem_loginCount").getLong();
                globalLoginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_loginCount", loginCount + 1L);
            }
            globalLoginCounterNode.setProperty("exo:LoginHisSvc_globalLoginCounter_lastIndex", globalLoginCounter_lastIndex);
            userNode.save();
            globalLoginCounterNode.save();
        }
        catch (Exception e) {
            LOG.debug((Object)("Error while adding login history entry for user '" + userId + "': " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public List<LoginHistoryBean> getLoginHistory(String userId, long fromTime, long toTime) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        if (!this.getSession(sProvider).getRootNode().hasNode(HOME)) {
            this.createHomeNode();
        }
        try {
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlStatement = "SELECT * FROM exo:LoginHisSvc_loginHistoryItem WHERE " + (userId.equals("AllUsers") ? "" : "exo:LoginHisSvc_loginHistoryItem_userId = '" + userId + "' AND ") + "(exo:LoginHisSvc_loginHistoryItem_loginTime BETWEEN " + Long.toString(fromTime) + " AND " + Long.toString(toTime) + ") ORDER BY exo:LoginHisSvc_loginHistoryItem_loginTime DESC";
            QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            ArrayList<LoginHistoryBean> list = new ArrayList<LoginHistoryBean>();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                LoginHistoryBean loginHistory = new LoginHistoryBean();
                String uId = node.getProperty("exo:LoginHisSvc_loginHistoryItem_userId").getString();
                String uName = this.getUserFullName(uId);
                loginHistory.setUserId(uId);
                loginHistory.setUserName(uName.isEmpty() ? uId : uName);
                loginHistory.setLoginTime(node.getProperty("exo:LoginHisSvc_loginHistoryItem_loginTime").getLong());
                list.add(loginHistory);
            }
            ArrayList<LoginHistoryBean> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            LOG.debug((Object)("Error while getting login history of user '" + userId + "': " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getLastUsersLogin(long fromTime) throws Exception {
        LinkedHashSet<String> users = new LinkedHashSet<String>();
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT * FROM exo:LoginHisSvc_userProfile WHERE").append(" exo:LoginHisSvc_lastLogin >= " + Long.toString(fromTime)).append(" ORDER BY exo:LoginHisSvc_lastLogin DESC");
            QueryImpl query = (QueryImpl)queryManager.createQuery(sb.toString(), "sql");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                String userId = node.getProperty("exo:LoginHisSvc_userId").getString();
                users.add(userId);
            }
            LinkedHashSet<String> linkedHashSet = users;
            return linkedHashSet;
        }
        return null;
    }

    @Override
    public List<LoginCounterBean> getLoginCountPerDaysInWeek(String userId, long week) throws Exception {
        ArrayList<LoginCounterBean> list = new ArrayList<LoginCounterBean>();
        ArrayList<Long> days = new ArrayList<Long>();
        long now = System.currentTimeMillis();
        long nextWeek = JCRLoginHistoryStorageImpl.nextMonday(week);
        long day = week;
        do {
            LoginCounterBean loginCountPerDay = new LoginCounterBean();
            loginCountPerDay.setLoginDate(day);
            loginCountPerDay.setLoginCount(day > now ? -1L : 0L);
            list.add(loginCountPerDay);
            days.add(day);
        } while ((day += DAY_IN_MILLISEC) < nextWeek);
        List<LoginCounterBean> counters = this.getLoginCountPerDaysInRange(userId, week, JCRLoginHistoryStorageImpl.nextMonday(week) - DAY_IN_MILLISEC);
        for (LoginCounterBean loginCountPerDay : counters) {
            list.set(days.indexOf(loginCountPerDay.getLoginDate()), loginCountPerDay);
        }
        return list;
    }

    @Override
    public List<LoginCounterBean> getLoginCountPerWeeksInMonths(String userId, long fromMonth, int numOfMonths) throws Exception {
        Calendar cal = Calendar.getInstance();
        long now = cal.getTime().getTime();
        cal.setTimeInMillis(fromMonth);
        cal.add(2, numOfMonths);
        long toMonth = cal.getTimeInMillis();
        long toDate = fromMonth;
        ArrayList<LoginCounterBean> list = new ArrayList<LoginCounterBean>();
        do {
            long fromDate = toDate;
            if ((toDate = JCRLoginHistoryStorageImpl.nextMonday(toDate)) > toMonth) {
                toDate = toMonth;
            }
            LoginCounterBean loginCountPerWeek = new LoginCounterBean();
            loginCountPerWeek.setLoginDate(fromDate);
            loginCountPerWeek.setLoginCount(fromDate > now ? -1L : (long)this.getLoginCount(userId, fromDate, toDate - DAY_IN_MILLISEC));
            list.add(loginCountPerWeek);
        } while (toDate < toMonth);
        return list;
    }

    @Override
    public List<LoginCounterBean> getLoginCountPerMonthsInYear(String userId, long year) throws Exception {
        Calendar cal = Calendar.getInstance();
        long now = cal.getTime().getTime();
        cal.setTimeInMillis(year);
        cal.add(1, 1);
        long nextYear = cal.getTimeInMillis();
        long toDate = year;
        ArrayList<LoginCounterBean> list = new ArrayList<LoginCounterBean>();
        do {
            long fromDate = toDate;
            cal.setTimeInMillis(toDate);
            cal.add(2, 1);
            toDate = cal.getTimeInMillis();
            if (toDate > nextYear) {
                toDate = nextYear;
            }
            LoginCounterBean loginCountPerWeek = new LoginCounterBean();
            loginCountPerWeek.setLoginDate(fromDate);
            loginCountPerWeek.setLoginCount(fromDate > now ? -1L : (long)this.getLoginCount(userId, fromDate, toDate - DAY_IN_MILLISEC));
            list.add(loginCountPerWeek);
        } while (toDate < nextYear);
        return list;
    }

    @Override
    public long getBeforeLastLogin(String userId) throws Exception {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Session session = this.getSession(sProvider);
            Node homeNode = session.getRootNode().getNode(HOME);
            long l = !homeNode.hasNode(userId) ? 0L : homeNode.getNode(userId).getProperty("exo:LoginHisSvc_beforeLastLogin").getLong();
            return l;
        }
    }

    public long countLoginHistoryNodes(SessionProvider sProvider) {
        long count = 0L;
        try {
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlStatement = "SELECT * FROM exo:LoginHisSvc_loginHistoryItem WHERE jcr:path LIKE '/exo:LoginHistoryHome/%'";
            QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            count = nodeIterator.getSize();
        }
        catch (Exception e) {
            LOG.error((Object)("==    Login History migration - Error while getting the count of Login History Entries : " + e.getMessage()), (Throwable)e);
        }
        return count;
    }

    public long countGlobalLoginHistoryCountersNodes(SessionProvider sProvider) {
        long count = 0L;
        try {
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlStatement = "SELECT * FROM exo:LoginHisSvc_loginCounterItem WHERE jcr:path LIKE '/exo:LoginHistoryHome/AllUsers/%'";
            QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            count = nodeIterator.getSize();
        }
        catch (Exception e) {
            LOG.error((Object)("==    Login History migration - Error while getting the count of Global Login History Counters Nodes : " + e.getMessage()), (Throwable)e);
        }
        return count;
    }

    public long countLoginHistoryCountersNodes(SessionProvider sProvider) {
        long count = 0L;
        try {
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlStatement = "SELECT * FROM exo:LoginHisSvc_loginCounterItem WHERE jcr:path LIKE '/exo:LoginHistoryHome/%'";
            QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            count = nodeIterator.getSize();
        }
        catch (Exception e) {
            LOG.error((Object)("==    Login History migration - Error while getting the count of All Login History Counters Nodes : " + e.getMessage()), (Throwable)e);
        }
        return count;
    }

    public NodeIterator getUsersProfilesNodes(SessionProvider sProvider, long offset, long size) {
        NodeIterator nodeIterator = null;
        try {
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlStatement = "SELECT * FROM exo:LoginHisSvc_userProfile WHERE jcr:path LIKE '/exo:LoginHistoryHome/%' ORDER BY exo:dateCreated ASC";
            QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
            query.setLimit(size);
            query.setOffset(offset);
            QueryResult result = query.execute();
            nodeIterator = result.getNodes();
        }
        catch (Exception e) {
            LOG.error((Object)("==    Login History migration - Error while getting the Users Profiles Nodes NodeIterator : " + e.getMessage()), (Throwable)e);
        }
        return nodeIterator;
    }

    public NodeIterator getLoginHistoryNodes(SessionProvider sProvider, long offset, long size) {
        NodeIterator nodeIterator = null;
        try {
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlStatement = "SELECT * FROM exo:LoginHisSvc_loginHistoryItem WHERE jcr:path LIKE '/exo:LoginHistoryHome/%' ORDER BY exo:LoginHisSvc_loginHistoryItem_loginTime ASC";
            QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
            query.setLimit(size);
            query.setOffset(offset);
            QueryResult result = query.execute();
            nodeIterator = result.getNodes();
        }
        catch (Exception e) {
            LOG.error((Object)("==    Login History migration - Error while getting the Login History Nodes NodeIterator: " + e.getMessage()), (Throwable)e);
        }
        return nodeIterator;
    }

    public NodeIterator getAllUsersLoginCountersNodes(SessionProvider sProvider, long offset, long size) {
        NodeIterator nodeIterator = null;
        try {
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlStatement = "SELECT * FROM exo:LoginHisSvc_loginCounterItem WHERE jcr:path LIKE '/exo:LoginHistoryHome/AllUsers/%' ORDER BY exo:LoginHisSvc_loginCounterItem_loginDate ASC";
            QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
            query.setLimit(size);
            query.setOffset(offset);
            QueryResult result = query.execute();
            nodeIterator = result.getNodes();
        }
        catch (Exception e) {
            LOG.error((Object)("==    Login History migration - Error while getting the Login Counters Nodes NodeIterator: " + e.getMessage()), (Throwable)e);
        }
        return nodeIterator;
    }

    public NodeIterator getAllUsersProfilesNodes(SessionProvider sProvider) {
        NodeIterator allUsersProfilesNodes = null;
        try {
            Session session = this.getSession(sProvider);
            allUsersProfilesNodes = session.getRootNode().getNode(HOME).getNodes();
        }
        catch (Exception e) {
            LOG.error((Object)("==    Login History migration - Error while getting All Users Profiles Nodes : " + e.getMessage()), (Throwable)e);
        }
        return allUsersProfilesNodes;
    }

    public NodeIterator getAllUserLoginHistoryNodes(Node userProfileNode) {
        NodeIterator loginHistoryNodes = null;
        String userId = null;
        try {
            userId = userProfileNode.getProperty("exo:LoginHisSvc_userId").getString();
            if (!userProfileNode.getProperty("jcr:primaryType").getString().equals("exo:LoginHisSvc_globalLoginCounter")) {
                loginHistoryNodes = userProfileNode.getNode("loginHistory").getNodes();
            }
        }
        catch (Exception e) {
            LOG.error("==    Login History migration - Error while getting All User ({}) Login History Nodes : ", new Object[]{userId, e.getMessage(), e});
        }
        return loginHistoryNodes;
    }

    public NodeIterator getAllUserLoginCountersNodes(Node userProfileNode) {
        NodeIterator loginCountersNodes = null;
        String userId = null;
        try {
            userId = userProfileNode.getProperty("exo:LoginHisSvc_userId").getString();
            if (!userProfileNode.getProperty("jcr:primaryType").getString().equals("exo:LoginHisSvc_globalLoginCounter")) {
                loginCountersNodes = userProfileNode.getNode("loginCounter").getNodes();
            }
        }
        catch (Exception e) {
            LOG.error("==    Login History migration - Error while getting User ({}) All Login Counters Nodes : ", new Object[]{userId, e.getMessage(), e});
        }
        return loginCountersNodes;
    }

    public void removeLoginHistoryNode(SessionProvider sProvider, Node loginHistoryNode) {
        try {
            Session session = this.getSession(sProvider);
            loginHistoryNode.remove();
            session.save();
        }
        catch (Exception e) {
            LOG.error("==    Login History migration - Error while removing Login History Node {} : ", new Object[]{loginHistoryNode, e.getMessage(), e});
        }
    }

    public void removeAllUsersProfileNode(SessionProvider sProvider) {
        try {
            Session session = this.getSession(sProvider);
            Node loginHistoryAllUsersProfileNode = session.getRootNode().getNode(HOME + "/AllUsers");
            loginHistoryAllUsersProfileNode.remove();
            session.save();
        }
        catch (Exception e) {
            LOG.error("==    Login History migration - Error while removing All Users Profile Node : ", new Object[]{e.getMessage(), e});
        }
    }

    public void removeLoginHistoryUserProfileChildNodes(Session session, String userId) {
        try {
            Node loginHistoryNode = session.getRootNode().getNode(HOME + "/" + userId + "/loginHistory");
            Node loginCounterNode = session.getRootNode().getNode(HOME + "/" + userId + "/loginCounter");
            loginHistoryNode.remove();
            loginCounterNode.remove();
            session.save();
        }
        catch (Exception e) {
            LOG.error("==    Login History migration - Error while removing Login History User Profile Child Nodes of User {} : ", new Object[]{userId, e.getMessage(), e});
        }
    }

    public void removeLoginHistoryHomeNode() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        if (!this.getSession(sProvider).getRootNode().hasNode(HOME)) {
            return;
        }
        Session session = this.getSession(sProvider);
        Node homeNode = session.getRootNode().getNode(HOME);
        homeNode.remove();
        session.save();
        sProvider.close();
    }
}

