/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mailintegration.utils;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.exoplatform.mailintegration.model.MailIntegrationSetting;
import org.exoplatform.mailintegration.rest.model.MailIntegrationSettingRestEntity;
import org.exoplatform.mailintegration.rest.model.MessageRestEntity;
import org.exoplatform.mailintegration.utils.MailIntegrationUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jsoup.Jsoup;

public class RestEntityBuilder {
    private static final Log LOG = ExoLogger.getLogger(RestEntityBuilder.class);

    private RestEntityBuilder() {
    }

    public static final MailIntegrationSettingRestEntity fromMailIntegrationSetting(MailIntegrationSetting mailIntegrationSetting) {
        MailIntegrationSettingRestEntity mailIntegrationSettingRestEntity = new MailIntegrationSettingRestEntity();
        mailIntegrationSettingRestEntity.setId(mailIntegrationSetting.getId());
        mailIntegrationSettingRestEntity.setEmailName(mailIntegrationSetting.getEmailName());
        mailIntegrationSettingRestEntity.setImapUrl(mailIntegrationSetting.getImapUrl());
        mailIntegrationSettingRestEntity.setPort(mailIntegrationSetting.getPort());
        mailIntegrationSettingRestEntity.setEncryption(mailIntegrationSetting.getEncryption());
        mailIntegrationSettingRestEntity.setAccount(mailIntegrationSetting.getAccount());
        mailIntegrationSettingRestEntity.setPassword(MailIntegrationUtils.decode(mailIntegrationSetting.getPassword()));
        return mailIntegrationSettingRestEntity;
    }

    public static final MailIntegrationSetting toMailIntegrationSetting(MailIntegrationSettingRestEntity mailIntegrationSettingRestEntity, long userIdentityId) {
        MailIntegrationSetting mailIntegrationSetting = new MailIntegrationSetting();
        if (mailIntegrationSettingRestEntity.getId() > 0L) {
            mailIntegrationSetting.setId(mailIntegrationSettingRestEntity.getId());
        }
        mailIntegrationSetting.setEmailName(mailIntegrationSettingRestEntity.getEmailName());
        mailIntegrationSetting.setImapUrl(mailIntegrationSettingRestEntity.getImapUrl());
        mailIntegrationSetting.setPort(mailIntegrationSettingRestEntity.getPort());
        mailIntegrationSetting.setEncryption(mailIntegrationSettingRestEntity.getEncryption());
        mailIntegrationSetting.setAccount(mailIntegrationSettingRestEntity.getAccount());
        mailIntegrationSetting.setPassword(mailIntegrationSettingRestEntity.getPassword());
        mailIntegrationSetting.setUserId(userIdentityId);
        return mailIntegrationSetting;
    }

    public static final MessageRestEntity fromMessage(Message message) throws MessagingException, IOException {
        if (message != null) {
            MessageRestEntity messageRestEntity = new MessageRestEntity();
            messageRestEntity.setSubject(message.getSubject());
            messageRestEntity.setSentDate(message.getSentDate());
            if (message.getFrom()[0].toString().contains("<") && message.getFrom()[0].toString().contains(">")) {
                messageRestEntity.setFrom(message.getFrom()[0].toString().split("<")[1].split(">")[0]);
            } else {
                messageRestEntity.setFrom(message.getFrom()[0].toString());
            }
            String contentType = message.getContentType();
            String body = "";
            StringBuilder attachedFiles = new StringBuilder();
            if (contentType.contains("multipart")) {
                Multipart multiPart = (Multipart)message.getContent();
                int numberOfParts = multiPart.getCount();
                for (int partCount = 0; partCount < numberOfParts; ++partCount) {
                    MimeBodyPart part = (MimeBodyPart)multiPart.getBodyPart(partCount);
                    if (!"attachment".equalsIgnoreCase(part.getDisposition())) continue;
                    String fileName = part.getFileName();
                    String fileExtension = part.getContentType();
                    attachedFiles.append(fileName).append("*").append(RestEntityBuilder.getExtensionFromPartFile(fileExtension)).append(", ");
                }
                if (attachedFiles.length() > 1) {
                    attachedFiles = new StringBuilder(attachedFiles.substring(0, attachedFiles.length() - 2));
                }
                MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
                try {
                    body = RestEntityBuilder.getTextFromMimeMultipart(mimeMultipart).replaceAll("\\n|\\r", "<br>");
                }
                catch (Exception e) {
                    LOG.error((Object)"error when getting body mail content", (Throwable)e);
                }
                messageRestEntity.setBody(body);
                messageRestEntity.setAttachedFiles(attachedFiles.toString());
            }
            return messageRestEntity;
        }
        return null;
    }

    private static String getTextFromMimeMultipart(MimeMultipart mimeMultipart) throws Exception {
        StringBuilder result = new StringBuilder();
        int count = mimeMultipart.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = mimeMultipart.getBodyPart(i);
            if (bodyPart.isMimeType("text/plain")) {
                result.append("\n").append(bodyPart.getContent());
                break;
            }
            if (bodyPart.isMimeType("text/html")) {
                String html = (String)bodyPart.getContent();
                result.append("\n").append(Jsoup.parse((String)html).text());
                continue;
            }
            if (!(bodyPart.getContent() instanceof MimeMultipart)) continue;
            result.append(RestEntityBuilder.getTextFromMimeMultipart((MimeMultipart)bodyPart.getContent()));
        }
        return result.toString();
    }

    private static String getExtensionFromPartFile(String fileExtension) {
        String fileExtensionLowerCase = fileExtension.toLowerCase();
        if (fileExtensionLowerCase.contains("pdf")) {
            return "pdf";
        }
        if (fileExtensionLowerCase.contains("image")) {
            return "image";
        }
        if (fileExtensionLowerCase.contains("csv")) {
            return "csv";
        }
        if (fileExtensionLowerCase.contains("powerpoint")) {
            return "powerpoint";
        }
        if (fileExtensionLowerCase.contains("opendocument") || fileExtension.toLowerCase().contains("officedocument")) {
            return "word";
        }
        if (fileExtensionLowerCase.contains("zip")) {
            return "archive";
        }
        if (fileExtensionLowerCase.contains("video")) {
            return "video";
        }
        return "";
    }
}

