/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mailintegration.service;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.mailintegration.model.MailIntegrationSetting;
import org.exoplatform.mailintegration.notification.plugin.MailIntegrationNotificationPlugin;
import org.exoplatform.mailintegration.notification.utils.NotificationConstants;
import org.exoplatform.mailintegration.rest.model.MessageRestEntity;
import org.exoplatform.mailintegration.service.MailIntegrationService;
import org.exoplatform.mailintegration.storage.MailIntegrationStorage;
import org.exoplatform.mailintegration.utils.MailIntegrationUtils;
import org.exoplatform.mailintegration.utils.RestEntityBuilder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class MailIntegrationServiceImpl
implements MailIntegrationService {
    private static final Log LOG = ExoLogger.getLogger(MailIntegrationServiceImpl.class);
    public static final String MAIL_IMAPS = "imaps";
    public static final String MAIL_SSL = "SSL";
    private MailIntegrationStorage mailIntegrationStorage;
    private IdentityManager identityManager;
    private UserStateService userStateService;

    public MailIntegrationServiceImpl(MailIntegrationStorage mailIntegrationStorage, IdentityManager identityManager, UserStateService userStateService) {
        this.mailIntegrationStorage = mailIntegrationStorage;
        this.identityManager = identityManager;
        this.userStateService = userStateService;
    }

    public MailIntegrationSetting createMailIntegrationSetting(MailIntegrationSetting mailIntegrationSetting) {
        String encodedPassword = MailIntegrationUtils.encode(mailIntegrationSetting.getPassword());
        mailIntegrationSetting.setPassword(encodedPassword);
        return this.mailIntegrationStorage.createMailIntegrationSetting(mailIntegrationSetting);
    }

    public List<MailIntegrationSetting> getMailIntegrationSettingsByUserId(long userIdentityId) {
        return this.mailIntegrationStorage.getMailIntegrationSettingsByUserId(userIdentityId);
    }

    public MailIntegrationSetting getMailIntegrationSetting(long mailIntegrationSettingId) {
        return this.mailIntegrationStorage.getMailIntegrationSettingById(mailIntegrationSettingId);
    }

    public void deleteMailIntegrationSetting(long mailIntegrationSettingId, long currentUserIdentityId) throws IllegalAccessException {
        List<MailIntegrationSetting> mailIntegrationSettings = this.mailIntegrationStorage.getMailIntegrationSettingByMailIntegrationSettingIdAndUserId(mailIntegrationSettingId, currentUserIdentityId);
        if (mailIntegrationSettings.isEmpty()) {
            throw new IllegalAccessException("User " + currentUserIdentityId + " is not allowed to delete mail integration settings with id " + mailIntegrationSettingId);
        }
        this.mailIntegrationStorage.deleteMailIntegrationSetting(mailIntegrationSettingId);
    }

    public Store connect(MailIntegrationSetting mailIntegrationSetting) {
        Properties props = new Properties();
        String usedPort = String.valueOf(mailIntegrationSetting.getPort());
        if (StringUtils.equals((CharSequence)mailIntegrationSetting.getEncryption(), (CharSequence)MAIL_SSL)) {
            props.setProperty("mail.imaps.ssl.enable", "true");
            props.setProperty("mail.store.protocol", MAIL_IMAPS);
            props.setProperty("mail.imaps.port", usedPort);
        }
        Session session = Session.getDefaultInstance((Properties)props, null);
        Store store = null;
        try {
            store = session.getStore();
            store.connect(mailIntegrationSetting.getImapUrl(), (int)mailIntegrationSetting.getPort(), mailIntegrationSetting.getAccount(), mailIntegrationSetting.getPassword());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new IllegalArgumentException("Invalid provider name", noSuchProviderException);
        }
        catch (MessagingException messagingException) {
            throw new IllegalStateException("Messaging exception", messagingException);
        }
        return store;
    }

    public void sendMailIntegrationNotifications() {
        List<MailIntegrationSetting> mailIntegrationSettings = this.mailIntegrationStorage.getMailIntegrationSettings();
        for (MailIntegrationSetting mailIntegrationSetting : mailIntegrationSettings) {
            Identity userIdentity = this.identityManager.getIdentity(String.valueOf(mailIntegrationSetting.getUserId()));
            if (userIdentity == null || !this.userStateService.isOnline(userIdentity.getRemoteId())) continue;
            try {
                mailIntegrationSetting.setPassword(MailIntegrationUtils.decode(mailIntegrationSetting.getPassword()));
                List<String> newMessages = this.getNewMessages(mailIntegrationSetting);
                if (newMessages.isEmpty()) continue;
                NotificationContext ctx = NotificationContextImpl.cloneInstance().append(MailIntegrationNotificationPlugin.CONTEXT, (Object)NotificationConstants.NOTIFICATION_CONTEXT.NEW_EMAILS_RECIEVED).append(MailIntegrationNotificationPlugin.RECEIVER, (Object)userIdentity.getRemoteId()).append(MailIntegrationNotificationPlugin.NEW_MESSAGES, (Object)String.valueOf(mailIntegrationSetting.getId()).concat(";").concat(String.join((CharSequence)",", newMessages)));
                ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"MailIntegrationNotificationPlugin"))).execute(ctx);
            }
            catch (MessagingException messagingException) {
                LOG.error((Object)"unable to get new messages", (Throwable)messagingException);
            }
        }
    }

    public MessageRestEntity getMessageById(long mailIntegrationSettingId, String messageId, long currentUserIdentityId) throws IllegalAccessException {
        List<MailIntegrationSetting> mailIntegrationSettings = this.mailIntegrationStorage.getMailIntegrationSettingByMailIntegrationSettingIdAndUserId(mailIntegrationSettingId, currentUserIdentityId);
        if (mailIntegrationSettings.isEmpty()) {
            throw new IllegalAccessException("User " + currentUserIdentityId + " is not allowed to get mail integration settings with id " + mailIntegrationSettingId);
        }
        MailIntegrationSetting mailIntegrationSetting = this.getMailIntegrationSetting(mailIntegrationSettingId);
        mailIntegrationSetting.setPassword(MailIntegrationUtils.decode(mailIntegrationSetting.getPassword()));
        Store store = this.connect(mailIntegrationSetting);
        MessageRestEntity messageRestEntity = null;
        try {
            Folder inbox = store.getFolder("INBOX");
            inbox.open(1);
            UIDFolder uidInbox = (UIDFolder)inbox;
            Message message = uidInbox.getMessageByUID(Long.parseLong(messageId));
            messageRestEntity = RestEntityBuilder.fromMessage(message);
            inbox.close(false);
            store.close();
        }
        catch (MessagingException messagingException) {
            LOG.error((Object)"unable to get or open folder", (Throwable)messagingException);
        }
        catch (IOException e) {
            LOG.error((Object)"Error when getting attachments", (Throwable)e);
        }
        return messageRestEntity;
    }

    public MailIntegrationSetting updateMailIntegrationSetting(MailIntegrationSetting mailIntegrationSetting, long currentUserIdentityId) throws IllegalAccessException {
        List<MailIntegrationSetting> mailIntegrationSettings = this.mailIntegrationStorage.getMailIntegrationSettingByMailIntegrationSettingIdAndUserId(mailIntegrationSetting.getId(), currentUserIdentityId);
        if (mailIntegrationSettings.isEmpty()) {
            throw new IllegalAccessException("User " + currentUserIdentityId + " is not allowed to update mail integration settings with id " + mailIntegrationSetting.getId());
        }
        String encodedPassword = MailIntegrationUtils.encode(mailIntegrationSetting.getPassword());
        mailIntegrationSetting.setPassword(encodedPassword);
        return this.mailIntegrationStorage.updateMailIntegrationSetting(mailIntegrationSetting);
    }

    private List<String> getNewMessages(MailIntegrationSetting mailIntegrationSetting) throws MessagingException {
        Store store = this.connect(mailIntegrationSetting);
        ArrayList<String> newMessages = new ArrayList<String>();
        Folder inbox = store.getFolder("INBOX");
        inbox.open(1);
        Date now = new Date();
        UIDFolder uidInbox = (UIDFolder)inbox;
        Message[] messages = inbox.getMessages();
        for (int i = inbox.getMessageCount() - 1; i > 0 && this.isNewMessage(messages[i].getSentDate(), now); --i) {
            if (messages[i].isSet(Flags.Flag.SEEN)) continue;
            newMessages.add(String.valueOf(uidInbox.getUID(messages[i])));
        }
        inbox.close(false);
        store.close();
        return newMessages;
    }

    private boolean isNewMessage(Date messageSentDate, Date now) {
        String mailIntegrationNotificationJobPeriod = System.getProperty("exo.mailIntegration.MailIntegrationNotificationJob.period", "900000");
        return ZonedDateTime.ofInstant(messageSentDate.toInstant(), ZoneOffset.UTC).isAfter(ZonedDateTime.ofInstant(now.toInstant(), ZoneOffset.UTC).minusMinutes(Long.parseLong(mailIntegrationNotificationJobPeriod) / 60000L));
    }
}

