/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.service;

import java.util.List;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ReminderServiceImpl
implements Startable {
    private static final Log log = ExoLogger.getLogger(ReminderServiceImpl.class);
    private Boolean isExistGroupMaintenance = false;
    public static String nameCalendarMaintenance = "Maintenance";

    public void start() {
        log.info((Object)("initializing " + nameCalendarMaintenance + " group calendar"));
        String username = "root";
        Calendar cal = new Calendar();
        CalendarService calendarService = (CalendarService)PortalContainer.getInstance().getComponentInstance(CalendarService.class);
        try {
            List groupCalendarDataList = calendarService.getGroupCalendars(new String[]{"/platform/users"}, true, username);
            for (GroupCalendarData groupCalendar : groupCalendarDataList) {
                for (Calendar calen : groupCalendar.getCalendars()) {
                    if (!calen.getName().equals(nameCalendarMaintenance)) continue;
                    this.isExistGroupMaintenance = true;
                }
            }
            if (!this.isExistGroupMaintenance.booleanValue()) {
                log.info((Object)("Create group calendar: " + nameCalendarMaintenance));
                this.initializeCalendarMaintenance(calendarService, cal, nameCalendarMaintenance);
            } else {
                log.info((Object)("Exist already group calendar: " + nameCalendarMaintenance));
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void stop() {
    }

    private void initializeCalendarMaintenance(CalendarService calendarService, Calendar calTempo, String nameCalendarMaintenance) throws Exception {
        calTempo.setName(nameCalendarMaintenance);
        calTempo.setDescription("Maintenance Event");
        calTempo.setPublic(true);
        calTempo.setGroups(new String[]{"/platform/users"});
        calTempo.setViewPermission(new String[]{"/platform/users/:*.*"});
        calTempo.setEditPermission(new String[]{"/platform/administrators/:*.*"});
        calendarService.savePublicCalendar(calTempo, true);
    }
}

