/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.jcr.RepositoryException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.service.ReminderServiceImpl;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.joda.time.DateTimeZone;

@Path(value="/reminderservice")
@RolesAllowed(value={"users"})
public class ReminderRestService
implements ResourceContainer {
    private static final Log log = ExoLogger.getLogger((String)ReminderRestService.class.getName());
    private static final int HOUR_BEFORE = 1;
    static Map<String, List<MessageReminder>> mapReminderResult;
    static Map<String, java.util.Calendar> mapReminderTime;
    private static final CacheControl cacheControl;

    public ReminderRestService() {
        mapReminderResult = new HashMap<String, List<MessageReminder>>();
        mapReminderTime = new HashMap<String, java.util.Calendar>();
    }

    @GET
    @Path(value="call")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response callpopup(@Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        if (ReminderRestService.isRefreshResults(mapReminderResult, mapReminderTime, ReminderRestService.getNameTenant())) {
            log.debug((Object)("REFRESH UPDATED--- at " + ReminderRestService.getNameTenant()));
            ArrayList<MessageReminder> listCommentMessages = new ArrayList<MessageReminder>();
            String username = ReminderRestService.getUserId(sc, uriInfo);
            Calendar cal = new Calendar();
            CalendarService calendarService = (CalendarService)PortalContainer.getInstance().getComponentInstance(CalendarService.class);
            String timeZoneString = cal.getTimeZone();
            timeZoneString = timeZoneString.contains("+") ? timeZoneString.substring(timeZoneString.indexOf(43)) : timeZoneString;
            timeZoneString = timeZoneString.contains("-") ? timeZoneString.substring(timeZoneString.indexOf(45)) : timeZoneString;
            DateTimeZone timeZone = DateTimeZone.forID((String)timeZoneString);
            java.util.Calendar timeCurrent = java.util.Calendar.getInstance(timeZone.toTimeZone());
            timeCurrent.set(11, timeCurrent.get(11) - 1);
            Date timeCurrentBefore1Hour = timeCurrent.getTime();
            timeCurrent.set(11, timeCurrent.get(11) + 2);
            Date timeCurrentAfter1Hour = timeCurrent.getTime();
            timeCurrent.set(11, timeCurrent.get(11) - 1);
            EventQuery eventQuery = new EventQuery();
            String[] idCalendarAdmin = new String[]{""};
            List groupCalendarAdminList = calendarService.getGroupCalendars(new String[]{"/platform/users"}, true, username);
            for (GroupCalendarData group : groupCalendarAdminList) {
                for (Calendar itemCalendar : group.getCalendars()) {
                    if (!itemCalendar.getName().equals(ReminderServiceImpl.nameCalendarMaintenance)) continue;
                    idCalendarAdmin[idCalendarAdmin.length - 1] = itemCalendar.getId();
                }
            }
            eventQuery.setCalendarId(idCalendarAdmin);
            List events = calendarService.getPublicEvents(eventQuery);
            for (CalendarEvent baseResultEvent : events) {
                MessageReminder msgReminder = new MessageReminder();
                if (Utils.isRepeatEvent((CalendarEvent)baseResultEvent)) {
                    Collection calendarCollection = calendarService.buildSeries(baseResultEvent, timeCurrentBefore1Hour, timeCurrentAfter1Hour, username);
                    Iterator iteratorCalendar = calendarCollection.iterator();
                    log.debug((Object)"=======REPEAT EVENT=======");
                    while (iteratorCalendar.hasNext()) {
                        CalendarEvent calendarRepeat = (CalendarEvent)iteratorCalendar.next();
                        List listReminder = calendarRepeat.getReminders();
                        for (Reminder reminderItem : listReminder) {
                            reminderItem.setFromDateTime(baseResultEvent.getFromDateTime());
                            if (StringUtils.isEmpty((String)reminderItem.getDescription())) {
                                reminderItem.setDescription(calendarRepeat.getDescription());
                            }
                            ReminderRestService.displayWarningReminderPopup(reminderItem, timeCurrent, msgReminder);
                        }
                    }
                } else {
                    log.debug((Object)"=======NOT REPEAT EVENT=======");
                    List listReminder = baseResultEvent.getReminders();
                    for (Reminder reminderItem : listReminder) {
                        reminderItem.setFromDateTime(baseResultEvent.getFromDateTime());
                        if (StringUtils.isEmpty((String)reminderItem.getDescription())) {
                            reminderItem.setDescription(baseResultEvent.getDescription());
                        }
                        ReminderRestService.displayWarningReminderPopup(reminderItem, timeCurrent, msgReminder);
                    }
                }
                listCommentMessages.add(msgReminder);
            }
            mapReminderResult.put(ReminderRestService.getNameTenant(), listCommentMessages);
            mapReminderTime.put(ReminderRestService.getNameTenant(), java.util.Calendar.getInstance());
        } else {
            log.debug((Object)("NO UPDATED--- at " + ReminderRestService.getNameTenant()));
        }
        return Response.ok(mapReminderResult.get(ReminderRestService.getNameTenant()), (String)"application/json").cacheControl(cacheControl).build();
    }

    private static void displayWarningReminderPopup(Reminder reminderItem, java.util.Calendar timeCurrent, MessageReminder msgReminder) {
        if (reminderItem.getReminderType().equals(Reminder.TYPE_POPUP)) {
            long minuteBeforeEventStarts = reminderItem.getAlarmBefore() * 60L * 1000L;
            Date fromDateTime = reminderItem.getFromDateTime();
            Date timeBeforeEventStarts = new Date(fromDateTime.getTime() - minuteBeforeEventStarts);
            fromDateTime = ReminderRestService.fixTimeZone(fromDateTime);
            Boolean before = timeCurrent.getTime().after(timeBeforeEventStarts);
            Boolean after = timeCurrent.getTime().before(fromDateTime);
            if (before.booleanValue() && after.booleanValue()) {
                log.debug((Object)"======= DISPLAY REMINDER POPUP=======");
                log.debug((Object)reminderItem.getDescription());
                if (fromDateTime != null) {
                    msgReminder.setFromDate(fromDateTime);
                    msgReminder.setToDate(new Date());
                    msgReminder.setDescription(reminderItem.getDescription());
                    msgReminder.setSummary(reminderItem.getSummary());
                    msgReminder.setRepeatIntervalMinute(reminderItem.getRepeatInterval());
                }
            }
        }
    }

    private static Date fixTimeZone(Date fromDateTime) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTimeInMillis(fromDateTime.getTime() - (long)(fromDateTime.getTimezoneOffset() * 60 * 1000));
        fromDateTime = calendar.getTime();
        return fromDateTime;
    }

    private static String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (NullPointerException e) {
            return ReminderRestService.getViewerId(uriInfo);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getViewerId(UriInfo uriInfo) {
        String[] queryParts;
        URI uri = uriInfo.getRequestUri();
        String requestString = uri.getQuery();
        if (requestString == null) {
            return null;
        }
        for (String queryPart : queryParts = requestString.split("&")) {
            if (!queryPart.startsWith("opensocial_viewer_id")) continue;
            return queryPart.substring(queryPart.indexOf("=") + 1, queryPart.length());
        }
        return null;
    }

    public static boolean isRefreshResults(Map<String, List<MessageReminder>> mapReminderResult, Map<String, java.util.Calendar> mapReminderTime, String nameTenant) throws RepositoryException {
        java.util.Calendar timeCurrent = java.util.Calendar.getInstance();
        long FiveMinutes = 179000L;
        if (mapReminderResult.get(ReminderRestService.getNameTenant()) == null) {
            return true;
        }
        if (mapReminderResult.get(ReminderRestService.getNameTenant()).isEmpty()) {
            return true;
        }
        if (mapReminderResult.get(ReminderRestService.getNameTenant()).get(mapReminderResult.get(ReminderRestService.getNameTenant()).size() - 1).getDescription() == null) {
            return true;
        }
        return timeCurrent.getTimeInMillis() - mapReminderTime.get(ReminderRestService.getNameTenant()).getTimeInMillis() > FiveMinutes;
    }

    static String getNameTenant() throws RepositoryException {
        RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
        ManageableRepository currentRepo = repositoryService.getCurrentRepository();
        return currentRepo.getConfiguration().getName();
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }

    public class MessageReminder
    implements Comparable<MessageReminder> {
        private String Summary;
        private String Description;
        private Date fromDate;
        private Date toDate;
        private long RepeatIntervalMinute;

        public String getSummary() {
            return this.Summary;
        }

        public void setSummary(String summary) {
            this.Summary = summary;
        }

        public String getDescription() {
            return this.Description;
        }

        public void setDescription(String description) {
            this.Description = description;
        }

        public Date getFromDate() {
            return this.fromDate;
        }

        public void setFromDate(Date fromDate) {
            this.fromDate = fromDate;
        }

        public Date getToDate() {
            return this.toDate;
        }

        public void setToDate(Date toDate) {
            this.toDate = toDate;
        }

        public long getRepeatIntervalMinute() {
            return this.RepeatIntervalMinute;
        }

        public void setRepeatIntervalMinute(long repeatIntervalMinute) {
            this.RepeatIntervalMinute = repeatIntervalMinute;
        }

        @Override
        public int compareTo(MessageReminder commentMessage) {
            return this.fromDate.compareTo(commentMessage.getFromDate());
        }
    }
}

