/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.service;

import java.net.URI;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.addon.service.AddOnService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.provider.OrganizationIdentityProvider;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.wcm.connector.BaseConnector;

@Path(value="/addonservice/")
@RolesAllowed(value={"users"})
public class AddOnRestService
extends BaseConnector
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)AddOnRestService.class.getName());
    private static final CacheControl cacheControl;
    CommentsService commentsService_;
    IdentityManager identityManager_;
    OrganizationIdentityProvider organizationIdentityProvider_;
    OrganizationService organizationService_ = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
    UserACL userACL_;
    AddOnService addOnService_;

    public AddOnRestService(UserACL userACL) {
        this.commentsService_ = (CommentsService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CommentsService.class);
        this.identityManager_ = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
        this.organizationIdentityProvider_ = (OrganizationIdentityProvider)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationIdentityProvider.class);
        this.userACL_ = userACL;
        this.addOnService_ = (AddOnService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(AddOnService.class);
    }

    @GET
    @Path(value="/migrate")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response migrate(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            Node homeNode = AddOnService.getNode("/sites/intranet/web contents/Contributions");
            NodeIterator iterator = homeNode.getNodes();
            while (iterator.hasNext()) {
                try {
                    Node node = iterator.nextNode();
                    LOG.info((Object)("Start migrate node: " + node.getPath()));
                    node.addMixin("mix:commentable");
                    node.addMixin("mix:votable");
                    node.save();
                }
                catch (Exception e) {
                    LOG.warn((Object)e);
                }
            }
            return Response.ok((Object)"Migrate successfully", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception exception) {
            return Response.ok((Object)"Migrate failured", (String)"application/json").cacheControl(cacheControl).build();
        }
    }

    @POST
    @Path(value="/edit-comment")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response editComment(@Context SecurityContext sc, @Context UriInfo uriInfo, @FormParam(value="jcrPath") String jcrPath, @FormParam(value="commentId") String commentId, @FormParam(value="newComment") String newComment) throws Exception {
        String viewUsername = this.getUserId(sc, uriInfo);
        boolean viewerIsAdmin = this.checkInvokeUserPermission(viewUsername);
        if (jcrPath.contains("%20")) {
            jcrPath = URLDecoder.decode(jcrPath, "UTF-8");
        }
        String[] path = jcrPath.split("/");
        String repositoryName = path[1];
        String workspaceName = path[2];
        if ((jcrPath = jcrPath.substring(repositoryName.length() + workspaceName.length() + 2)).charAt(1) == '/') {
            jcrPath.substring(1);
        }
        try {
            Node content = this.getContent(workspaceName, jcrPath, null, false);
            List comments = this.commentsService_.getComments(content, null);
            for (Node comment : comments) {
                String id = comment.getProperty("exo:name").getString();
                String commentor = comment.getProperty("exo:commentor").getString();
                if (!commentId.equals(id) || !commentor.equals(viewUsername) && !viewerIsAdmin) continue;
                this.commentsService_.updateComment(comment, newComment);
                return Response.ok((Object)true, (String)"application/json").cacheControl(cacheControl).build();
            }
        }
        catch (Exception e) {
            Response.serverError().build();
        }
        return Response.ok((Object)false, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/delete-comment")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response deleteComment(@Context SecurityContext sc, @Context UriInfo uriInfo, @QueryParam(value="jcrPath") String jcrPath, @QueryParam(value="commentId") String commentId) throws Exception {
        String viewUsername = this.getUserId(sc, uriInfo);
        boolean viewerIsAdmin = this.checkInvokeUserPermission(viewUsername);
        if (jcrPath.contains("%20")) {
            jcrPath = URLDecoder.decode(jcrPath, "UTF-8");
        }
        String[] path = jcrPath.split("/");
        String repositoryName = path[1];
        String workspaceName = path[2];
        if ((jcrPath = jcrPath.substring(repositoryName.length() + workspaceName.length() + 2)).charAt(1) == '/') {
            jcrPath.substring(1);
        }
        try {
            Node content = this.getContent(workspaceName, jcrPath, null, false);
            List comments = this.commentsService_.getComments(content, null);
            for (Node comment : comments) {
                String id = comment.getProperty("exo:name").getString();
                String commentor = comment.getProperty("exo:commentor").getString();
                if (!commentId.equals(id) || !commentor.equals(viewUsername) && !viewerIsAdmin) continue;
                this.commentsService_.deleteComment(comment);
                return Response.ok((Object)true, (String)"application/json").cacheControl(cacheControl).build();
            }
        }
        catch (Exception e) {
            Response.serverError().build();
        }
        return Response.ok((Object)false, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/all-comment")
    @Produces(value={"application/json"})
    public Response getComments(@Context SecurityContext sc, @Context UriInfo uriInfo, @QueryParam(value="jcrPath") String jcrPath) throws Exception {
        ArrayList<CommentMessage> listCommentMessages = new ArrayList<CommentMessage>();
        String viewUsername = this.getUserId(sc, uriInfo);
        boolean viewerIsAdmin = this.checkInvokeUserPermission(viewUsername);
        if (jcrPath.contains("%20")) {
            jcrPath = URLDecoder.decode(jcrPath, "UTF-8");
        }
        String[] path = jcrPath.split("/");
        String repositoryName = path[1];
        String workspaceName = path[2];
        if ((jcrPath = jcrPath.substring(repositoryName.length() + workspaceName.length() + 2)).charAt(1) == '/') {
            jcrPath.substring(1);
        }
        try {
            Node content = this.getContent(workspaceName, jcrPath, null, false);
            List comments = this.commentsService_.getComments(content, null);
            for (Node comment : comments) {
                CommentMessage commentMessage = new CommentMessage();
                if (comment.hasProperty("exo:name")) {
                    commentMessage.setId(comment.getProperty("exo:name").getString());
                }
                if (comment.hasProperty("exo:commentContent")) {
                    commentMessage.setCommentDetail(comment.getProperty("exo:commentContent").getString());
                }
                if (comment.hasProperty("exo:commentor")) {
                    commentMessage.setCommentorUsername(comment.getProperty("exo:commentor").getString());
                }
                if (comment.hasProperty("exo:dateCreated")) {
                    commentMessage.setCreateDate(DateFormat.getDateTimeInstance().format(comment.getProperty("exo:dateCreated").getDate().getTime()));
                    commentMessage.setCommentCreatedDate(comment.getProperty("exo:dateCreated").getDate().getTime());
                }
                Profile userProfile = this.getSocialProfile(commentMessage.getCommentorUsername());
                commentMessage.setCommentorAvataUrl(userProfile.getAvatarUrl());
                commentMessage.setCommentorFullname(userProfile.getFullName(true));
                if (null != viewUsername && (viewUsername.equals(commentMessage.getCommentorUsername()) || viewerIsAdmin)) {
                    commentMessage.setCanDelete(true);
                } else {
                    commentMessage.setCanDelete(false);
                }
                listCommentMessages.add(commentMessage);
            }
            Collections.sort(listCommentMessages);
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            return Response.ok(listCommentMessages, (String)"application/json").header("Last-Modified", (Object)dateFormat.format(new Date())).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            Response.serverError().build();
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).cacheControl(cacheControl).build();
        }
    }

    Profile getSocialProfile(String username) {
        String avatar = "/social-resources/skin/images/ShareImages/UserAvtDefault.png";
        try {
            Identity userIdentity = this.identityManager_.getOrCreateIdentity("organization", username, true);
            Profile userProfile = userIdentity.getProfile();
            if (null == userProfile.getAvatarUrl() || userProfile.getAvatarUrl().length() == 0) {
                userProfile.setAvatarUrl(avatar);
            }
            return userProfile;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean checkInvokeUserPermission(String invokeUserId) {
        if (this.userACL_.getSuperUser().equalsIgnoreCase(invokeUserId)) {
            return true;
        }
        try {
            Collection membershipCollection = this.organizationService_.getMembershipHandler().findMembershipsByUserAndGroup(invokeUserId, "/platform/administrators");
            if (membershipCollection.isEmpty()) {
                return false;
            }
            for (Membership membership : membershipCollection) {
                String membershipType = membership.getMembershipType();
                if (!membershipType.equals("*") && !membershipType.equals("manager")) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return false;
        }
        return false;
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (NullPointerException e) {
            return this.getViewerId(uriInfo);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getViewerId(UriInfo uriInfo) {
        String[] queryParts;
        URI uri = uriInfo.getRequestUri();
        String requestString = uri.getQuery();
        if (requestString == null) {
            return null;
        }
        for (String queryPart : queryParts = requestString.split("&")) {
            if (!queryPart.startsWith("opensocial_viewer_id")) continue;
            return queryPart.substring(queryPart.indexOf("=") + 1, queryPart.length());
        }
        return null;
    }

    protected Node getRootContentStorage(Node parentNode) throws Exception {
        try {
            PortalFolderSchemaHandler folderSchemaHandler = (PortalFolderSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
            return folderSchemaHandler.getDocumentStorage(parentNode);
        }
        catch (Exception e) {
            WebContentSchemaHandler webContentSchemaHandler = (WebContentSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
            return webContentSchemaHandler.getDocumentFolder(parentNode);
        }
    }

    protected String getContentStorageType() throws Exception {
        return "file";
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }

    public class CommentMessage
    implements Comparable<CommentMessage> {
        private String Id;
        private String commentorFullname;
        private String commentorUsername;
        private String commentorAvataUrl;
        private String commentDetail;
        private String createDate;
        private Date commentCreatedDate;
        private boolean canDelete;

        public Date getCommentCreatedDate() {
            return this.commentCreatedDate;
        }

        public void setCommentCreatedDate(Date commentCreatedDate) {
            this.commentCreatedDate = commentCreatedDate;
        }

        public boolean isCanDelete() {
            return this.canDelete;
        }

        public void setCanDelete(boolean canDelete) {
            this.canDelete = canDelete;
        }

        public String getId() {
            return this.Id;
        }

        public void setId(String id) {
            this.Id = id;
        }

        public String getCommentorFullname() {
            return this.commentorFullname;
        }

        public void setCommentorFullname(String commentorFullname) {
            this.commentorFullname = commentorFullname;
        }

        public String getCommentorUsername() {
            return this.commentorUsername;
        }

        public void setCommentorUsername(String commentorUsername) {
            this.commentorUsername = commentorUsername;
        }

        public String getCommentorAvataUrl() {
            return this.commentorAvataUrl;
        }

        public void setCommentorAvataUrl(String commentorAvataUrl) {
            this.commentorAvataUrl = commentorAvataUrl;
        }

        public String getCommentDetail() {
            return this.commentDetail;
        }

        public void setCommentDetail(String commentDetail) {
            this.commentDetail = commentDetail;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        @Override
        public int compareTo(CommentMessage commentMessage) {
            return this.commentCreatedDate.compareTo(commentMessage.getCommentCreatedDate());
        }
    }
}

