/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;

public class AddOnService {
    public static final String PREFERENCE_RECEIVER = "adminEmail";
    public static final String PREFERENCE_FROM = "fromEmail";
    public static final String PREFERENCE_FROM_NAME = "fromName";
    public static final String PREFERENCE_EMAIL_SUBJECT = "emailsubject";
    public static final String PREFERENCE_ITEM_PATH = "folderPath";
    public static final String PREFERENCE_SITE = "siteName";
    public static final String MIX_VOTEABLE_NODE_TYPE = "mix:votable";
    public static final String MIX_COMMENTABLE_NODE_TYPE = "mix:commentable";
    public static final String EXO_PRIVILEGEABLE_NODE_TYPE = "exo:privilegeable";
    private static final Log log = ExoLogger.getLogger(AddOnService.class);
    public static String imgPathBase = "/rest/jcr/repository/collaboration";

    public static Node getNode(String path) throws PathNotFoundException, RepositoryException {
        if (path == null || path.equals("")) {
            return null;
        }
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        Session session = sessionProvider.getSession(WCMCoreUtils.getRepository().getConfiguration().getDefaultWorkspaceName(), WCMCoreUtils.getRepository());
        return (Node)session.getItem(path);
    }

    public static Node getNodeById(String uuid) throws PathNotFoundException, RepositoryException {
        if (null == uuid || "".equals(uuid)) {
            return null;
        }
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        Session session = sessionProvider.getSession(WCMCoreUtils.getRepository().getConfiguration().getDefaultWorkspaceName(), WCMCoreUtils.getRepository());
        return session.getNodeByUUID(uuid);
    }

    public static String getStrProperty(Node node, String propertyName) throws RepositoryException {
        if (node != null && node.hasProperty(propertyName)) {
            Property prop = node.getProperty(propertyName);
            String res = prop.getString();
            return res;
        }
        return null;
    }

    public static String getImageCover(Node node) throws PathNotFoundException, RepositoryException {
        NodeIterator iterator;
        Node mediaNode;
        String path = "/marketplace-extension-webapp/skin/css/images/addons-icon.jpg";
        if (node != null && (mediaNode = node.getNode("medias/images")) != null && (iterator = mediaNode.getNodes()).getSize() > 0L) {
            Node firstNode = iterator.nextNode();
            path = "/rest/jcr/repository/collaboration" + firstNode.getPath();
        }
        return path;
    }

    public static List<String> getImagesNode(Node node) throws Exception, RepositoryException {
        ArrayList<String> images = new ArrayList<String>();
        if (node != null) {
            Node mediaNode = node.getNode("medias/images");
            NodeIterator nodeIterator = mediaNode.getNodes();
            while (nodeIterator.hasNext()) {
                Node img = nodeIterator.nextNode();
                if (img.getPath() == null) continue;
                images.add(imgPathBase + img.getPath());
            }
        }
        return images;
    }

    public static String getAvatarNode(Node node) throws Exception, RepositoryException {
        if (node != null && node.hasNode("medias/avatar")) {
            Node mediaNode = node.getNode("medias/avatar");
            NodeIterator nodeIterator = mediaNode.getNodes();
            while (nodeIterator.hasNext()) {
                Node img = nodeIterator.nextNode();
                if (img.getPath() == null) continue;
                return imgPathBase + img.getPath();
            }
        }
        return null;
    }

    public static Node updateNode(String title, String name, Boolean hosted, Map<String, String> map, Boolean isNew) throws Exception {
        String nodeType = "exo:addon";
        Node homeNode = AddOnService.createCommunityFolder();
        HashMap<String, JcrInputProperty> inputProperties = new HashMap<String, JcrInputProperty>();
        String nodePath = "";
        JcrInputProperty h = new JcrInputProperty();
        h.setJcrPath("/node/default.html");
        h.setNodetype("nt:file");
        h.setValue((Object)"default.html");
        h.setMixintype("exo:htmlFile");
        inputProperties.put("/node/default.html", h);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            JcrInputProperty jcrinputProperty = new JcrInputProperty();
            jcrinputProperty.setJcrPath("/node/" + entry.getKey());
            jcrinputProperty.setValue((Object)entry.getValue());
            inputProperties.put("/node/" + entry.getKey(), jcrinputProperty);
        }
        JcrInputProperty hostedProp = new JcrInputProperty();
        hostedProp.setJcrPath("/node/exo:hosted");
        hostedProp.setValue((Object)hosted);
        inputProperties.put("/node/exo:hosted", hostedProp);
        JcrInputProperty nameNode = new JcrInputProperty();
        nameNode.setValue((Object)name);
        inputProperties.put("/node", nameNode);
        CmsService cmsService = (CmsService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CmsService.class);
        try {
            nodePath = cmsService.storeNode(nodeType, homeNode, inputProperties, isNew.booleanValue());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        String[] temp = nodePath.split("/");
        String currentNodeName = temp[temp.length - 1];
        Node currentNode = homeNode.getNode(currentNodeName);
        homeNode.getSession().save();
        return currentNode;
    }

    public static Node storeNode(String title, String name, Boolean hosted, Map<String, String> map, Boolean isNew) throws Exception {
        String nodeType = "exo:addon";
        Node homeNode = AddOnService.createCommunityFolder();
        HashMap<String, JcrInputProperty> inputProperties = new HashMap<String, JcrInputProperty>();
        String nodePath = "";
        JcrInputProperty h = new JcrInputProperty();
        h.setJcrPath("/node/default.html");
        h.setNodetype("nt:file");
        h.setValue((Object)"default.html");
        h.setMixintype("exo:htmlFile");
        inputProperties.put("/node/default.html", h);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            JcrInputProperty jcrinputProperty = new JcrInputProperty();
            jcrinputProperty.setJcrPath("/node/" + entry.getKey());
            jcrinputProperty.setValue((Object)entry.getValue());
            inputProperties.put("/node/" + entry.getKey(), jcrinputProperty);
        }
        JcrInputProperty sendConfirmEmailProp = new JcrInputProperty();
        sendConfirmEmailProp.setJcrPath("/node/exo:sendConfirmEmail");
        sendConfirmEmailProp.setValue((Object)false);
        inputProperties.put("/node/exo:sendConfirmEmail", sendConfirmEmailProp);
        JcrInputProperty hostedProp = new JcrInputProperty();
        hostedProp.setJcrPath("/node/exo:hosted");
        hostedProp.setValue((Object)hosted);
        inputProperties.put("/node/exo:hosted", hostedProp);
        JcrInputProperty js = new JcrInputProperty();
        js.setJcrPath("/node/js/default.js");
        js.setNodetype("nt:file");
        js.setValue((Object)"default.js");
        inputProperties.put("/node/js/default.js", js);
        JcrInputProperty jsData = new JcrInputProperty();
        jsData.setJcrPath("/node/js/default.js/jcr:content/jcr:data");
        inputProperties.put("/node/js/default.js/jcr:content/jcr:data", jsData);
        JcrInputProperty contentJs = new JcrInputProperty();
        contentJs.setJcrPath("/node/js/default.js/jcr:content");
        contentJs.setNodetype("nt:resource");
        contentJs.setMixintype("dc:elementSet");
        inputProperties.put("/node/js/default.js/jcr:content", contentJs);
        JcrInputProperty video = new JcrInputProperty();
        video.setJcrPath("/node/medias/videos");
        video.setNodetype("nt:folder");
        video.setValue((Object)"videos");
        inputProperties.put("/node/medias/videos", video);
        JcrInputProperty image = new JcrInputProperty();
        image.setJcrPath("/node/medias/images");
        image.setNodetype("nt:folder");
        image.setValue((Object)"images");
        inputProperties.put("/node/medias/images", image);
        JcrInputProperty contentData = new JcrInputProperty();
        contentData.setJcrPath("/node/default.html/jcr:content");
        contentData.setMixintype("dc:elementSet");
        contentData.setNodetype("nt:resource");
        contentData.setValueType(0);
        contentData.setType(1);
        inputProperties.put("/node/default.html/jcr:content", contentData);
        JcrInputProperty mineTypeHtml = new JcrInputProperty();
        mineTypeHtml.setJcrPath("/node/default.html/jcr:content/jcr:mimeType");
        mineTypeHtml.setValue((Object)"text/html");
        inputProperties.put("/node/default.html/jcr:content/jcr:mimeType", mineTypeHtml);
        JcrInputProperty htmlEncoding = new JcrInputProperty();
        htmlEncoding.setJcrPath("/node/default.html/jcr:content/jcr:encoding");
        htmlEncoding.setValue((Object)"UTF-8");
        inputProperties.put("/node/default.html/jcr:content/jcr:encoding", htmlEncoding);
        JcrInputProperty exoTitle = new JcrInputProperty();
        exoTitle.setJcrPath("/node/exo:title");
        exoTitle.setValue((Object)title);
        inputProperties.put("/node/exo:title", exoTitle);
        JcrInputProperty documentTitle = new JcrInputProperty();
        documentTitle.setJcrPath("/node/documents");
        documentTitle.setMixintype("exo:documentFolder");
        documentTitle.setNodetype("nt:unstructured");
        documentTitle.setValue((Object)"documents");
        inputProperties.put("/node/documents", documentTitle);
        JcrInputProperty css = new JcrInputProperty();
        css.setJcrPath("/node/css");
        css.setNodetype("exo:cssFolder");
        css.setValue((Object)"css");
        JcrInputProperty nameNode = new JcrInputProperty();
        nameNode.setValue((Object)name);
        inputProperties.put("/node", nameNode);
        CmsService cmsService = (CmsService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CmsService.class);
        try {
            nodePath = cmsService.storeNode(nodeType, homeNode, inputProperties, isNew.booleanValue());
        }
        catch (Exception e) {
            log.debug((Object)"Exceptions happen while storing data", (Throwable)e);
        }
        String[] temp = nodePath.split("/");
        String currentNodeName = temp[temp.length - 1];
        Node currentNode = homeNode.getNode(currentNodeName);
        Node cssNode = currentNode.addNode("css/default.css", "nt:file");
        Node cssContent = cssNode.addNode("jcr:content", "nt:resource");
        cssContent.setProperty("jcr:data", "");
        cssContent.setProperty("jcr:mimeType", "text/plain");
        cssContent.setProperty("jcr:encoding", "UTF-8");
        cssContent.setProperty("jcr:lastModified", new Date().getTime());
        Node jsNode = currentNode.addNode("js/default.js", "nt:file");
        Node jsContent = jsNode.addNode("jcr:content", "nt:resource");
        jsContent.setProperty("jcr:data", "");
        jsContent.setProperty("jcr:mimeType", "text/plain");
        jsContent.setProperty("jcr:encoding", "UTF-8");
        jsContent.setProperty("jcr:lastModified", new Date().getTime());
        currentNode.addMixin(MIX_COMMENTABLE_NODE_TYPE);
        currentNode.addMixin(MIX_VOTEABLE_NODE_TYPE);
        homeNode.getSession().save();
        return currentNode;
    }

    public static String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public static String getRestName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        String portalName = containerInfo.getContainerName();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)WCMCoreUtils.getService(PortalContainerConfig.class);
        return portalContainerConfig.getRestContextName(portalName);
    }

    public static String getAddOnHomePath() throws Exception {
        String siteName;
        String preference_item_path = Utils.getPortletPreference((String)PREFERENCE_ITEM_PATH);
        if (preference_item_path == null) {
            preference_item_path = "web contents/Contributions";
        }
        if ((siteName = Utils.getPortletPreference((String)PREFERENCE_SITE)) == null) {
            siteName = Util.getPortalRequestContext().getSiteName();
        }
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)WCMCoreUtils.getService(LivePortalManagerService.class);
        Node dummyNode = livePortalManagerService.getLivePortal(sessionProvider, siteName);
        String homePath = dummyNode.getPath() + "/" + preference_item_path + "/";
        return homePath;
    }

    public static Node createCommunityFolder() throws Exception {
        String siteName;
        String preference_item_path = Utils.getPortletPreference((String)PREFERENCE_ITEM_PATH);
        if (preference_item_path == null) {
            preference_item_path = "web contents/Contributions";
        }
        String folderName = null;
        if (preference_item_path != null) {
            String[] strs = preference_item_path.split("/");
            folderName = strs[strs.length - 1];
        }
        if ((siteName = Utils.getPortletPreference((String)PREFERENCE_SITE)) == null) {
            siteName = Util.getPortalRequestContext().getSiteName();
        }
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)WCMCoreUtils.getService(LivePortalManagerService.class);
        Node dummyNode = livePortalManagerService.getLivePortal(sessionProvider, siteName);
        if (!dummyNode.hasNode(preference_item_path)) {
            Session session = dummyNode.getSession();
            Node cmNode = dummyNode.addNode(preference_item_path, "nt:unstructured");
            cmNode.setProperty("exo:title", folderName);
            cmNode.addMixin(EXO_PRIVILEGEABLE_NODE_TYPE);
            HashMap<String, String[]> permissions = new HashMap<String, String[]>();
            permissions.put("*:/platform/administrators", PermissionType.ALL);
            permissions.put("*:/platform/users", new String[]{"read", "add_node", "set_property"});
            ((ExtendedNode)cmNode).setPermissions(permissions);
            session.save();
            return cmNode;
        }
        return dummyNode.getNode(preference_item_path);
    }

    public static void sendRequestReceiveMail(String receiver, String fromEmail, String hostName) throws Exception {
        MailService mailService = (MailService)WCMCoreUtils.getService(MailService.class);
        Message message = new Message();
        message.setTo(receiver);
        message.setFrom("eXo Resource Center<" + fromEmail + ">");
        String bodyMessage = "<br> Thank you for submitting your add-on.<br><br>=========================<br>" + hostName;
        message.setBody(bodyMessage);
        message.setMimeType("text/html");
        message.setSubject("Thank you for submitting your Add-on");
        mailService.sendMessage(message);
    }

    public static void sendNewAddonSubmisson(String receiver, String fromEmail, String subject, String email, String titleAddon, String description, String version, String license, String author, String compatibility, String sourceUrl, String documentUrl, String downloadUrl, String codeUrl, String demoUrl, String installCommand, Boolean hosted, String hostName) throws Exception {
        MailService mailService = (MailService)WCMCoreUtils.getService(MailService.class);
        Message message = new Message();
        message.setTo(receiver);
        message.setFrom("eXo Resource Center<" + fromEmail + ">");
        String _version = version != null ? "Version: " + version : "Version: ";
        String _license = license != null ? "License: " + license : "License: ";
        String _author = author != null ? "Author: " + author : "Author: ";
        String _compatibility = compatibility != null ? "Compatibility: " + compatibility : "Compatibility: ";
        String _sourceUrl = sourceUrl != null ? "Source Code: " + sourceUrl : "Source Code: ";
        String _documentUrl = documentUrl != null ? "Documentation: " + documentUrl : "Documentation: ";
        String _downloadUrl = downloadUrl != null ? "Download: " + downloadUrl : "Download: ";
        String _codeUrl = codeUrl != null ? "Code URL: " + codeUrl : "Code URL: ";
        String _demoUrl = demoUrl != null ? "Demo URL: " + demoUrl : "Demo URL: ";
        String _installCommand = installCommand != null ? "Install command: " + installCommand : "Install command: ";
        String _hosted = hosted != false ? "I wish my add-on to be hosted on the eXo Add-on repository on Github: Yes" : "I wish my add-on to be hosted on the eXo Add-on repository on Github: No";
        String bodyMessage = "The following add-on is submitted on " + hostName + "<br><br>" + "Add-on Name: " + titleAddon + "<br><br>" + "Description: " + description + "<br><br>" + _version + "<br><br>" + _license + "<br><br>" + _compatibility + "<br><br>" + _sourceUrl + "<br><br>" + _documentUrl + "<br><br>" + _downloadUrl + "<br><br>" + _codeUrl + "<br><br>" + _demoUrl + "<br><br>" + _installCommand + "<br><br>" + _hosted + "<br><br>" + _author + "<br><br>" + "Email (for internal use only): " + email + "<br><br>" + "Please login to the website back-end to validate or refuse the add-on. (go to \"Web contents\" folder > \"Contributions\" folder, add categories and publish. " + "<br><br>" + "=========================" + "<br>" + hostName;
        message.setBody(bodyMessage);
        message.setMimeType("text/html");
        message.setSubject(subject);
        mailService.sendMessage(message);
    }

    public static void SendConfirmationAddonPublishedEmail(String receiver, String nodeName, String hostName) throws Exception {
        String fromEmail = Utils.getPortletPreference((String)PREFERENCE_FROM);
        String fromName = Utils.getPortletPreference((String)PREFERENCE_FROM_NAME);
        String itemPath = Utils.getPortletPreference((String)PREFERENCE_ITEM_PATH);
        String[] strs = itemPath.split("/");
        String folder = strs[strs.length - 2];
        MailService mailService = (MailService)WCMCoreUtils.getService(MailService.class);
        Message message = new Message();
        String link = hostName + "/portal/intranet/addon-detail?content-id=/repository/collaboration/sites/intranet/web contents/Contributions/" + nodeName;
        message.setTo(receiver);
        message.setFrom(fromName + "<" + fromEmail + ">");
        String bodymess = "Thank your for contributing to the eXo Add-ons, your add-on has been validated and published.<br>Please access you add-on here: <a href='link' >" + link + "</a>" + "<br><br>" + "=========================" + "<br>" + hostName;
        message.setBody(bodymess);
        message.setMimeType("text/html");
        message.setSubject("Your Add-on has been validated and published on " + hostName);
        mailService.sendMessage(message);
    }

    public static boolean validateEmail(String email) {
        String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        Pattern pattern = Pattern.compile(EMAIL_PATTERN);
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }
}

