/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.utils;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.imgscalr.Scalr;

public class ImageUtils {
    public static final String KEY_SEPARATOR = "_";
    public static final String KEY_DIMENSION_SEPARATOR = "x";
    public static final String GIF_EXTENDSION = "gif";
    private static final Log LOG = ExoLogger.getLogger(ImageUtils.class);

    public static InputStream createResizedImage(InputStream imageStream, int width, int height, String imageMimeType) {
        try {
            MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
            BufferedImage image = null;
            int minSize = 0;
            String extension = mimeTypeResolver.getExtension(imageMimeType);
            if (extension.equalsIgnoreCase(GIF_EXTENDSION)) {
                return imageStream;
            }
            image = ImageIO.read(imageStream);
            if (height <= minSize & width <= minSize) {
                LOG.warn((Object)"Fail to resize image with dimention <= 0x0");
                return null;
            }
            if (height <= minSize) {
                height = image.getHeight() * width / image.getWidth();
            } else if (width <= minSize) {
                width = image.getWidth() * height / image.getHeight();
            }
            File tmp = File.createTempFile("RESIZED", null);
            BufferedImage bufferedImage = Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            ImageIO.write((RenderedImage)bufferedImage, extension, tmp);
            FileInputStream newImageInputStream = new FileInputStream(tmp);
            tmp.delete();
            return newImageInputStream;
        }
        catch (Exception e) {
            LOG.error((Object)("Fail to resize image " + e));
            return null;
        }
    }
}

