/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.marketplace.upgrade;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.addon.marketplace.Constants;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class UpgradeAddonNodeType
implements Startable,
Constants {
    private static final Log LOG = ExoLogger.getLogger((String)UpgradeAddonNodeType.class.getName());
    private String addonPath = "";
    private RepositoryService repositoryService;

    public UpgradeAddonNodeType(ThreadLocalSessionProviderService providerService, RepositoryService repoService, DMSConfiguration dmsConfiguration, InitParams initParams) {
        this.repositoryService = repoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Instant startExec;
        block9: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Start " + this.getClass().getName() + "............."));
            }
            startExec = Instant.now();
            SessionProvider sessionProvider = null;
            Session session = null;
            QueryManager queryManager = null;
            StringBuilder statement = null;
            Query query = null;
            QueryResult queryResult = null;
            ArrayList<Value> defaultMixinList = null;
            try {
                sessionProvider = SessionProvider.createSystemProvider();
                LivePortalManagerService livePortalManagerService = (LivePortalManagerService)WCMCoreUtils.getService(LivePortalManagerService.class);
                Node siteNode = livePortalManagerService.getLivePortal(sessionProvider, "intranet");
                this.addonPath = siteNode.getPath() + "/" + "web contents/Contributions" + "/";
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                session = sessionProvider.getSession(manageableRepository.getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
                queryManager = session.getWorkspace().getQueryManager();
                statement = new StringBuilder("SELECT * FROM exo:addon");
                statement.append(" WHERE mix:mpkaceAddonCatName is null");
                statement.append(" AND ");
                statement.append("jcr:path LIKE '" + this.addonPath + "%'");
                statement.append(" ORDER BY exo:dateCreated DESC ");
                query = queryManager.createQuery(statement.toString(), "sql");
                queryResult = query.execute();
                defaultMixinList = new ArrayList<Value>();
                defaultMixinList.add(session.getValueFactory().createValue(""));
                NodeIterator iter = queryResult.getNodes();
                while (iter.hasNext()) {
                    Node addon = iter.nextNode();
                    if (!addon.isNodeType("mix:mpkaceAddonCat") && addon.canAddMixin("mix:mpkaceAddonCat")) {
                        ArrayList newValues = new ArrayList();
                        addon.addMixin("mix:mpkaceAddonCat");
                        addon.setProperty("mix:mpkaceAddonCatName", defaultMixinList.toArray(new Value[defaultMixinList.size()]));
                        addon.save();
                    }
                    session.save();
                }
                if (sessionProvider == null) break block9;
            }
            catch (Exception e) {
                block10: {
                    try {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)"An unexpected error occurs when migrating scripts", (Throwable)e);
                        }
                        if (sessionProvider == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (sessionProvider != null) {
                            sessionProvider.close();
                        }
                        Instant endExec = Instant.now();
                        Duration upgradeElapsed = Duration.between(startExec, endExec);
                        LOG.info("Addons upgrade has been finished in {} ( milliseconds )", new Object[]{upgradeElapsed.toMillis()});
                        throw throwable;
                    }
                    sessionProvider.close();
                }
                Instant endExec = Instant.now();
                Duration upgradeElapsed = Duration.between(startExec, endExec);
                LOG.info("Addons upgrade has been finished in {} ( milliseconds )", new Object[]{upgradeElapsed.toMillis()});
            }
            sessionProvider.close();
        }
        Instant endExec = Instant.now();
        Duration upgradeElapsed = Duration.between(startExec, endExec);
        LOG.info("Addons upgrade has been finished in {} ( milliseconds )", new Object[]{upgradeElapsed.toMillis()});
    }

    public void stop() {
    }
}

