/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.marketplace.service.impl;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.exoplatform.addon.marketplace.bo.Category;
import org.exoplatform.addon.marketplace.dao.CategoryDAO;
import org.exoplatform.addon.marketplace.exception.MarketPlaceException;
import org.exoplatform.addon.marketplace.service.MarketPlaceService;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Singleton
public class MarketPlaceServiceImpl
implements MarketPlaceService {
    private static final Log LOG = ExoLogger.getExoLogger(MarketPlaceServiceImpl.class);
    @Inject
    CategoryDAO categoryDAO;

    public MarketPlaceServiceImpl() {
    }

    public MarketPlaceServiceImpl(CategoryDAO daoDAO) {
        this.categoryDAO = daoDAO;
    }

    @Override
    @ExoTransactional
    public Category createCategory(Category category) {
        Category categ = (Category)this.categoryDAO.create(category);
        return categ;
    }

    @Override
    @ExoTransactional
    public Category createCategory(Category category, long parentId) throws MarketPlaceException {
        Category parentCategory = (Category)this.categoryDAO.find(Long.valueOf(parentId));
        if (parentCategory != null) {
            category.setParent(parentCategory);
            category = this.createCategory(category);
            return category;
        }
        LOG.info((Object)("Can not find category for parent with ID: " + parentId));
        throw new MarketPlaceException(parentId, Category.class);
    }

    @Override
    @ExoTransactional
    public Category updateCategory(Category category) {
        Category categ = (Category)this.categoryDAO.update(category);
        return categ;
    }

    @Override
    @ExoTransactional
    public void removeCategory(long id, boolean deleteChild) throws MarketPlaceException {
        Category project = this.getCategory(id);
        if (project == null) {
            throw new MarketPlaceException(id, Category.class);
        }
        this.categoryDAO.removeCategory(id, deleteChild);
    }

    @Override
    public Category getCategory(Long id) throws MarketPlaceException {
        return (Category)this.categoryDAO.find(id);
    }

    @Override
    public ListAccess<Category> getSubCategory(long parentId) {
        try {
            Category parent = this.getCategory(parentId);
            return this.categoryDAO.findSubCategory(parent);
        }
        catch (MarketPlaceException ex) {
            return new ListAccess<Category>(){

                public int getSize() throws Exception {
                    return 0;
                }

                public Category[] load(int arg0, int arg1) throws Exception, IllegalArgumentException {
                    return new Category[0];
                }
            };
        }
    }

    @Override
    public ListAccess<Category> findCategories(String query) {
        return this.categoryDAO.findCategories(query);
    }

    @Override
    public long count() {
        return this.categoryDAO.count();
    }

    @Override
    public List<Category> findAllCategories() {
        return this.categoryDAO.findAll();
    }

    @Override
    public Category findCategoryByName(String categoryName) throws MarketPlaceException {
        return this.categoryDAO.findCategoryByName(categoryName);
    }
}

