/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.portlet.addon;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.addon.service.AddOnService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.wcm.webui.validator.MandatoryValidator;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormRichtextInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.input.UIUploadInput;
import org.exoplatform.webui.form.validator.EmailAddressValidator;

public class UIAddOnWizard
extends UIFormInputSet {
    private static final Log log = ExoLogger.getLogger(UIAddOnWizard.class);
    public static String ADDON_TITLE = "title";
    public static String ADDON_DESCRIPTION = "description";
    public static String ADDON_EMAIL = "email";
    public static String ADDON_VERSION = "version";
    public static String ADDON_LICENSE = "license";
    public static String ADDON_AUTHOR = "author";
    public static String ADDON_COMPABILITY = "compatibility";
    public static String ADDON_SOURCE_URL = "sourceUrl";
    public static String ADDON_DOCUMENT_URL = "documentUrl";
    public static String ADDON_DOWNLOAD_URL = "downloadUrl";
    public static String ADDON_HOSTED = "hosted";
    public static String ADDON_IMG_0 = "img0";

    public UIAddOnWizard(String id) throws Exception {
        this.setId(id);
        this.setComponentConfig(this.getClass(), null);
        this.reset();
        String email = "";
        String userId = Util.getPortalRequestContext().getRemoteUser();
        String displayName = "";
        if (userId != null) {
            OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            User user = orgService.getUserHandler().findUserByName(userId);
            if (user != null) {
                email = user.getEmail();
                displayName = user.getFirstName() + " " + user.getLastName();
            }
        } else {
            userId = "";
        }
        UIFormStringInput titleInput = (UIFormStringInput)new UIFormStringInput(ADDON_TITLE, null, "").addValidator(MandatoryValidator.class, new Object[0]);
        UIFormStringInput emailInput = (UIFormStringInput)new UIFormStringInput(ADDON_EMAIL, null, email).addValidator(MandatoryValidator.class, new Object[0]).addValidator(EmailAddressValidator.class, new Object[0]);
        if (email == null || email.equals("")) {
            emailInput.setHTMLAttribute("placeholder", "for internal use only");
        }
        UIFormRichtextInput descriptionRichTextInput = (UIFormRichtextInput)new UIFormRichtextInput(ADDON_DESCRIPTION, null, "").addValidator(MandatoryValidator.class, new Object[0]);
        descriptionRichTextInput.setHTMLAttribute("placeholder", "will be used on the add-on page");
        UIFormStringInput versionInput = new UIFormStringInput(ADDON_VERSION, null, "");
        versionInput.setHTMLAttribute("placeholder", "1.0");
        UIFormStringInput licenseInput = new UIFormStringInput(ADDON_LICENSE, null, null);
        UIFormStringInput authorInput = new UIFormStringInput(ADDON_AUTHOR, null, displayName);
        if (displayName == null || displayName.equals("")) {
            authorInput.setHTMLAttribute("placeholder", "published with the add-on");
        }
        UIFormStringInput compatibilityInput = new UIFormStringInput(ADDON_COMPABILITY, null, "");
        compatibilityInput.setHTMLAttribute("placeholder", "version of platform");
        UIFormStringInput sourceUrlInput = new UIFormStringInput(ADDON_SOURCE_URL, null, null);
        UIFormStringInput documentUrlInput = new UIFormStringInput(ADDON_DOCUMENT_URL, null, null);
        UIFormStringInput downloadUrlInput = (UIFormStringInput)new UIFormStringInput(ADDON_DOWNLOAD_URL, null, "").addValidator(MandatoryValidator.class, new Object[0]);
        downloadUrlInput.setHTMLAttribute("placeholder", "http://");
        UICheckBoxInput hostedCbInput = new UICheckBoxInput(ADDON_HOSTED, null, Boolean.valueOf(false));
        UIUploadInput imgUploadInput = new UIUploadInput(ADDON_IMG_0, "img0");
        this.addChild((UIComponent)titleInput);
        this.addChild((UIComponent)descriptionRichTextInput);
        this.addChild((UIComponent)versionInput);
        this.addChild((UIComponent)licenseInput);
        this.addChild((UIComponent)compatibilityInput);
        this.addChild((UIComponent)sourceUrlInput);
        this.addChild((UIComponent)documentUrlInput);
        this.addChild((UIComponent)downloadUrlInput);
        this.addChild((UIComponent)authorInput);
        this.addChild((UIComponent)emailInput);
        this.addChild((UIComponent)hostedCbInput);
        this.addChild((UIComponent)imgUploadInput);
    }

    public void initVals(Node aNode) {
        if (null != aNode) {
            String propertyName = null;
            String txt = null;
            String[] properties = new String[]{ADDON_TITLE, ADDON_DESCRIPTION, ADDON_DOWNLOAD_URL, ADDON_DOCUMENT_URL, ADDON_SOURCE_URL, ADDON_COMPABILITY, ADDON_LICENSE, ADDON_VERSION, ADDON_AUTHOR, ADDON_EMAIL};
            for (int i = 0; i < properties.length; ++i) {
                propertyName = properties[i];
                try {
                    txt = AddOnService.getStrProperty((Node)aNode, (String)("exo:" + propertyName));
                    if (null == txt) continue;
                    if (ADDON_DESCRIPTION.equals(propertyName)) {
                        ((UIFormRichtextInput)this.getChildById(propertyName)).setValue((Object)txt);
                        continue;
                    }
                    this.getUIStringInput(propertyName).setValue((Object)txt);
                    continue;
                }
                catch (RepositoryException e) {
                    log.error((Object)("ERR init vals for edit addon " + propertyName));
                }
            }
        }
    }
}

