/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.portlet.addon.search;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.exoplatform.addon.service.AddOnService;
import org.exoplatform.community.portlet.addon.UIAddOnWizard;
import org.exoplatform.community.portlet.addon.search.UIAddOnSearchEdit;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.input.UIUploadInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/AddOnSearchPortlet/UIAddOnSearchEdit.gtmpl", events={@EventConfig(listeners={UpdateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddUIUploadActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveUIUploadActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveImageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddOnSearchEdit
extends UIForm
implements UIPopupComponent {
    private static final Log log = ExoLogger.getLogger(UIAddOnSearchEdit.class);
    public static final String WIZARD_FORM_ID = "wizardFormId";
    private int imgCount = 1;
    private String nodeId;
    private List<String> imageGallery = new ArrayList();
    private List<String> imagesRemoved = new ArrayList();

    public UIAddOnSearchEdit() throws Exception {
        UIAddOnWizard uiAddOnWizard = new UIAddOnWizard(WIZARD_FORM_ID);
        this.addChild((UIComponent)uiAddOnWizard);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
        context.getJavascriptManager().getRequireJS().require("SHARED/addons", "addons").addScripts("addons.init();");
    }

    public void reset() {
        super.reset();
        this.imgCount = 1;
        this.setImageGallery(new ArrayList());
        this.setImagesRemoved(new ArrayList());
        try {
            this.getImagesNode();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() throws PathNotFoundException, RepositoryException {
        UIAddOnWizard uiAddOnWizard = (UIAddOnWizard)this.getChildById(WIZARD_FORM_ID);
        uiAddOnWizard.initVals(this.getNode());
    }

    public String getStrProperty(String propertyName) throws RepositoryException {
        return AddOnService.getStrProperty((Node)this.getNode(), (String)propertyName);
    }

    public String getInputValue(String compName) throws RepositoryException {
        if (this.getNode() == null) {
            return null;
        }
        String[] properties = new String[]{UIAddOnWizard.ADDON_TITLE, UIAddOnWizard.ADDON_DESCRIPTION, UIAddOnWizard.ADDON_DOWNLOAD_URL, UIAddOnWizard.ADDON_DOCUMENT_URL, UIAddOnWizard.ADDON_SOURCE_URL, UIAddOnWizard.ADDON_COMPABILITY, UIAddOnWizard.ADDON_LICENSE, UIAddOnWizard.ADDON_VERSION};
        for (int i = 0; i < properties.length; ++i) {
            if (!compName.equals(properties[i])) continue;
            return this.getStrProperty("exo:" + compName);
        }
        return null;
    }

    public Boolean isHosted() throws RepositoryException {
        if (this.getNode() != null && this.getNode().hasProperty("exo:hosted")) {
            return this.getNode().getProperty("exo:hosted").getValue().getBoolean();
        }
        return null;
    }

    public void setNodeId(String id) {
        this.nodeId = id;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setImageGallery(List<String> imgGal) {
        this.imageGallery = imgGal;
    }

    public List<String> getImageGallery() {
        return this.imageGallery;
    }

    public void setImagesRemoved(List<String> images) {
        this.imagesRemoved = images;
    }

    public List<String> getImagesRemoved() {
        return this.imagesRemoved;
    }

    public Node getNode() throws PathNotFoundException, RepositoryException {
        return AddOnService.getNodeById((String)this.getNodeId());
    }

    public void getImagesNode() throws Exception, RepositoryException {
        this.setImageGallery(AddOnService.getImagesNode((Node)this.getNode()));
    }

    public void removeImageNode() throws PathNotFoundException, RepositoryException {
        if (0 == this.getImagesRemoved().size()) {
            return;
        }
        if (this.getNode() != null) {
            Node mediaNode = this.getNode().getNode("medias/images");
            NodeIterator nodeIterator = mediaNode.getNodes();
            while (nodeIterator.hasNext()) {
                Node img = nodeIterator.nextNode();
                String src = AddOnService.imgPathBase + img.getPath();
                for (int i = 0; i < this.getImagesRemoved().size(); ++i) {
                    if (!src.equals(this.getImagesRemoved().get(i))) continue;
                    log.debug((Object)(" ===== remove image " + img.getPath()));
                    img.remove();
                }
            }
        }
    }

    public boolean addImageNode(UIUploadInput child, Event<UIAddOnSearchEdit> event) throws FileNotFoundException, ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        InputStream[] inputStreams = null;
        UploadResource[] uploadResource = child.getUploadResources();
        inputStreams = child.getUploadDataAsStreams();
        if (uploadResource.length > 0) {
            String imgFileName = uploadResource[0].getFileName();
            imgFileName = imgFileName.replaceAll("[^a-zA-Z0-9.-]", "-");
            String imgMineType = uploadResource[0].getMimeType();
            if (!imgMineType.substring(0, imgMineType.lastIndexOf("/")).equals("image")) {
                UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
                UIAddOnSearchEdit uiAddOnSearchEdit = (UIAddOnSearchEdit)event.getSource();
                uiApp.addMessage(new ApplicationMessage("UIAddOnSearchPortlet.msg.invalidImage", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiAddOnSearchEdit);
                return false;
            }
            Node imageNode = this.getNode().addNode("medias/images/" + imgFileName, "nt:file");
            Node imageContent = imageNode.addNode("jcr:content", "nt:resource");
            imageContent.setProperty("jcr:data", inputStreams[0]);
            imageContent.setProperty("jcr:mimeType", imgMineType);
            imageContent.setProperty("jcr:lastModified", Calendar.getInstance());
        }
        return true;
    }

    public void activate() {
        try {
            this.init();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void deActivate() {
    }

    static /* synthetic */ int access$010(UIAddOnSearchEdit x0) {
        return x0.imgCount--;
    }

    static /* synthetic */ int access$000(UIAddOnSearchEdit x0) {
        return x0.imgCount;
    }

    static /* synthetic */ int access$008(UIAddOnSearchEdit x0) {
        return x0.imgCount++;
    }

    static /* synthetic */ Log access$100() {
        return log;
    }
}

