/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.portlet.addon.search;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.addon.service.AddOnService;
import org.exoplatform.community.portlet.addon.search.UIAddOnSearchOne;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/AddOnSearchPortlet/UIAddOnSearchOne.gtmpl", events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DetailActionListener.class})})
public class UIAddOnSearchOne
extends UIContainer {
    private String nodeId;

    public void setNodeId(String id) {
        this.nodeId = id;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Node getNode() throws PathNotFoundException, RepositoryException {
        return AddOnService.getNodeById((String)this.getNodeId());
    }

    public String getImageCover() throws PathNotFoundException, RepositoryException {
        return AddOnService.getImageCover((Node)this.getNode());
    }

    public String getStrProperty(String propertyName) throws RepositoryException {
        return AddOnService.getStrProperty((Node)this.getNode(), (String)propertyName);
    }

    public Boolean canEdit() throws RepositoryException {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        String ownerid = this.getStrProperty("exo:owner");
        if (userId != null && ownerid != null && userId.equals(ownerid)) {
            return true;
        }
        return false;
    }

    public String getURL() throws Exception {
        Node node = this.getNode();
        String repository = WCMCoreUtils.getRepository().getConfiguration().getName();
        String workspace = node.getSession().getWorkspace().getName();
        String basePath = "addon-detail";
        String detailParameterName = "content-id";
        StringBuffer path = new StringBuffer();
        path.append("/").append(repository).append("/").append(workspace);
        NodeURL nodeURL = (NodeURL)Util.getPortalRequestContext().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), basePath);
        nodeURL.setResource(resource);
        if (node.isNodeType("nt:frozenNode")) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            Node originalNode = node.getSession().getNodeByUUID(uuid);
            path.append(originalNode.getPath());
            nodeURL.setQueryParameterValue("version", node.getParent().getName());
        } else {
            path.append(node.getPath());
        }
        nodeURL.setQueryParameterValue(detailParameterName, path.toString());
        nodeURL.setSchemeUse(true);
        FriendlyService friendlyService = (FriendlyService)this.getApplicationComponent(FriendlyService.class);
        String link = friendlyService.getFriendlyUri(nodeURL.toString());
        return link;
    }
}

