/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.portlet.addon.search;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.addon.service.AddOnService;
import org.exoplatform.community.portlet.addon.search.UIAddOnSearchOne;
import org.exoplatform.community.portlet.addon.search.UIAddOnSearchResult;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/AddOnSearchPortlet/UIAddOnSearchResult.gtmpl", events={@EventConfig(listeners={ShowMoreActionListener.class})})
public class UIAddOnSearchResult
extends UIContainer {
    private static final Log log = ExoLogger.getLogger(UIAddOnSearchResult.class);
    private ArrayList<Node> data = new ArrayList();
    public static final Integer ITEMS_PER_PAGE = 9;
    public static Boolean REFRESH = true;
    private int showMoreCount = 0;
    private String sqlOrder;
    private int queryStart = 0;
    private String sqlCondition;
    private int totaItem = 0;
    private String keyword = "";

    public void processRender(WebuiRequestContext context) throws Exception {
        if (REFRESH.booleanValue()) {
            this.init();
        }
        super.processRender(context);
    }

    public void setSQLOrder(String order) {
        this.sqlOrder = order;
    }

    public String getSQLOrder() {
        return this.sqlOrder;
    }

    public void setSQLCondition(String cond) {
        this.sqlCondition = cond;
    }

    public String getSQLCondition() {
        return this.sqlCondition;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword = keyword.trim();
        String cond = " AND ( (exo:title LIKE '%" + keyword + "%') OR ( exo:description LIKE '%" + keyword + "%' )  OR (exo:author LIKE '%" + keyword + "%') ) ";
        if (keyword != null && !"".equals(keyword)) {
            cond = " AND ( contains(exo:title,'" + keyword + "') OR (exo:title LIKE '%" + keyword + "%') OR (exo:name LIKE '%" + keyword + "%') OR  contains( exo:description,'" + keyword + "' ) OR (exo:description LIKE '%" + keyword + "%') OR contains(exo:author,'" + keyword + "') OR (exo:author LIKE '%" + keyword + "%')  ) ";
        }
        this.setSQLCondition(cond);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setQueryStart(int st) {
        this.queryStart = st;
    }

    public int getQueryStart() {
        return this.queryStart;
    }

    public void setShowMoreCount(int count) {
        this.showMoreCount = count;
    }

    public int getShowMoreCount() {
        return this.showMoreCount;
    }

    public void setTotalItem(int total) {
        this.totaItem = total;
    }

    public int getTotalItem() {
        return this.totaItem;
    }

    public void init() throws Exception {
        this.clearResult();
        this.setKeyword("");
        this.searchDBAddonByKey();
        this.getTotalDBResources();
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        portletRequestContext.addUIComponentToUpdateByAjax((UIComponent)this);
    }

    public void clearResult() throws RepositoryException {
        this.resetChild();
        this.setData(new ArrayList());
        this.setShowMoreCount(0);
        this.setQueryStart(0);
        this.setSQLOrder(" ORDER BY exo:title ASC ");
    }

    private void resetChild() throws RepositoryException {
        if (this.getData().size() > 0) {
            for (Node aNode : this.getData()) {
                this.removeChild(UIAddOnSearchOne.class);
            }
        }
    }

    public void setData(ArrayList<Node> data) {
        this.data = data;
    }

    public ArrayList<Node> getData() {
        return this.data;
    }

    public void doSearch() throws Exception {
        this.searchDBAddonByKey();
        this.getTotalDBResources();
    }

    public void showMyAddons() {
        REFRESH = false;
        try {
            this.clearResult();
            String sqlCond = this.getSQLCondition();
            String userID = Util.getPortalRequestContext().getRemoteUser();
            sqlCond = sqlCond + " AND exo:owner = '" + userID + "' ";
            this.setSQLCondition(sqlCond);
            this.doSearch();
        }
        catch (RepositoryException e) {
            log.error((Object)"ERR show my addons");
        }
        catch (Exception e) {
            log.error((Object)"ERR show my addons");
        }
    }

    public void SortAddons(String sort) {
        REFRESH = false;
        this.setSQLCondition("");
        try {
            this.clearResult();
            if (sort.equals("za")) {
                this.setSQLOrder(" ORDER BY exo:title DESC ");
            } else {
                this.setSQLOrder(" ORDER BY exo:title ASC ");
            }
            this.doSearch();
        }
        catch (RepositoryException e) {
            log.error((Object)"ERR show my addons");
        }
        catch (Exception e) {
            log.error((Object)"ERR show my addons");
        }
    }

    public void searchDBAddonByKey() throws Exception {
        String sqlQuery = "";
        String sqlStatement = " SELECT * FROM exo:addon WHERE publication:currentState='published' AND  NOT (jcr:mixinTypes = 'exo:restoreLocation') AND jcr:path like '%" + AddOnService.getAddOnHomePath() + "%' ";
        sqlQuery = sqlStatement + this.getSQLCondition() + this.getSQLOrder();
        this.getDBResource(sqlQuery);
    }

    private QueryResult excSQL(String sqlQuery, Boolean limit) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        Session session = sessionProvider.getSession(WCMCoreUtils.getRepository().getConfiguration().getDefaultWorkspaceName(), WCMCoreUtils.getRepository());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)queryManager.createQuery(sqlQuery, "sql");
        if (limit.booleanValue()) {
            if (this.getQueryStart() != 0) {
                query.setOffset((long)this.getQueryStart());
                log.debug((Object)(" ================ start " + this.getQueryStart() + " ========================== "));
            }
            query.setLimit((long)ITEMS_PER_PAGE.intValue());
        }
        QueryResult result = query.execute();
        return result;
    }

    private void getDBResource(String sqlQuery) throws Exception {
        QueryResult result = this.excSQL(sqlQuery, Boolean.valueOf(true));
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            Node findedNode = it.nextNode();
            this.data.add(findedNode);
        }
        this.display();
    }

    private void display() throws RepositoryException, Exception {
        for (Node aNode : this.getData()) {
            if (super.getChildById(aNode.getUUID()) != null) continue;
            UIAddOnSearchOne uiAddOnSearchOne = (UIAddOnSearchOne)this.addChild(UIAddOnSearchOne.class, null, aNode.getUUID());
            uiAddOnSearchOne.setNodeId(aNode.getUUID());
        }
    }

    public void getTotalDBResources() throws Exception {
        String sqlQuery = "SELECT exo:name FROM exo:addon WHERE  publication:currentState='published' AND NOT (jcr:mixinTypes = 'exo:restoreLocation') AND jcr:path like '%" + AddOnService.getAddOnHomePath() + "%' ";
        sqlQuery = sqlQuery + this.getSQLCondition();
        QueryResult result = this.excSQL(sqlQuery, Boolean.valueOf(false));
        int count = (int)result.getRows().getSize();
        log.debug((Object)(" ================ total item " + count + " ========================== "));
        this.setTotalItem(count);
    }

    public Boolean isShowMore() {
        if (this.getTotalItem() > this.getData().size()) {
            return true;
        }
        return false;
    }
}

