/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.marketplace;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import juzu.Response;
import juzu.impl.common.JSON;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.Log;

public abstract class GenericController {
    ResourceBundle bundle;

    public Response getBundle(Locale locale) {
        try {
            if (this.bundle == null || this.bundle.getLocale() != null && !this.bundle.getLocale().equals(locale)) {
                this.bundle = this.getResourceBundle(locale);
            }
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            return Response.ok((CharSequence)data.toString()).withHeader("Cache-Control", new String[]{"max-age=864000"});
        }
        catch (Throwable e) {
            this.getLogger().error((Object)"error while getting categories", e);
            return Response.status((int)500);
        }
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.categoryManagement", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    protected ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }

    public abstract Log getLogger();
}

