/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.marketplace.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.plugin.jackson.Jackson;
import juzu.request.SecurityContext;
import org.exoplatform.addon.marketplace.GenericController;
import org.exoplatform.addon.marketplace.bo.Category;
import org.exoplatform.addon.marketplace.exception.MarketPlaceException;
import org.exoplatform.addon.marketplace.service.MarketPlaceService;
import org.exoplatform.addon.marketplace.templates.master;
import org.exoplatform.addon.marketplace.templates.messageDialog;
import org.exoplatform.addon.service.AddOnService;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@SessionScoped
public class CategoryManagement
extends GenericController {
    private static final Log LOG = ExoLogger.getExoLogger(CategoryManagement.class);
    @Inject
    MarketPlaceService marketPlaceService;
    @Inject
    @Path(value="master.gtmpl")
    master master;
    @Inject
    @Path(value="messageDialog.gtmpl")
    messageDialog messageDialog;

    @View
    public Response index(SecurityContext securityContext) throws MarketPlaceException {
        return this.master.ok().withCharset(Tools.UTF_8);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public Category saveCategory(@Jackson Category category) throws Exception {
        Category createdCat = null;
        String oldCategoryName = null;
        try {
            Category cat = this.marketPlaceService.getCategory(Long.valueOf(category.getId()));
            if (cat != null) {
                LOG.info("Update the category {}", new Object[]{category.getName()});
                oldCategoryName = cat.getName();
                cat.setName(category.getName());
                cat.setDescription(category.getDescription());
                createdCat = this.marketPlaceService.updateCategory(cat);
                AddOnService.updateAddonsCategoriesInBulk((String)oldCategoryName, (String)category.getName(), (String)"update");
            } else {
                LOG.info("Save a new category {}", new Object[]{category.getName()});
                createdCat = new Category(category.getName(), category.getDescription());
                createdCat = this.marketPlaceService.createCategory(createdCat);
            }
        }
        catch (Exception e) {
            LOG.error("Exception raised when persisting category {}", new Object[]{category.getName(), e});
        }
        return createdCat;
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void deleteCategory(@Jackson Category category) throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Delete the category with [name = " + category.getName() + "]"));
        }
        try {
            this.marketPlaceService.removeCategory(category.getId(), false);
            AddOnService.updateAddonsCategoriesInBulk((String)category.getName(), null, (String)"drop");
        }
        catch (Exception ex) {
            LOG.error((Object)("Exception raised when storing category [" + category.getName() + "]"), (Throwable)ex);
        }
    }

    public Log getLogger() {
        return LOG;
    }

    @Resource
    @Ajax
    @MimeType.JSON
    @Jackson
    public List<Category> getCategories() throws Exception {
        ArrayList<Category> categories = new ArrayList<Category>();
        categories.addAll(this.marketPlaceService.findAllCategories());
        return categories;
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }
}

