/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.listeners;

import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.model.MatrixUserPermission;
import io.meeds.chat.service.MatrixService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MatrixSpaceListener
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(MatrixSpaceListener.class);
    @Autowired
    private MatrixService matrixService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    OrganizationService organizationService;

    @PostConstruct
    public void init() {
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)this);
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        try {
            String teamDisplayName = space.getDisplayName();
            String description = space.getDescription() != null ? space.getDescription() : "";
            String matrixRoomId = this.matrixService.createRoom(teamDisplayName, description);
            if (StringUtils.isNotBlank((CharSequence)matrixRoomId)) {
                this.matrixService.createMatrixRoom(space, matrixRoomId);
                ArrayList<String> members = new ArrayList<String>(Arrays.asList(space.getMembers()));
                for (String manager : space.getManagers()) {
                    String matrixIdOfUser = this.matrixService.getMatrixIdForUser(manager);
                    if (!StringUtils.isNotBlank((CharSequence)matrixRoomId) || !StringUtils.isNotBlank((CharSequence)matrixIdOfUser)) continue;
                    this.matrixService.joinUserToRoom(matrixRoomId, matrixIdOfUser);
                    this.updateMemberRoleInSpace(space, matrixIdOfUser, "50");
                    members.remove(manager);
                }
                for (String member : members) {
                    String matrixIdOfUser = this.matrixService.getMatrixIdForUser(member);
                    if (!StringUtils.isNotBlank((CharSequence)matrixRoomId) || !StringUtils.isNotBlank((CharSequence)matrixIdOfUser)) continue;
                    this.matrixService.joinUserToRoom(matrixRoomId, matrixIdOfUser);
                }
                MatrixRoomPermissions matrixRoomPermissions = this.matrixService.getRoomSettings(matrixRoomId);
                matrixRoomPermissions.setInvite("100");
                this.matrixService.updateRoomSettings(matrixRoomId, matrixRoomPermissions);
            }
        }
        catch (Exception e) {
            LOG.error("Matrix integration: Could not create a room for space {}", new Object[]{space.getDisplayName(), e});
        }
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String spaceDisplayName = space.getDisplayName();
        String roomId = this.matrixService.getRoomBySpace(space);
        if (StringUtils.isNotBlank((CharSequence)roomId)) {
            this.matrixService.renameRoom(roomId, spaceDisplayName);
        }
    }

    public void joined(SpaceLifeCycleEvent event) {
        String roomId;
        Space space = event.getSpace();
        String userId = event.getTarget();
        String restrictedGroupOfUsers = PropertyManager.getProperty((String)"meeds.matrix.restricted.users.groupId");
        String matrixIdOfUser = this.matrixService.getMatrixIdForUser(userId);
        if (StringUtils.isBlank((CharSequence)matrixIdOfUser) && StringUtils.isNotBlank((CharSequence)restrictedGroupOfUsers) && restrictedGroupOfUsers.equals(space.getGroupId())) {
            try {
                User user = this.organizationService.getUserHandler().findUserByName(userId);
                matrixIdOfUser = this.matrixService.saveUserAccount(user, true, false);
            }
            catch (Exception e) {
                LOG.error("Could not retrieve the user {}", new Object[]{userId, e});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(roomId = this.matrixService.getRoomBySpace(space))) && StringUtils.isNotBlank((CharSequence)matrixIdOfUser)) {
            this.matrixService.joinUserToRoom(roomId, matrixIdOfUser);
        }
    }

    public void left(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String userId = event.getTarget();
        String roomId = this.matrixService.getRoomBySpace(space);
        String matrixIdOfUser = this.matrixService.getMatrixIdForUser(userId);
        if (StringUtils.isNotBlank((CharSequence)roomId) && StringUtils.isNotBlank((CharSequence)matrixIdOfUser)) {
            this.matrixService.kickUserFromRoom(roomId, matrixIdOfUser, "The user is no more member of the space %s, thus he was kicked out of this room!".formatted(space.getDisplayName()));
        }
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String matrixIdOfUser = this.matrixService.getMatrixIdForUser(event.getTarget());
        this.updateMemberRoleInSpace(space, matrixIdOfUser, "50");
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String matrixIdOfUser = this.matrixService.getMatrixIdForUser(event.getTarget());
        this.updateMemberRoleInSpace(space, matrixIdOfUser, "0");
    }

    private boolean updateMemberRoleInSpace(Space space, String matrixIdOfUser, String userRole) {
        String roomId = null;
        roomId = this.matrixService.getRoomBySpace(space);
        if (StringUtils.isNotBlank((CharSequence)roomId)) {
            MatrixRoomPermissions matrixRoomPermissions = this.matrixService.getRoomSettings(roomId);
            if (matrixRoomPermissions != null) {
                if ("0".equals(userRole)) {
                    for (MatrixUserPermission userPermission : matrixRoomPermissions.getUsers()) {
                        String fullMatrixUserId = "@%s:%s".formatted(matrixIdOfUser, PropertyManager.getProperty((String)"meeds.matrix.server.name"));
                        if (!fullMatrixUserId.equals(userPermission.getUserName())) continue;
                        userPermission.setUserRole(userRole);
                    }
                } else {
                    MatrixUserPermission matrixUserPermission = new MatrixUserPermission("@%s:%s".formatted(matrixIdOfUser, PropertyManager.getProperty((String)"meeds.matrix.server.name")), userRole);
                    matrixRoomPermissions.getUsers().add(matrixUserPermission);
                }
            }
            return this.matrixService.updateRoomSettings(roomId, matrixRoomPermissions);
        }
        return false;
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String mimeType = "image/jpg";
        String roomId = this.matrixService.getRoomBySpace(space);
        if (StringUtils.isNotBlank((CharSequence)roomId) && space.getAvatarAttachment() != null && space.getAvatarAttachment().getImageBytes() != null) {
            byte[] imageBytes = space.getAvatarAttachment().getImageBytes();
            if (!"application/octet-stream".equals(space.getAvatarAttachment().getMimeType())) {
                mimeType = space.getAvatarAttachment().getMimeType();
            }
            String avatarURL = this.matrixService.uploadFileOnMatrix(space.getAvatarAttachment().getFileName(), mimeType, imageBytes);
            this.matrixService.updateRoomAvatar(roomId, avatarURL);
        }
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String roomId = this.matrixService.getRoomBySpace(space);
        if (StringUtils.isNotBlank((CharSequence)roomId)) {
            this.matrixService.updateRoomDescription(roomId, space.getDescription());
        }
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String roomId = this.matrixService.getRoomBySpace(space);
        if (StringUtils.isNotBlank((CharSequence)roomId)) {
            this.matrixService.deleteRoom(roomId);
        }
    }
}

