/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.listeners;

import io.meeds.chat.service.MatrixService;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IdentityListener
extends ProfileListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(MatrixService.class);
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private MatrixService matrixService;

    @PostConstruct
    public void init() {
        this.identityManager.registerProfileListener((ProfileListenerPlugin)this);
    }

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        Profile profile = event.getProfile();
        String userMatrixId = (String)profile.getProperty("matrixId");
        try {
            this.matrixService.updateUserAvatar(profile, userMatrixId);
        }
        catch (IOException | InterruptedException | JsonException e) {
            LOG.error("Could not update the avatar of the user {} on Matrix", new Object[]{profile.getFullName(), e});
        }
    }
}

