/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.rest;

import io.meeds.chat.model.DirectMessagingRoom;
import io.meeds.chat.service.MatrixService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/matrix"})
@Tag(name="/matrix", description="Manages Matrix integration")
public class MatrixRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)MatrixRest.class.toString());
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private MatrixService matrixService;
    @Autowired
    private IdentityManager identityManager;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Get the matrix room bound to the current space", method="GET", description="Get the id of the matrix room bound to the current space")
    @ApiResponses(value={@ApiResponse(responseCode="2rest00", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public String getMatrixRoomBySpaceId(@Parameter(description="The space Id") @RequestParam(name="spaceId") String spaceId) {
        if (StringUtils.isBlank((CharSequence)spaceId)) {
            LOG.error((Object)"Could not get the URL for the space, missing space ID");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "the space Id parameter is required!");
        }
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            LOG.error("Could not find a space with id {}", new Object[]{spaceId});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Can not find a space with Id = " + spaceId);
        }
        String userName = ConversationState.getCurrent().getIdentity().getUserId();
        if (!(this.spaceService.isMember(space, userName) || this.spaceService.isManager(space, userName) || this.spaceService.isSuperManager(userName))) {
            LOG.error("User is not allowed to get the team associated with the space {}", new Object[]{space.getDisplayName()});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, "User " + userName + " is not allowed to get information from space" + space.getPrettyName());
        }
        return this.matrixService.getRoomBySpace(space);
    }

    @GetMapping(value={"dmRoom"})
    @Secured(value={"users"})
    @Operation(summary="Get the matrix room used for direct messaging between provided users", method="GET", description="Get the matrix room used for direct messaging between provided users")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public DirectMessagingRoom getDirectMessagingRoom(@Parameter(description="The first participant") @RequestParam(name="firstParticipant") String firstParticipant, @Parameter(description="The second participant") @RequestParam(name="secondParticipant") String secondParticipant) {
        if (StringUtils.isBlank((CharSequence)firstParticipant) || StringUtils.isBlank((CharSequence)secondParticipant)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "the ids of the participants should not be null");
        }
        DirectMessagingRoom directMessagingRoom = this.matrixService.getDirectMessagingRoom(firstParticipant, secondParticipant);
        if (directMessagingRoom != null) {
            return directMessagingRoom;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Could not find a room for participants %s and %s".formatted(firstParticipant, secondParticipant));
    }

    @PostMapping
    @Secured(value={"users"})
    @Operation(summary="Gets or creates the Matrix room for the direct messaging", method="POST", description="Gets or creates the Matrix room for the direct messaging")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public DirectMessagingRoom getDirectMessagingRoom(@io.swagger.v3.oas.annotations.parameters.RequestBody(description="Matrix object to create", required=true) @RequestBody DirectMessagingRoom directMessagingRoom) {
        if (StringUtils.isBlank((CharSequence)directMessagingRoom.getFirstParticipant()) || StringUtils.isBlank((CharSequence)directMessagingRoom.getSecondParticipant())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "the ids of the participants should not be null");
        }
        try {
            return this.matrixService.createDirectMessagingRoom(directMessagingRoom);
        }
        catch (ObjectAlreadyExistsException objectAlreadyExists) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, objectAlreadyExists.getMessage());
        }
    }

    @GetMapping(value={"linkRoom"})
    @Secured(value={"users"})
    @Operation(summary="Set the matrix room bound to the current space", method="POST", description="Set the id of the matrix room bound to the current space")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public boolean linkSpaceToRoom(@RequestParam(value="spaceGroupId") String spaceGroupId, @RequestParam(name="roomId") String roomId, @RequestParam(name="create", required=false) Boolean create) {
        try {
            if (StringUtils.isBlank((CharSequence)spaceGroupId)) {
                LOG.error((Object)"Could not connect the space to a team, space name is missing");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "space group Id is required");
            }
            Space space = this.spaceService.getSpaceByGroupId("/spaces/" + spaceGroupId);
            if (space == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "space with group Id " + spaceGroupId + "was not found");
            }
            String existingRoomId = this.matrixService.getRoomBySpace(space);
            if (StringUtils.isNotBlank((CharSequence)existingRoomId)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "space with group Id " + spaceGroupId + "has already a room with ID " + existingRoomId);
            }
            if (StringUtils.isBlank((CharSequence)roomId) && create.booleanValue()) {
                roomId = this.matrixService.createMatrixRoomForSpace(space);
            }
            this.matrixService.createMatrixRoom(space, roomId);
            return true;
        }
        catch (Exception e) {
            LOG.error("Could not link space {} to Matrix room {}", new Object[]{spaceGroupId, roomId, e});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Could not link space " + spaceGroupId + " to Matrix room " + roomId + " : " + e.getMessage());
        }
    }

    @GetMapping(value={"dmRooms"})
    @Secured(value={"users"})
    @Operation(summary="Get all the matrix rooms used for direct messaging of a defined user", method="GET", description="Get all the matrix rooms used for direct messaging of a defined user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Map<String, String[]> getUserDirectMessagingRooms(@Parameter(description="The user") @RequestParam(name="user") String user) {
        HashMap<String, String[]> userDMRooms = new HashMap<String, String[]>();
        List<DirectMessagingRoom> rooms = this.matrixService.getMatrixDMRoomsOfUser(user);
        for (DirectMessagingRoom dmRoom : rooms) {
            Identity userIdentity = dmRoom.getFirstParticipant().equals(user) ? this.identityManager.getOrCreateUserIdentity(dmRoom.getSecondParticipant()) : this.identityManager.getOrCreateUserIdentity(dmRoom.getFirstParticipant());
            if (userIdentity == null) continue;
            String userMatrixId = "@" + String.valueOf(userIdentity.getProfile().getProperty("matrixId")) + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
            userDMRooms.put(userMatrixId, new String[]{dmRoom.getRoomId()});
        }
        return userDMRooms;
    }
}

