/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.upgrade;

import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.model.SpaceRoom;
import io.meeds.chat.service.MatrixService;
import java.util.List;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpdateRoomPermissionsUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(UpdateRoomPermissionsUpgradePlugin.class);
    private MatrixService matrixService;

    public UpdateRoomPermissionsUpgradePlugin(InitParams initParams, MatrixService matrixService) {
        super(initParams);
        this.matrixService = matrixService;
    }

    public void processUpgrade(String s, String s1) {
        LOG.info((Object)"Start:: update room permissions on Matrix");
        long startupTime = System.currentTimeMillis();
        List<SpaceRoom> spaceRooms = this.matrixService.getSpaceRooms();
        int updatedRoomsCount = 0;
        for (SpaceRoom spaceRoom : spaceRooms) {
            try {
                MatrixRoomPermissions matrixRoomPermissions = this.matrixService.getRoomSettings(spaceRoom.getRoomId());
                if ("100".equals(matrixRoomPermissions.getInvite())) continue;
                matrixRoomPermissions.setInvite("100");
                this.matrixService.updateRoomSettings(spaceRoom.getRoomId(), matrixRoomPermissions);
                ++updatedRoomsCount;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while updating room permissions", e);
            }
        }
        LOG.info("Summary :: updated successfully the  permissions of {} rooms on Matrix of a total of {} existing rooms !", new Object[]{updatedRoomsCount, spaceRooms.size()});
        LOG.info("End:: update room permissions on Matrix took {}", new Object[]{System.currentTimeMillis() - startupTime});
    }
}

