/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.rest;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import io.meeds.chat.model.DirectMessagingRoom;
import io.meeds.chat.model.Room;
import io.meeds.chat.rest.model.Presence;
import io.meeds.chat.rest.model.RoomList;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.service.utils.MatrixConstants;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/matrix"})
@Tag(name="/matrix", description="Manages Matrix integration")
public class MatrixRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)MatrixRest.class.toString());
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private MatrixService matrixService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private NotificationService notificationService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Get the matrix room bound to the current space", method="GET", description="Get the id of the matrix room bound to the current space")
    @ApiResponses(value={@ApiResponse(responseCode="2rest00", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public String getMatrixRoomBySpaceId(@Parameter(description="The space Id") @RequestParam(name="spaceId") String spaceId) {
        if (StringUtils.isBlank((CharSequence)spaceId)) {
            LOG.error((Object)"Could not get the URL for the space, missing space ID");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "the space Id parameter is required!");
        }
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            LOG.error("Could not find a space with id {}", new Object[]{spaceId});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Can not find a space with Id = " + spaceId);
        }
        String userName = ConversationState.getCurrent().getIdentity().getUserId();
        if (!(this.spaceService.isMember(space, userName) || this.spaceService.isManager(space, userName) || this.spaceService.isSuperManager(userName))) {
            LOG.error("User is not allowed to get the team associated with the space {}", new Object[]{space.getDisplayName()});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, "User " + userName + " is not allowed to get information from space" + space.getPrettyName());
        }
        return this.matrixService.getRoomBySpace(space);
    }

    @GetMapping(value={"dmRoom"})
    @Secured(value={"users"})
    @Operation(summary="Get the matrix room used for direct messaging between provided users", method="GET", description="Get the matrix room used for direct messaging between provided users")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public DirectMessagingRoom getDirectMessagingRoom(@Parameter(description="The first participant") @RequestParam(name="firstParticipant") String firstParticipant, @Parameter(description="The second participant") @RequestParam(name="secondParticipant") String secondParticipant) {
        if (StringUtils.isBlank((CharSequence)firstParticipant) || StringUtils.isBlank((CharSequence)secondParticipant)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "the ids of the participants should not be null");
        }
        DirectMessagingRoom directMessagingRoom = this.matrixService.getDirectMessagingRoom(firstParticipant, secondParticipant);
        if (directMessagingRoom != null) {
            return directMessagingRoom;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Could not find a room for participants %s and %s".formatted(firstParticipant, secondParticipant));
    }

    @PostMapping
    @Secured(value={"users"})
    @Operation(summary="Gets or creates the Matrix room for the direct messaging", method="POST", description="Gets or creates the Matrix room for the direct messaging")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public DirectMessagingRoom getDirectMessagingRoom(@RequestBody(description="Matrix object to create", required=true) @org.springframework.web.bind.annotation.RequestBody DirectMessagingRoom directMessagingRoom) {
        if (StringUtils.isBlank((CharSequence)directMessagingRoom.getFirstParticipant()) || StringUtils.isBlank((CharSequence)directMessagingRoom.getSecondParticipant())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "the ids of the participants should not be null");
        }
        try {
            return this.matrixService.createDirectMessagingRoom(directMessagingRoom);
        }
        catch (ObjectAlreadyExistsException objectAlreadyExists) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, objectAlreadyExists.getMessage());
        }
    }

    @PostMapping(value={"notify"})
    @Operation(summary="Receives push notification from Matrix", method="POST", description="Receives push notification from Matrix")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public String notify(@RequestBody(description="Notification received from Matrix", required=true) @org.springframework.web.bind.annotation.RequestBody String notification) {
        JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
        try {
            String userName;
            JsonValue jsonValue = jsonGenerator.createJsonObjectFromString(notification);
            JsonValue notifJsonValue = jsonValue.getElement("notification");
            int unreadCount = notifJsonValue.getElement("counts").getElement("unread").getIntValue();
            String roomId = notifJsonValue.getElement("room_id").getStringValue();
            String eventId = notifJsonValue.getElement("event_id").getStringValue();
            String pushKey = "";
            if (notifJsonValue.getElement("devices").getElements().hasNext()) {
                JsonValue device = (JsonValue)notifJsonValue.getElement("devices").getElements().next();
                pushKey = device.getElement("pushkey").getStringValue();
            }
            if (StringUtils.isNotBlank((CharSequence)pushKey) && StringUtils.isNotBlank((CharSequence)(userName = this.parseUserFromToken(pushKey)))) {
                this.sendPushNotification(userName, roomId, unreadCount);
            }
            return "{\n  \"rejected\": []\n}\n";
        }
        catch (Exception e) {
            LOG.error((Object)"Problem parsing notification received from Matrix", (Throwable)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"linkRoom"})
    @Secured(value={"users"})
    @Operation(summary="Set the matrix room bound to the current space", method="POST", description="Set the id of the matrix room bound to the current space")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public boolean linkSpaceToRoom(@RequestParam(value="spaceGroupId") String spaceGroupId, @RequestParam(name="roomId") String roomId, @RequestParam(name="create", required=false) Boolean create) {
        try {
            if (StringUtils.isBlank((CharSequence)spaceGroupId)) {
                LOG.error((Object)"Could not connect the space to a team, space name is missing");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "space group Id is required");
            }
            Space space = this.spaceService.getSpaceByGroupId("/spaces/" + spaceGroupId);
            if (space == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "space with group Id " + spaceGroupId + "was not found");
            }
            String existingRoomId = this.matrixService.getRoomBySpace(space);
            if (StringUtils.isNotBlank((CharSequence)existingRoomId)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "space with group Id " + spaceGroupId + "has already a room with ID " + existingRoomId);
            }
            if (StringUtils.isBlank((CharSequence)roomId) && create.booleanValue()) {
                roomId = this.matrixService.createRoomForSpaceOnMatrix(space);
            }
            this.matrixService.linkSpaceToMatrixRoom(space, roomId);
            return true;
        }
        catch (Exception e) {
            LOG.error("Could not link space {} to Matrix room {}", new Object[]{spaceGroupId, roomId, e});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Could not link space " + spaceGroupId + " to Matrix room " + roomId + " : " + e.getMessage());
        }
    }

    @GetMapping(value={"dmRooms"})
    @Secured(value={"users"})
    @Operation(summary="Get all the matrix rooms used for direct messaging of a defined user", method="GET", description="Get all the matrix rooms used for direct messaging of a defined user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Map<String, String[]> getUserDirectMessagingRooms(@Parameter(description="The user") @RequestParam(name="user") String user) {
        HashMap<String, String[]> userDMRooms = new HashMap<String, String[]>();
        List<DirectMessagingRoom> rooms = this.matrixService.getMatrixDMRoomsOfUser(user);
        for (DirectMessagingRoom dmRoom : rooms) {
            org.exoplatform.social.core.identity.model.Identity userIdentity = dmRoom.getFirstParticipant().equals(user) ? this.identityManager.getOrCreateUserIdentity(dmRoom.getSecondParticipant()) : this.identityManager.getOrCreateUserIdentity(dmRoom.getFirstParticipant());
            if (userIdentity == null) continue;
            String userMatrixId = "@" + String.valueOf(userIdentity.getProfile().getProperty("matrixId")) + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
            userDMRooms.put(userMatrixId, new String[]{dmRoom.getRoomId()});
        }
        return userDMRooms;
    }

    @GetMapping(value={"byRoom"})
    @Secured(value={"users"})
    @Operation(summary="Get the space linked to the specified matrix room", method="GET", description="Get the space linked to the specified matrix room")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Space not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public String getByRoomId(@Parameter(description="The room Id") @RequestParam(name="roomId") String roomId) {
        Room room;
        if (StringUtils.isNotBlank((CharSequence)roomId) && roomId.contains(PropertyManager.getProperty((String)"meeds.matrix.server.name"))) {
            roomId = roomId.substring(0, roomId.indexOf(":"));
        }
        if ((room = this.matrixService.getById(roomId)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (StringUtils.isNotBlank((CharSequence)room.getSpaceId())) {
            Space space = this.spaceService.getSpaceById(room.getSpaceId());
            return this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId();
        }
        Identity connecteduserIdentity = ConversationState.getCurrent().getIdentity();
        if (room.getFirstParticipant().equals(connecteduserIdentity.getUserId())) {
            return this.identityManager.getOrCreateUserIdentity(room.getSecondParticipant()).getId();
        }
        return this.identityManager.getOrCreateUserIdentity(room.getFirstParticipant()).getId();
    }

    @GetMapping(value={"userByMatrixId"})
    @Secured(value={"users"})
    @Operation(summary="Get the user Identity for the provided matrix user Id", method="GET", description="Get the user Identity for the provided matrix user Id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<IdentityEntity> getIdentityByUserMatrixId(HttpServletRequest request, WebRequest webRequest, @Parameter(description="The user Id on Matrix") @RequestParam(name="userMatrixId") String userMatrixId) {
        String requestURI = request.getRequestURI();
        org.exoplatform.social.core.identity.model.Identity foundIdentity = this.matrixService.findUserByMatrixId(userMatrixId);
        if (foundIdentity == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (webRequest.checkNotModified(String.valueOf(foundIdentity.getCacheTime()), foundIdentity.getCacheTime())) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(String.valueOf(foundIdentity.getCacheTime()))).body((Object)this.buildIdentityEntity(foundIdentity, requestURI, "settings"));
    }

    @PostMapping(value={"processRooms"})
    @Secured(value={"users"})
    @Operation(summary="Process the list of rooms and add needed information", method="POST", description="Process the list of rooms and add needed information")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<RoomList> processRooms(HttpServletRequest request, @RequestBody(description="Rooms received from Matrix", required=true) @org.springframework.web.bind.annotation.RequestBody RoomList rooms) {
        String userName = request.getRemoteUser();
        rooms = this.matrixService.processRooms(rooms, userName);
        return ResponseEntity.ok().body((Object)rooms);
    }

    @PutMapping(value={"setStatus"})
    @Secured(value={"users"})
    @Operation(summary="Set the presence status of the user", method="PUT", description="Set the presence status of the user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<String> updatePresenceStatus(@RequestBody(description="Rooms received from Matrix", required=true) @org.springframework.web.bind.annotation.RequestBody Presence presence) {
        String presenceStatus = this.matrixService.updateUserPresence(presence.getUserIdOnMatrix(), presence.getPresence(), presence.getStatusMessage());
        return ResponseEntity.ok().body((Object)presenceStatus);
    }

    private void sendPushNotification(String participant, String roomId, int unreadCount) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(MatrixConstants.MATRIX_ROOM_ID, (Object)roomId);
        ctx.append(MatrixConstants.MATRIX_ROOM_MEMBER, (Object)participant);
        ctx.append(MatrixConstants.MATRIX_ROOM_UNREAD_COUNT, (Object)unreadCount);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"MatrixMessageReceivedNotificationPlugin"))).execute(ctx);
    }

    private String parseUserFromToken(String token) {
        byte[] secret = PropertyManager.getProperty((String)"meeds.matrix.jwt.secret").getBytes();
        Jws jws = Jwts.parserBuilder().setSigningKey((Key)Keys.hmacShaKeyFor((byte[])secret)).build().parseClaimsJws(token);
        return String.valueOf(((Claims)jws.getBody()).getSubject());
    }

    private IdentityEntity buildIdentityEntity(org.exoplatform.social.core.identity.model.Identity identity, String restPath, String expand) {
        IdentityEntity identityEntity = new IdentityEntity(identity.getId());
        identityEntity.setHref(RestUtils.getRestUrl((String)"identities", (String)identity.getId(), (String)restPath));
        identityEntity.setProviderId(identity.getProviderId());
        identityEntity.setGlobalId(identity.getGlobalId());
        identityEntity.setRemoteId(identity.getRemoteId());
        identityEntity.setDeleted(Boolean.valueOf(identity.isDeleted()));
        identityEntity.setProfile(EntityBuilder.buildEntityProfile((Profile)identity.getProfile(), (String)restPath, (String)expand));
        return identityEntity;
    }
}

