/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.mattermost.services;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;

@Path(value="/mattermost")
@Tag(name="/mattermost", description="Managing connection between eXo and Mattermost")
public class SpaceTeamRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(SpaceTeamRest.class);
    private SpaceService spaceService;
    private MetadataService metadataService;

    public SpaceTeamRest(SpaceService spaceService, MetadataService metadataService) {
        this.spaceService = spaceService;
        this.metadataService = metadataService;
    }

    @GET
    @Path(value="/teamUrl")
    @RolesAllowed(value={"users"})
    public Response getMattermostTeamUrl(@Context HttpServletRequest request, @QueryParam(value="spaceId") String spaceId) {
        if (StringUtils.isBlank((CharSequence)spaceId)) {
            LOG.error((Object)"Could not get the URL for the space, missing space ID");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            LOG.error("Could not find a space with id {}", new Object[]{spaceId});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String userName = request.getRemoteUser();
        if (!(this.spaceService.isMember(space, userName) || this.spaceService.isManager(space, userName) || this.spaceService.isSuperManager(userName))) {
            LOG.error("User is not allowed to get the team associated with the space {}", new Object[]{space.getDisplayName()});
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Object matterMostUrl = PropertyManager.getProperty((String)"exo.addon.mattermost.url");
        MetadataKey metadataKey = new MetadataKey("matterMostSpaceIntegration", "MattermostTeamMetadata", 0L);
        MetadataObject metadataObject = new MetadataObject("Space", space.getId(), null, Long.parseLong(space.getId()));
        List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject(metadataKey.getType(), metadataObject);
        if (metadataItems.size() > 1) {
            LOG.error("There are more than one items for type {} and space {}", new Object[]{metadataKey.getType(), spaceId});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        if (!metadataItems.isEmpty()) {
            MetadataItem metadataItem = (MetadataItem)metadataItems.get(0);
            if (metadataItem != null) {
                matterMostUrl = ((String)matterMostUrl).lastIndexOf("/") == ((String)matterMostUrl).length() - 1 ? matterMostUrl : (String)matterMostUrl + "/";
                matterMostUrl = (String)matterMostUrl + (String)metadataItem.getProperties().get("MattermostTeamName");
                return Response.ok((Object)matterMostUrl).build();
            }
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/linkSpaceToTeam")
    @RolesAllowed(value={"administrators"})
    public Response linkSpaceToTeam(@QueryParam(value="spaceName") String spaceName, @QueryParam(value="teamName") String teamName, @QueryParam(value="teamId") String teamId) {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            if (StringUtils.isBlank((CharSequence)spaceName)) {
                LOG.error((Object)"Could not connect the space to a team, space name is missing");
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                return response;
            }
            MetadataKey metadataKey = new MetadataKey("matterMostSpaceIntegration", "MattermostTeamMetadata", 0L);
            Space space = this.spaceService.getSpaceByGroupId("/spaces/" + spaceName);
            MetadataObject metadataObject = new MetadataObject("Space", space.getId(), null, Long.parseLong(space.getId()));
            List items = this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, metadataObject);
            if (!items.isEmpty()) {
                this.metadataService.deleteMetadataItemsByMetadataTypeAndObject(metadataKey.getType(), metadataObject);
            }
            if (!StringUtils.isBlank((CharSequence)teamId) && !StringUtils.isBlank((CharSequence)teamName)) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("MattermostTeamID", teamId);
                properties.put("MattermostTeamName", teamName);
                this.metadataService.createMetadataItem(metadataObject, metadataKey, properties);
            }
            Response response = Response.ok((Object)"Space %s was linked to team with ID %s successfully ".formatted(space.getDisplayName(), teamId)).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Could not link space {} to Mattermost team {}", new Object[]{spaceName, teamId});
            Response response = Response.serverError().entity((Object)e.getMessage()).build();
            return response;
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

