/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.fido.services.api;

import java.util.HashMap;
import java.util.Locale;
import org.exoplatform.addons.fido.services.api.FidoConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.mfa.api.MfaSystemService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.json.JSONObject;

public class FidoService
implements MfaSystemService {
    private HashMap<String, FidoConnector> fidoConnectors = new HashMap();
    private String activeConnector;
    public static String TYPE = "Fido2";
    private static final Log LOG = ExoLogger.getLogger(FidoService.class);
    private ResourceBundleService resourceBundleService;

    public FidoService(InitParams initParams, ResourceBundleService resourceBundleService) {
        ValueParam activeConnectorParam = initParams.getValueParam("activeConnector");
        if (activeConnectorParam != null) {
            this.activeConnector = activeConnectorParam.getValue();
        }
        this.resourceBundleService = resourceBundleService;
    }

    public void addConnector(FidoConnector fidoConnector) {
        this.fidoConnectors.put(fidoConnector.getName(), fidoConnector);
    }

    public JSONObject startRegistration(String userId, String rpHostName) {
        if (this.getActiveConnector() != null) {
            return this.getActiveConnector().startRegistration(userId, rpHostName);
        }
        LOG.warn((Object)"No Fido active connector registred");
        return null;
    }

    public JSONObject finishRegistration(String userId, JSONObject data) {
        if (this.getActiveConnector() != null) {
            return this.getActiveConnector().finishRegistration(userId, data);
        }
        LOG.warn((Object)"No Fido active connector registred");
        return null;
    }

    public JSONObject startAuthentication(String userId, String rpHostName) {
        if (this.getActiveConnector() != null) {
            return this.getActiveConnector().startAuthentication(userId, rpHostName);
        }
        LOG.warn((Object)"No Fido active connector registred");
        return null;
    }

    public JSONObject finishAuthentication(String userId, JSONObject data) {
        if (this.getActiveConnector() != null) {
            return this.getActiveConnector().finishAuthentication(userId, data);
        }
        LOG.warn((Object)"No Fido active connector registred");
        return null;
    }

    private FidoConnector getActiveConnector() {
        return this.fidoConnectors.get(this.activeConnector);
    }

    public String getType() {
        return TYPE;
    }

    public String getHelpTitle(Locale locale) {
        return this.resourceBundleService.getResourceBundle("locale.mfafido.mfafido", locale).getString("mfa.fido.help.title");
    }

    public String getHelpContent(Locale locale) {
        return this.resourceBundleService.getResourceBundle("locale.mfafido.mfafido", locale).getString("mfa.fido.help.content");
    }
}

