Introduction
============

This addon add the MFA option FIDO


Installation
============

The following command must be executed from the root folder of the eXoPlatfom instance to install it:

    ./addon install mfa-fido


Configuration
=============

To activate this mfa option, you need to add theses properties in exo.properties :

    exo.mfa.system=fido
    //The url of the fido server
    exo.mfa.fido.serverUrl=https://www.demoexample.org/

FIDO Server Configuration
=========================

The default Fido Connector use a Gluu Server to implement Fido functionnality : https://gluu.org/

After installing Gluu server, you need to activate FIDO2 by following documentation https://gluu.org/docs/gluu-server/4.2/authn-guide/fido2/#fido2-devices

With fido2, you have to buy a hardware (Neowave, Yubikey ...). Then, when you use your key, the request and response are 
signed with a certificate. Some constructors register their public certificate on Metadata Service (MDS) like FIDO Alliance 
MDS. Some other (like Neowave) don't and so, you have to provide the certificate to the Gluu server.

## Server Metadata Configuration ##
When the key constructor is not registred on a MDS, we need to add his metadata in gluu (in fact, we need to provide certificate chain which allow to validate the attestation/assertion certificates.

### File format ###
For that, we need to create a json file. The name is not important, I used neowave.json, as the key constructor is neowave. We can have one file by constructor, or one json file for each constructor. The format must be :

    {"aaguid":"3789da91f94346bc95c350ea2012f03a","attestationRootCertificates":["MIIEODCCA92gAwIBAgIDAInBMAoGCCqGSM49BAMCMHsxCzAJBgNVBAYTAkZSMRMwEQYDVQQKEwpDZXJ0RXVyb3BlMRcwFQYDVQQLEw4wMDAyIDQzNDIwMjE4MDEkMCIGA1UEAxMbQ2VydEV1cm9wZSBFbGxpcHRpYyBSb290IENBMRgwFgYDVQRhEw9OVFJGUi00MzQyMDIxODAwHhcNMTgwMjIyMjMwMDAwWhcNMjgwMTIxMjMwMDAwWjB0MQswCQYDVQQGEwJGUjETMBEGA1UEChMKQ2VydEV1cm9wZTEXMBUGA1UECxMOMDAwMiA0MzQyMDIxODAxHTAbBgNVBAMTFENlcnRFdXJvcGUgSWRlY3lzIENBMRgwFgYDVQRhEw9OVFJGUi00MzQyMDIxODAwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAASLVL+1STJvaERO5WCR+jGcAxLvmPBDiZY1NgFFIhpX6OAZApQYmt6xSh74SwM+mjgnsSEcc4A2Uf139FgZ4rpYo4ICVTCCAlEwEwYDVR0jBAwwCoAITZ01tGuBPLowSgYIKwYBBQUHAQEEPjA8MDoGCCsGAQUFBzAChi5odHRwOi8vd3d3LmNlcnRldXJvcGUuZnIvcmVmZXJlbmNlL2VjX3Jvb3QuY3J0MFMGA1UdIARMMEowSAYJKoF6AWkpAQEAMDswOQYIKwYBBQUHAgEWLWh0dHBzOi8vd3d3LmNlcnRldXJvcGUuZnIvY2hhaW5lLWRlLWNvbmZpYW5jZTCCAWAGA1UdHwSCAVcwggFTMD+gPaA7hjlodHRwOi8vd3d3LmNlcnRldXJvcGUuZnIvcmVmZXJlbmNlL2NlcnRldXJvcGVfZWNfcm9vdC5jcmwwgYaggYOggYCGfmxkYXA6Ly9sY3IxLmNlcnRldXJvcGUuZnIvY249Q2VydEV1cm9wZSUyMEVsbGlwdGljJTIwUm9vdCUyMENBLG91PTAwMDIlMjA0MzQyMDIxODAsbz1DZXJ0RXVyb3BlLGM9RlI/Y2VydGlmaWNhdGVSZXZvY2F0aW9uTGlzdDCBhqCBg6CBgIZ+bGRhcDovL2xjcjIuY2VydGV1cm9wZS5mci9jbj1DZXJ0RXVyb3BlJTIwRWxsaXB0aWMlMjBSb290JTIwQ0Esb3U9MDAwMiUyMDQzNDIwMjE4MCxvPUNlcnRFdXJvcGUsYz1GUj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0MBEGA1UdDgQKBAhDaQbhTFtjcjAOBgNVHQ8BAf8EBAMCAQYwEgYDVR0TAQH/BAgwBgEB/wIBADAKBggqhkjOPQQDAgNJADBGAiEAoEepHMC5X9jBKaGphcKjidhiN+Znz7v3S3hc31/AunsCIQDKqogK2SZOXZcvvHCB6UQSaA0nLn4RUwy1guDivbZbwg==","MIIFmDCCA4CgAwIBAgICJxIwDQYJKoZIhvcNAQELBQAwczELMAkGA1UEBhMCRlIxEzARBgNVBAoTCkNlcnRFdXJvcGUxFzAVBgNVBAsTDjAwMDIgNDM0MjAyMTgwMRwwGgYDVQQDExNDZXJ0RXVyb3BlIGVJRCBSb290MRgwFgYDVQRhEw9TSTpGUi00MzQyMDIxODAwHhcNMTYxMTEzMjMwMDAwWhcNMzYxMTEzMjMwMDAwWjBzMQswCQYDVQQGEwJGUjETMBEGA1UEChMKQ2VydEV1cm9wZTEXMBUGA1UECxMOMDAwMiA0MzQyMDIxODAxHDAaBgNVBAMTE0NlcnRFdXJvcGUgZUlEIFJvb3QxGDAWBgNVBGETD1NJOkZSLTQzNDIwMjE4MDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAK59lsyGwbR1TZ7aIzZbaQWFpbTubRyjtFf2y3Fb9g3250nTwBNK0FnkKrgTjiPVyxXnyspjzuhnul31jP/8b4NNLecajf4QkRR5RjZxVixWGcv8JgDRE8bWMjR46DBUA5HeTOWcyg+573BBCjWuHoXn6ib6j4SlWRbrfqLhMs9ymZ1JMsdpx9ndD99P0Zycy5waVoKXpN99dyNnuUB0LzLaED7Gg03GTw0f4nR7rP22+4PLa1NuRa1z5wbwq/43xUPyYglJOU1QoLVMNeDX2WgIWm/wIAVBkKlje1CChMd20QkS3JxzyoWraYhid6Y9YQslkH29HroE93bH1pI9WnjtM3FHQ9rqrS1UwJx5sggAC6ZnVPD6Rp5gbclO074qrhg9ME8JVvmtVbCbs/nhs/QCm4JspV8rlnLFESq3Hc0Qx8RcFJjUYfrKJBrIcM+Y+YXvkglplt6Cq24qDT9SNl9dtir4L9H7fj/IuE2690eEeWpYTtb2wnRKgATOUtUjoatCSOlX06Esye8MYiaw/LmM3u7/sKkG/mpjMWiADncEOVUS5q7oWkjGFfS0vuJJLzcFPR91ozrnVe89/kmDFarPeTwMtGWorV1YqPBhlDVAI1yElEW9C6PfxutprjQFEoyFaWj9Lqv0Uz6WVw1GE4i0DwPGMHrKrAhr8mxBWQ9nAgMBAAGjNjA0MA8GA1UdEwEB/wQFMAMBAf8wEQYDVR0OBAoECELBYoPmyn48MA4GA1UdDwEB/wQEAwIBBjANBgkqhkiG9w0BAQsFAAOCAgEAi6kimM5JELKnNn702oJRkNU1zXwdyHnwpvEwVHXlij2v/oMUtOh4J0uai7uTHuEM+FrdnkuTM8v2DHeSeIwTan8aktDTTw/3SBTy36crMIaC7u42C4pfNuIpuodOfYaGhQi9/wRcfxmWlGWFzUtAx6jqytyJdn2cTnNI+85BidqdWPMcvSJxVGrehuz0krjnYityaWEHWQn2rY0NPM1zwi0018ZC0RGmea1WQyastslmKZ/z2e8qkRG4wivKV8UCSuFpQdj2P8OqoU3UDBnKwDnQdDOTAGJyBf2JjPAJ08XDZ8P5eSEql4fNsy5haL2ipD3rlusCY1mhzIkXtCPUZ1AnG9+tp+1BWmH/5TJd7Jo6bn0JGAMa26sV/5z358esvXRPckUXXtctLlZciBgBjq5j2Vugyl/3QLKw6AJhtQey+3AVD+wflu0fxOssr88aqvlQpzw3dvEkIYQXlp/tEQ8bLqE08eEB+noJwFwcsjoIajdcPUF2TgGz+/kBiSnmnvwraeg8de/V+neVEDqE80x5bmsLkLTm0ruKhwV50hQYSvNWrY7TRucbKie/2D3dAESInsAHdVuogFUjKrojqY9Bqtk+VYi6sqFHNAIilCz5PoeXNyAa+CsM78kbZUAxIi+b5vz6NLVT7dZvWcdDAUAlpw7zBEMcOkePyc20Utg="]}

* aaguid : is the unique identifier of the key constructor : each key of this constructor have the same aaguid. 
 "3789da91f94346bc95c350ea2012f03a" is the value for neowave keys
* attestationRootCertificates : is an array containing certificate string from the certificate chain provided by the key 
  constructor. If the certificate is povided as binary format (der), the certificate string can be extract with this command


    openssl x509 -inform der -in certificat.der -out certificate.cer

The output format is

    -----BEGIN CERTIFICATE-----
    MIIHBTCCBO2gAwIBAgIDAiapMA0GCSqGSIb3DQEBCwUAMFoxCzAJBgNVBAYTAkZS
    MRMwEQYDVQQKEwpDZXJ0ZXVyb3BlMRcwFQYDVQQLEw4wMDAyIDQzNDIwMjE4MDEd
    ...
    7Pj1oyahafda++dm7IDJ9jtDON0WHkG/mzmHo/a8wh3sbKMC1bTo27rxjPoCfOKT
    OCE40WFCNnyvnc7n/YJ74i1gBF1XmPnd8bgovAgpTM7vUVI6gd/sregppvfuwKh2
    QOG7SFUV8n27ZYolIkoYPKcDwZafhpoJuQ==
    -----END CERTIFICATE-----

This string must be put on one line, and we must remove "BEGIN CERTIFICATE" and "END CERTIFICATE" line to add it in our json file.

### Gluu configuration ###
The file neowave.json must be added in gluu installation.

As I install it with docker, I will explain how to add it in this context.

In Gluu home folder, create a folder named "server_metadata" and add neowave.json into.
In Gluu home folder, create a file docker-compose.override.yml, containing :

    version: "2.4"
    
    services:
    fido2:
    volumes:
         - ./server_metadata:/etc/gluu/conf/fido2/server_metadata

This will mount the folder {gluuHome}/server_metadata to the container folder /etc/gluu/conf/fido2/server_metadata

In Gluu home folder, create a file named setting.py if not exists and add this property :

    ENABLE_OVERRIDE = True

Restart gluu.

The certificate is now loaded and neowave assertion request/responses are validated.

Extension
=========

It is possible to create a new Fido implementation, using another Fido Server. For that, you must inspire from class 
GluuFidoConnector

