/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.fido.services.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.addons.fido.services.api.FidoService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.json.JSONObject;

@Path(value="/fido")
@Api(value="/fido", description="Manages FIDO features")
public class FidoRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(FidoRestService.class);

    @Path(value="/startRegistration")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Start FIDO2 Registration STEP 1", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response startRegistration(@Context UriInfo uriInfo) {
        String userId = null;
        try {
            FidoService fidoService = (FidoService)CommonsUtils.getService(FidoService.class);
            try {
                userId = ConversationState.getCurrent().getIdentity().getUserId();
            }
            catch (Exception e) {
                return Response.status((int)401).build();
            }
            String host = uriInfo.getRequestUri().getScheme() + "://" + uriInfo.getRequestUri().getHost();
            JSONObject result = fidoService.startRegistration(userId, host);
            if (result != null) {
                return Response.ok().entity((Object)result.toString()).build();
            }
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.warn("Error when starting FIDO Registration Step 1 user='{}'", new Object[]{userId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/finishRegistration")
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Start FIDO2 Registration STEP 2", httpMethod="POST", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response finishRegistration(@FormParam(value="data") String data, @Context UriInfo uriInfo, @Context HttpServletRequest request) {
        String userId = null;
        try {
            FidoService fidoService = (FidoService)CommonsUtils.getService(FidoService.class);
            try {
                userId = ConversationState.getCurrent().getIdentity().getUserId();
            }
            catch (Exception e) {
                return Response.status((int)401).build();
            }
            JSONObject result = fidoService.finishRegistration(userId, new JSONObject(data));
            LOG.info("Finish Registration, data={}", new Object[]{data});
            if (result != null) {
                request.getSession().setAttribute("mfaValidated", (Object)true);
                return Response.ok().entity((Object)"{\"ok\":\"true\"}").build();
            }
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.warn("Error when finishing FIDO Registration user='{}'", new Object[]{userId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/startAuthentication")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Start FIDO2 Authentication STEP 1", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response startAuthentication(@Context UriInfo uriInfo) {
        String userId = null;
        try {
            FidoService fidoService = (FidoService)CommonsUtils.getService(FidoService.class);
            try {
                userId = ConversationState.getCurrent().getIdentity().getUserId();
            }
            catch (Exception e) {
                return Response.status((int)401).build();
            }
            String host = uriInfo.getRequestUri().getScheme() + "://" + uriInfo.getRequestUri().getHost();
            JSONObject result = fidoService.startAuthentication(userId, host);
            if (result != null) {
                return Response.ok().entity((Object)result.toString()).build();
            }
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.warn("Error when starting FIDO Registration Step 1 user='{}'", new Object[]{userId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/finishAuthentication")
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Start FIDO2 Authentication STEP 2", httpMethod="POST", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response finishAuthentication(@FormParam(value="data") String data, @Context UriInfo uriInfo, @Context HttpServletRequest request) {
        String userId = null;
        try {
            FidoService fidoService = (FidoService)CommonsUtils.getService(FidoService.class);
            try {
                userId = ConversationState.getCurrent().getIdentity().getUserId();
            }
            catch (Exception e) {
                return Response.status((int)401).build();
            }
            JSONObject result = fidoService.finishAuthentication(userId, new JSONObject(data));
            LOG.info("Finish Authentication, data={}", new Object[]{data});
            if (result != null) {
                request.getSession().setAttribute("mfaValidated", (Object)true);
                return Response.ok().entity((Object)"{\"ok\":\"true\"}").build();
            }
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.warn("Error when finishing FIDO Authentication user='{}'", new Object[]{userId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

