/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.news.NewsService;
import org.exoplatform.news.connector.NewsSearchConnector;
import org.exoplatform.news.connector.NewsSearchResult;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.model.News;
import org.exoplatform.news.model.SharedNews;
import org.exoplatform.news.notification.plugin.PostNewsNotificationPlugin;
import org.exoplatform.news.queryBuilder.NewsQueryBuilder;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.social.ckeditor.HTMLUploadImageProcessor;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class NewsServiceImpl
implements NewsService {
    public static final String NEWS_NODES_FOLDER = "News";
    public static final String PINNED_NEWS_NODES_FOLDER = "Pinned";
    public static final String APPLICATION_DATA_PATH = "/Application Data";
    private static final String MANAGER_MEMBERSHIP_NAME = "manager";
    private static final String PUBLISHER_MEMBERSHIP_NAME = "publisher";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private DataDistributionType dataDistributionType;
    private SpaceService spaceService;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private UploadService uploadService;
    private LinkManager linkManager;
    private HTMLUploadImageProcessor imageProcessor;
    private PublicationService publicationService;
    private PublicationManager publicationManager;
    private WCMPublicationService wCMPublicationService;
    private NewsSearchConnector newsSearchConnector;
    private static final Log LOG = ExoLogger.getLogger(NewsServiceImpl.class);

    public NewsServiceImpl(RepositoryService repositoryService, SessionProviderService sessionProviderService, NodeHierarchyCreator nodeHierarchyCreator, DataDistributionManager dataDistributionManager, SpaceService spaceService, ActivityManager activityManager, IdentityManager identityManager, UploadService uploadService, HTMLUploadImageProcessor imageProcessor, LinkManager linkManager, PublicationService publicationService, PublicationManager publicationManager, WCMPublicationService wCMPublicationService, NewsSearchConnector newsSearchConnector) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.spaceService = spaceService;
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.uploadService = uploadService;
        this.imageProcessor = imageProcessor;
        this.linkManager = linkManager;
        this.dataDistributionType = dataDistributionManager.getDataDistributionType(DataDistributionMode.NONE);
        this.publicationService = publicationService;
        this.publicationManager = publicationManager;
        this.wCMPublicationService = wCMPublicationService;
        this.newsSearchConnector = newsSearchConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public News createNews(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        try {
            if (StringUtils.isEmpty((CharSequence)news.getId())) {
                news = this.createNewsDraft(news);
            } else {
                this.postNewsActivity(news);
                this.updateNews(news);
                this.sendNotification(news, "POST NEWS");
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        if (news.isPinned()) {
            this.pinNews(news.getId());
        }
        return news;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public News getNewsById(String id) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        try {
            Node node = session.getNodeByUUID(id);
            News news = this.convertNodeToNews(node);
            return news;
        }
        catch (ItemNotFoundException e) {
            News news = null;
            return news;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<News> getNews(NewsFilter filter) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        ArrayList<News> listNews = new ArrayList<News>();
        NewsQueryBuilder queyBuilder = new NewsQueryBuilder();
        try {
            StringBuilder sqlQuery = queyBuilder.buildQuery(filter);
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(sqlQuery.toString(), "sql");
            NodeIterator it = query.execute().getNodes();
            while (it.hasNext()) {
                Node iterNode = it.nextNode();
                listNews.add(this.convertNodeToNews(iterNode));
            }
            ArrayList<News> arrayList = listNews;
            return arrayList;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public News updateNews(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        try {
            Node newsNode = session.getNodeByUUID(news.getId());
            if (newsNode != null) {
                newsNode.setProperty("exo:title", news.getTitle());
                newsNode.setProperty("exo:summary", news.getSummary());
                String processedBody = this.imageProcessor.processImages(news.getBody(), newsNode, "images");
                news.setBody(processedBody);
                newsNode.setProperty("exo:body", processedBody);
                newsNode.setProperty("exo:dateModified", Calendar.getInstance());
                if (StringUtils.isNotEmpty((CharSequence)news.getUploadId())) {
                    this.attachIllustration(newsNode, news.getUploadId());
                } else if ("".equals(news.getUploadId())) {
                    this.removeIllustration(newsNode);
                }
                newsNode.save();
                if ("published".equals(news.getPublicationState())) {
                    this.publicationService.changeState(newsNode, "published", new HashMap());
                }
            }
            News news2 = news;
            return news2;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsRead(News news, String userId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        try {
            Node newsNode = session.getNodeByUUID(news.getId());
            if (newsNode == null) {
                throw new Exception("Unable to find a node with an UUID equal to: " + news.getId());
            }
            if (!newsNode.hasProperty("exo:viewers")) {
                newsNode.setProperty("exo:viewers", "");
            }
            String newsViewers = newsNode.getProperty("exo:viewers").getString();
            boolean isCurrentUserInNewsViewers = false;
            if (!newsViewers.isEmpty()) {
                String[] newsViewersArray = newsViewers.split(",");
                isCurrentUserInNewsViewers = Arrays.stream(newsViewersArray).anyMatch(userId::equals);
            }
            if (!isCurrentUserInNewsViewers) {
                if (news.getViewsCount() == null) {
                    news.setViewsCount(1L);
                } else {
                    news.setViewsCount(news.getViewsCount() + 1L);
                }
                newsViewers = newsViewers.isEmpty() ? newsViewers.concat(userId) : newsViewers.concat(",").concat(userId);
                newsNode.setProperty("exo:viewsCount", news.getViewsCount().longValue());
                newsNode.setProperty("exo:viewers", newsViewers);
                newsNode.save();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public void pinNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        News news = this.getNewsById(newsId);
        Node newsNode = session.getNodeByUUID(newsId);
        newsNode.setProperty("exo:pinned", true);
        newsNode.save();
        Node pinnedRootNode = this.getPinnedNewsFolder();
        Calendar newsCreationCalendar = Calendar.getInstance();
        newsCreationCalendar.setTime(news.getCreationDate());
        Node newsFolderNode = this.dataDistributionType.getOrCreateDataNode(pinnedRootNode, this.getNodeRelativePath(newsCreationCalendar));
        if (newsNode.canAddMixin("exo:privilegeable")) {
            newsNode.addMixin("exo:privilegeable");
        }
        ((ExtendedNode)newsNode).setPermission("*:/platform/users", new String[]{"read"});
        this.linkManager.createLink(newsFolderNode, "exo:symlink", newsNode, null);
    }

    @Override
    public void unpinNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        News news = this.getNewsById(newsId);
        if (news == null) {
            throw new Exception("Unable to find a news with an id equal to: " + newsId);
        }
        Node newsNode = session.getNodeByUUID(newsId);
        if (newsNode == null) {
            throw new Exception("Unable to find a node with an UUID equal to: " + newsId);
        }
        newsNode.setProperty("exo:pinned", false);
        ((ExtendedNode)newsNode).removePermission("*:/platform/users");
        newsNode.save();
        Node pinnedRootNode = this.getPinnedNewsFolder();
        if (pinnedRootNode == null) {
            throw new Exception("Unable to find the root pinned folder: /Application Data/News/pinned");
        }
        Calendar newsCreationCalendar = Calendar.getInstance();
        newsCreationCalendar.setTime(news.getCreationDate());
        Node newsFolderNode = this.dataDistributionType.getOrCreateDataNode(pinnedRootNode, this.getNodeRelativePath(newsCreationCalendar));
        if (newsFolderNode == null) {
            throw new Exception("Unable to find the parent node of the current pinned node");
        }
        Node pinnedNode = newsFolderNode.getNode(newsNode.getName());
        if (pinnedNode == null) {
            throw new Exception("Unable to find the current pinned node");
        }
        pinnedNode.remove();
        newsFolderNode.save();
    }

    private Node getPinnedNewsFolder() throws Exception {
        Node pinnedRootNode;
        Node newsRootNode;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node applicationDataNode = (Node)session.getItem(APPLICATION_DATA_PATH);
        if (!applicationDataNode.hasNode(NEWS_NODES_FOLDER)) {
            newsRootNode = applicationDataNode.addNode(NEWS_NODES_FOLDER, "nt:unstructured");
            applicationDataNode.save();
        } else {
            newsRootNode = applicationDataNode.getNode(NEWS_NODES_FOLDER);
        }
        if (!newsRootNode.hasNode(PINNED_NEWS_NODES_FOLDER)) {
            pinnedRootNode = newsRootNode.addNode(PINNED_NEWS_NODES_FOLDER, "nt:unstructured");
            newsRootNode.save();
        } else {
            pinnedRootNode = newsRootNode.getNode(PINNED_NEWS_NODES_FOLDER);
        }
        return pinnedRootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shareNews(SharedNews sharedNews, List<Space> spaces) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        try {
            org.exoplatform.social.core.identity.model.Identity poster = this.identityManager.getOrCreateIdentity("organization", sharedNews.getPoster(), false);
            for (Space space : spaces) {
                org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
                ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
                activity.setTitle(sharedNews.getDescription());
                activity.setBody("");
                activity.setType("shared_news");
                activity.setUserId(poster.getId());
                HashMap<String, String> templateParams = new HashMap<String, String>();
                templateParams.put("newsId", sharedNews.getNewsId());
                templateParams.put("sharedActivityId", sharedNews.getActivityId());
                activity.setTemplateParams(templateParams);
                this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
                Node newsNode = session.getNodeByUUID(sharedNews.getNewsId());
                if (newsNode == null) continue;
                if (newsNode.canAddMixin("exo:privilegeable")) {
                    newsNode.addMixin("exo:privilegeable");
                }
                ((ExtendedNode)newsNode).setPermission("*:" + space.getGroupId(), PermissionType.ALL);
                if (activity.getId() != null && newsNode.hasProperty("exo:activities")) {
                    String activities = newsNode.getProperty("exo:activities").getString();
                    activities = activities.concat(";").concat(space.getId()).concat(":").concat(activity.getId());
                    newsNode.setProperty("exo:activities", activities);
                }
                newsNode.save();
                News news = this.getNewsById(sharedNews.getNewsId());
                this.sendNotification(news, "SHARE NEWS");
                this.sendNotification(news, "SHARE MY NEWS");
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<News> getNewsDrafts(String spaceId, String author) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        ArrayList<News> newsDrafts = new ArrayList<News>();
        try {
            StringBuilder sqlQuery = new StringBuilder("SELECT * FROM exo:news WHERE publication:currentState = 'draft' AND exo:author = '").append(author).append("'").append("AND exo:spaceId='").append(spaceId).append("'");
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(sqlQuery.toString(), "sql");
            NodeIterator it = query.execute().getNodes();
            while (it.hasNext()) {
                Node iterNode = it.nextNode();
                newsDrafts.add(this.convertNodeToNews(iterNode));
            }
            ArrayList<News> arrayList = newsDrafts;
            return arrayList;
        }
        catch (ItemNotFoundException e) {
            List<News> list = null;
            return list;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        try {
            Node node = session.getNodeByUUID(newsId);
            node.remove();
            session.save();
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    void postNewsActivity(News news) throws Exception {
        org.exoplatform.social.core.identity.model.Identity poster = this.identityManager.getOrCreateIdentity("organization", news.getAuthor(), false);
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("");
        activity.setBody("");
        activity.setType("news");
        activity.setUserId(poster.getId());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("newsId", news.getId());
        activity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        this.updateNewsActivities((ExoSocialActivity)activity, news);
    }

    private String getNodeRelativePath(Calendar now) {
        return now.get(1) + "/" + (now.get(2) + 1) + "/" + now.get(5);
    }

    private void attachIllustration(Node newsNode, String uploadId) throws Exception {
        UploadResource uploadedResource = this.uploadService.getUploadResource(uploadId);
        if (uploadedResource == null) {
            throw new Exception("Cannot attach uploaded file " + uploadId + ", it may not exist");
        }
        boolean illustrationExists = newsNode.hasNode("illustration");
        Node illustrationNode = illustrationExists ? newsNode.getNode("illustration") : newsNode.addNode("illustration", "nt:file");
        illustrationNode.setProperty("exo:title", uploadedResource.getFileName());
        Node resourceNode = illustrationExists ? illustrationNode.getNode("jcr:content") : illustrationNode.addNode("jcr:content", "nt:resource");
        resourceNode.setProperty("jcr:mimeType", uploadedResource.getMimeType());
        Calendar now = Calendar.getInstance();
        resourceNode.setProperty("jcr:lastModified", now);
        resourceNode.setProperty("exo:dateModified", now);
        String fileDiskLocation = uploadedResource.getStoreLocation();
        try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
            resourceNode.setProperty("jcr:data", (InputStream)inputStream);
            newsNode.save();
        }
    }

    private void removeIllustration(Node newsNode) throws Exception {
        if (newsNode.hasNode("illustration")) {
            newsNode.getNode("illustration").remove();
            newsNode.save();
        }
    }

    private Node getSpaceNewsRootNode(String spaceId, Session session) throws RepositoryException {
        Node spaceNewsRootNode;
        Space space = this.spaceService.getSpaceById(spaceId);
        String groupPath = this.nodeHierarchyCreator.getJcrPath("groupsPath");
        String spaceParentPath = groupPath + space.getGroupId();
        Node spaceRootNode = (Node)session.getItem(spaceParentPath);
        if (!spaceRootNode.hasNode(NEWS_NODES_FOLDER)) {
            spaceNewsRootNode = spaceRootNode.addNode(NEWS_NODES_FOLDER, "nt:unstructured");
            if (spaceNewsRootNode.canAddMixin("exo:privilegeable")) {
                spaceNewsRootNode.addMixin("exo:privilegeable");
            }
            HashMap<String, String[]> permissions = new HashMap<String, String[]>();
            permissions.put("*:/platform/administrators", PermissionType.ALL);
            permissions.put("*:" + space.getGroupId(), PermissionType.ALL);
            ((ExtendedNode)spaceNewsRootNode).setPermissions(permissions);
            spaceRootNode.save();
        } else {
            spaceNewsRootNode = spaceRootNode.getNode(NEWS_NODES_FOLDER);
        }
        return spaceNewsRootNode;
    }

    private News convertNodeToNews(Node node) throws Exception {
        org.exoplatform.social.core.identity.model.Identity identity;
        Space space;
        if (node == null) {
            return null;
        }
        News news = new News();
        news.setId(node.getUUID());
        news.setTitle(this.getStringProperty(node, "exo:title"));
        news.setSummary(this.getStringProperty(node, "exo:summary"));
        news.setBody(this.getStringProperty(node, "exo:body"));
        news.setAuthor(this.getStringProperty(node, "exo:author"));
        news.setCreationDate(this.getDateProperty(node, "exo:dateCreated"));
        news.setUpdater(this.getStringProperty(node, "exo:lastModifier"));
        news.setUpdateDate(this.getDateProperty(node, "exo:dateModified"));
        news.setPublicationDate(this.getPublicationDate(node));
        if (node.hasProperty("publication:currentState")) {
            news.setPublicationState(node.getProperty("publication:currentState").getString());
        }
        news.setPinned(node.getProperty("exo:pinned").getBoolean());
        news.setSpaceId(node.getProperty("exo:spaceId").getString());
        if (node.hasProperty("exo:activities")) {
            news.setActivities(node.getProperty("exo:activities").getString());
        }
        news.setPath(this.getPath(node));
        if (!node.hasProperty("exo:viewsCount")) {
            news.setViewsCount(0L);
        } else {
            news.setViewsCount(node.getProperty("exo:viewsCount").getLong());
        }
        if (node.hasNode("illustration")) {
            Node illustrationContentNode = node.getNode("illustration").getNode("jcr:content");
            byte[] bytes = IOUtils.toByteArray((InputStream)illustrationContentNode.getProperty("jcr:data").getStream());
            news.setIllustration(bytes);
            news.setIllustrationUpdateDate(illustrationContentNode.getProperty("exo:dateModified").getDate().getTime());
            news.setIllustrationURL("/portal/rest/v1/news/" + news.getId() + "/illustration");
        }
        if ((space = this.spaceService.getSpaceById(news.getSpaceId())) != null) {
            String spaceName = space.getDisplayName();
            news.setSpaceDisplayName(spaceName);
            if (StringUtils.isNotEmpty((CharSequence)space.getGroupId())) {
                StringBuilder spaceUrl = new StringBuilder().append("/portal/g/:spaces:").append(space.getGroupId().split("/")[2]).append("/").append(space.getPrettyName());
                news.setSpaceUrl(spaceUrl.toString());
            }
        }
        if ((identity = this.identityManager.getOrCreateIdentity("organization", news.getAuthor(), true)) != null && identity.getProfile() != null) {
            news.setAuthorDisplayName(identity.getProfile().getFullName());
        }
        return news;
    }

    private String getStringProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return "";
    }

    private Date getDateProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getDate().getTime();
        }
        return null;
    }

    @Override
    public News createNewsDraft(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node spaceNewsRootNode = this.getSpaceNewsRootNode(news.getSpaceId(), session);
        Calendar creationCalendar = Calendar.getInstance();
        if (news.getCreationDate() != null) {
            creationCalendar.setTime(news.getCreationDate());
        } else {
            news.setCreationDate(creationCalendar.getTime());
        }
        String newsNodeName = !news.getTitle().equals("") ? news.getTitle() : "Untitled";
        Node newsFolderNode = this.dataDistributionType.getOrCreateDataNode(spaceNewsRootNode, this.getNodeRelativePath(creationCalendar));
        Node newsDraftNode = newsFolderNode.addNode(Utils.cleanName((String)newsNodeName).trim(), "exo:news");
        newsDraftNode.addMixin("exo:datetime");
        newsDraftNode.setProperty("exo:title", news.getTitle());
        newsDraftNode.setProperty("exo:summary", news.getSummary());
        newsDraftNode.setProperty("exo:body", news.getBody());
        newsDraftNode.setProperty("exo:author", news.getAuthor());
        newsDraftNode.setProperty("exo:dateCreated", creationCalendar);
        newsDraftNode.setProperty("exo:viewsCount", 0L);
        newsDraftNode.setProperty("exo:viewers", "");
        newsDraftNode.setProperty("exo:activities", "");
        Calendar updateCalendar = Calendar.getInstance();
        if (news.getUpdateDate() != null) {
            updateCalendar.setTime(news.getUpdateDate());
        } else {
            news.setUpdateDate(updateCalendar.getTime());
        }
        newsDraftNode.setProperty("exo:dateModified", updateCalendar);
        newsDraftNode.setProperty("exo:pinned", false);
        newsDraftNode.setProperty("exo:spaceId", news.getSpaceId());
        LifecyclesConfig.Lifecycle lifecycle = this.publicationManager.getLifecycle("newsLifecycle");
        String lifecycleName = ((WebpagePublicationPlugin)this.wCMPublicationService.getWebpagePublicationPlugins().get(lifecycle.getPublicationPlugin())).getLifecycleName();
        if (newsDraftNode.canAddMixin("publication:authoring")) {
            newsDraftNode.addMixin("publication:authoring");
            newsDraftNode.setProperty("publication:lastUser", news.getAuthor());
            newsDraftNode.setProperty("publication:lifecycle", lifecycle.getName());
        }
        this.publicationService.enrollNodeInLifecycle(newsDraftNode, lifecycleName);
        this.publicationService.changeState(newsDraftNode, "draft", new HashMap());
        newsDraftNode.setProperty("exo:body", this.imageProcessor.processImages(news.getBody(), newsDraftNode, "images"));
        spaceNewsRootNode.save();
        if (StringUtils.isNotEmpty((CharSequence)news.getUploadId())) {
            this.attachIllustration(newsDraftNode, news.getUploadId());
        }
        news.setId(newsDraftNode.getUUID());
        return news;
    }

    private Date getPublicationDate(Node node) throws RepositoryException {
        VersionNode versionNode = new VersionNode(node, node.getSession());
        List versions = versionNode.getChildren();
        if (!versions.isEmpty()) {
            versions.sort(Comparator.comparingInt(v -> Integer.parseInt(v.getName())));
            return ((VersionNode)versions.get(0)).getCreatedTime().getTime();
        }
        return null;
    }

    private String getPath(Node node) throws Exception {
        String nodePath = null;
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        if (nodeLocation != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("/").append(nodeLocation.getRepository()).append("/").append(nodeLocation.getWorkspace()).append(node.getPath());
            nodePath = Text.escapeIllegalJcrChars((String)sb.toString());
        }
        return nodePath;
    }

    @Override
    public boolean canEditNews(String posterId, String spaceId) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = currentIdentity.getUserId();
        Space currentSpace = this.spaceService.getSpaceById(spaceId);
        return authenticatedUser.equals(posterId) || this.spaceService.isSuperManager(authenticatedUser) || currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME) || currentIdentity.isMemberOf(currentSpace.getGroupId(), MANAGER_MEMBERSHIP_NAME);
    }

    @Override
    public boolean canPinNews() {
        return ConversationState.getCurrent().getIdentity().isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNewsActivities(ExoSocialActivity activity, News news) throws Exception {
        if (activity.getId() != null) {
            SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            try {
                Node newsNode;
                if (!StringUtils.isEmpty((CharSequence)news.getId()) && (newsNode = session.getNodeByUUID(news.getId())).hasProperty("exo:activities")) {
                    String updatedNewsActivities = news.getSpaceId().concat(":").concat(activity.getId());
                    newsNode.setProperty("exo:activities", updatedNewsActivities);
                    newsNode.save();
                    news.setActivities(updatedNewsActivities);
                }
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendNotification(News news, String context) throws Exception {
        boolean isMember;
        String activities = news.getActivities();
        String lastSpaceIdActivityId = activities.split(";")[activities.split(";").length - 1];
        String contentSpaceId = lastSpaceIdActivityId.split(":")[0];
        String contentActivityId = lastSpaceIdActivityId.split(":")[1];
        Space contentSpace = this.spaceService.getSpaceById(contentSpaceId);
        if (contentSpace == null) {
            throw new NullPointerException("Cannot find a space with id " + contentSpaceId + ", it may not exist");
        }
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        StringBuffer illustrationURL = new StringBuffer();
        try {
            Node newsNode = session.getNodeByUUID(news.getId());
            if (newsNode == null) {
                throw new ItemNotFoundException("Cannot find a node with UUID equals to " + news.getId() + ", it may not exist");
            }
            if (newsNode.hasNode("illustration")) {
                illustrationURL.append("/rest/v1/news/").append(news.getId()).append("/illustration");
            } else {
                illustrationURL.append("/news/images/newsImageDefault.png");
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        String contentTitle = news.getTitle();
        String contentAuthor = news.getAuthor();
        String activityLink = this.getActivityPermalink(contentActivityId);
        String baseUrl = PropertyManager.getProperty((String)"gatein.email.domain.url");
        if (context.equals("SHARE MY NEWS") && !(isMember = this.spaceService.isMember(contentSpace, contentAuthor))) {
            activityLink = "/".concat(PortalContainer.getCurrentPortalContainerName()).concat("/g/:spaces:").concat(contentSpace.getPrettyName()).concat("/").concat(contentSpace.getDisplayName());
        }
        String contentSpaceName = contentSpace.getDisplayName();
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PostNewsNotificationPlugin.CONTEXT, (Object)context).append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)contentTitle).append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)contentAuthor).append(PostNewsNotificationPlugin.CURRENT_USER, (Object)currentUser).append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)contentSpaceId).append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)contentSpaceName).append(PostNewsNotificationPlugin.ILLUSTRATION_URL, (Object)baseUrl.concat(illustrationURL.toString())).append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)baseUrl.concat(activityLink));
        if (context.equals("POST NEWS")) {
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"PostNewsNotificationPlugin"))).execute(ctx);
        } else if (context.equals("SHARE NEWS")) {
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"ShareNewsNotificationPlugin"))).execute(ctx);
        } else if (context.equals("SHARE MY NEWS")) {
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"ShareMyNewsNotificationPlugin"))).execute(ctx);
        }
    }

    private String getActivityPermalink(String activityId) {
        return LinkProvider.getSingleActivityUrl((String)activityId);
    }

    @Override
    public List<News> searchNews(NewsFilter filter, String lang) throws Exception {
        SearchContext context = new SearchContext(null, null);
        context.lang(lang);
        ArrayList<News> newsList = new ArrayList<News>();
        List<SearchResult> searchResults = this.newsSearchConnector.search(filter, 0, 0, "relevancy", "desc");
        searchResults.forEach(res -> {
            try {
                News news = this.convertNodeToNews(((NewsSearchResult)((Object)res)).getNode());
                newsList.add(news);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while processing search result in News", (Throwable)e);
            }
        });
        return newsList;
    }
}

