/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.plugin;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.news.notification.utils.NotificationConstants;
import org.exoplatform.news.notification.utils.NotificationUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LikeNewsNotificationPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(LikeNewsNotificationPlugin.class);
    public static final String ID = "LikeNewsNotificationPlugin";
    public static final ArgumentLiteral<String> CONTENT_TITLE = new ArgumentLiteral(String.class, "CONTENT_TITLE");
    public static final ArgumentLiteral<String> ACTIVITY_LINK = new ArgumentLiteral(String.class, "ACTIVITY_LINK");
    public static final ArgumentLiteral<String> CONTENT_SPACE = new ArgumentLiteral(String.class, "CONTENT_SPACE");
    public static final ArgumentLiteral<String> CURRENT_USER = new ArgumentLiteral(String.class, "CURRENT_USER");
    public static final ArgumentLiteral<String> ILLUSTRATION_URL = new ArgumentLiteral(String.class, "ILLUSTRATION_URL");
    public static final ArgumentLiteral<NotificationConstants.NOTIFICATION_CONTEXT> CONTEXT = new ArgumentLiteral(NotificationConstants.NOTIFICATION_CONTEXT.class, "CONTEXT");
    public static final ArgumentLiteral<String> CONTENT_AUTHOR = new ArgumentLiteral(String.class, "CONTENT_AUTHOR");
    public static final ArgumentLiteral<String> POSTER_ACTIVITY_USER_NAME = new ArgumentLiteral(String.class, "POSTER_ACTIVITY_USER_NAME");

    public LikeNewsNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        String newsTitle = (String)ctx.value(CONTENT_TITLE);
        String activityLink = (String)ctx.value(ACTIVITY_LINK);
        String contentSpaceName = (String)ctx.value(CONTENT_SPACE);
        String illustrationUrl = (String)ctx.value(ILLUSTRATION_URL);
        String currentUserName = (String)ctx.value(CURRENT_USER);
        String newsAuthor = (String)ctx.value(CONTENT_AUTHOR);
        NotificationConstants.NOTIFICATION_CONTEXT context = (NotificationConstants.NOTIFICATION_CONTEXT)((Object)ctx.value(CONTEXT));
        String posterActivityUserName = (String)ctx.value(POSTER_ACTIVITY_USER_NAME);
        String currentUserFullName = currentUserName;
        try {
            currentUserFullName = NotificationUtils.getUserFullName(currentUserName);
        }
        catch (Exception e) {
            LOG.error((Object)("An error occured when trying to retreive a user with username " + currentUserName + " " + e.getMessage()), (Throwable)e);
        }
        return NotificationInfo.instance().setFrom(currentUserName).with("CONTENT_TITLE", newsTitle).to(posterActivityUserName).with("CONTENT_AUTHOR", newsAuthor).with("CURRENT_USER", currentUserFullName).with("CONTENT_SPACE", contentSpaceName).with("ILLUSTRATION_URL", illustrationUrl).with("ACTIVITY_LINK", activityLink).with("CONTEXT", context.getContext()).key(this.getKey()).end();
    }
}

