/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.news.notification.plugin.MentionInNewsNotificationPlugin;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class NewsUtils {
    private static Identity loadUser(String username) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        if (username == null || username.isEmpty()) {
            return null;
        }
        return identityManager.getOrCreateIdentity("organization", username);
    }

    public static Set<String> processMentions(String body) {
        HashSet<String> mentions = new HashSet<String>();
        mentions.addAll(NewsUtils.parseMention(body));
        return mentions;
    }

    private static Set<String> parseMention(String str) {
        if (str == null || str.length() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> mentions = new HashSet<String>();
        Matcher matcher = MentionInNewsNotificationPlugin.MENTION_PATTERN.matcher(str);
        while (matcher.find()) {
            String remoteId = matcher.group().substring(1);
            Identity identity = NewsUtils.loadUser(remoteId);
            if (identity == null || mentions.contains(identity.getRemoteId())) continue;
            mentions.add(identity.getRemoteId());
        }
        return mentions;
    }
}

