/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.service.impl;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.model.News;
import org.exoplatform.news.model.NewsDraftObject;
import org.exoplatform.news.notification.utils.NotificationConstants;
import org.exoplatform.news.search.NewsESSearchResult;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.news.service.NewsTargetingService;
import org.exoplatform.news.utils.NewsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;

public class NewsServiceImplV2
implements NewsService {
    public static final String NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME = "Articles";
    public static final MetadataType NEWS_METADATA_TYPE = new MetadataType(1000L, "news");
    public static final String NEWS_METADATA_NAME = "news";
    public static final String NEWS_METADATA_DRAFT_OBJECT_TYPE = "newsDraftPage";
    public static final String NEWS_FILE_API_NAME_SPACE = "news";
    public static final String NEWS_SUMMARY = "summary";
    public static final String NEWS_ILLUSTRATION_ID = "illustrationId";
    public static final String NEWS_UPLOAD_ID = "uploadId";
    private static final Log LOG = ExoLogger.getLogger(NewsServiceImplV2.class);
    private final SpaceService spaceService;
    private final NoteService noteService;
    private final MetadataService metadataService;
    private final FileService fileService;
    private final UploadService uploadService;
    private final NewsTargetingService newsTargetingService;
    private final IndexingService indexingService;
    private final IdentityManager identityManager;
    private final UserACL userACL;
    private final ActivityManager activityManager;
    private final WikiService wikiService;

    public NewsServiceImplV2(SpaceService spaceService, NoteService noteService, MetadataService metadataService, FileService fileService, NewsTargetingService newsTargetingService, IndexingService indexingService, IdentityManager identityManager, UserACL userACL, ActivityManager activityManager, WikiService wikiService, UploadService uploadService) {
        this.spaceService = spaceService;
        this.noteService = noteService;
        this.metadataService = metadataService;
        this.fileService = fileService;
        this.uploadService = uploadService;
        this.newsTargetingService = newsTargetingService;
        this.indexingService = indexingService;
        this.identityManager = identityManager;
        this.userACL = userACL;
        this.activityManager = activityManager;
        this.wikiService = wikiService;
    }

    @Override
    public News createNews(News news, Identity currentIdentity) throws Exception {
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        try {
            if (!this.canCreateNews(space, currentIdentity)) {
                throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " not authorized to create news");
            }
            News createdNews = "published".equals(news.getPublicationState()) && this.recreateIfDraftDeleted(news) != null ? this.postNews(news, currentIdentity.getUserId()) : (news.getSchedulePostDate() != null ? this.unScheduleNews(news, currentIdentity) : this.createDraftArticleForNewPage(news, space.getGroupId(), currentIdentity.getUserId()));
            return createdNews;
        }
        catch (Exception e) {
            LOG.error((Object)("Error when creating the news " + news.getTitle()), (Throwable)e);
            return null;
        }
    }

    @Override
    public News postNews(News news, String poster) throws Exception {
        return null;
    }

    @Override
    public boolean canCreateNews(Space space, Identity currentIdentity) throws Exception {
        return space != null && (NewsUtils.canPublishNews(space.getId(), currentIdentity) || this.spaceService.canRedactOnSpace(space, currentIdentity));
    }

    @Override
    public News updateNews(News news, String updater, Boolean post, boolean publish) throws Exception {
        return null;
    }

    @Override
    public News updateNews(News news, String updater, Boolean post, boolean publish, String newsObjectType) throws Exception {
        boolean displayed;
        if (!this.canEditNews(news, updater)) {
            throw new IllegalArgumentException("User " + updater + " is not authorized to update news");
        }
        Identity updaterIdentity = NewsUtils.getUserIdentity(updater);
        News originalNews = this.getNewsById(news.getId(), updaterIdentity, false, newsObjectType);
        List<String> oldTargets = this.newsTargetingService.getTargetsByNewsId(news.getId());
        boolean canPublish = NewsUtils.canPublishNews(news.getSpaceId(), updaterIdentity);
        Set<String> previousMentions = NewsUtils.processMentions(originalNews.getOriginalBody(), this.spaceService.getSpaceById(news.getSpaceId()));
        if (publish != news.isPublished() && news.isCanPublish()) {
            news.setPublished(publish);
            if (news.isPublished()) {
                this.publishNews(news, updater);
            } else {
                this.unpublishNews(news.getId(), updater);
            }
        }
        boolean bl = displayed = !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)"staged") && !news.isArchived();
        if (publish == news.isPublished() && news.isPublished() && canPublish) {
            if (!(news.getTargets() == null || oldTargets != null && oldTargets.equals(news.getTargets()))) {
                this.newsTargetingService.deleteNewsTargets(news, updater);
                this.newsTargetingService.saveNewsTarget(news, displayed, news.getTargets(), updater);
            }
            if (news.getAudience() != null && news.getAudience().equals("all") && originalNews.getAudience() != null && originalNews.getAudience().equals("space")) {
                this.sendNotification(updater, news, NotificationConstants.NOTIFICATION_CONTEXT.PUBLISH_NEWS);
            }
        }
        if (NewsUtils.NewsObjectType.DRAFT.name().toLowerCase().equals(newsObjectType)) {
            news = this.updateDraftArticleForNewPage(news, updater);
        } else if (NewsUtils.NewsObjectType.LATEST_DRAFT.name().toLowerCase().equals(newsObjectType) || NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase().equals(newsObjectType)) {
            // empty if block
        }
        if ("published".equals(news.getPublicationState())) {
            if (StringUtils.isNotEmpty((CharSequence)news.getId()) && news.getCreationDate() != null) {
                News newMentionedNews = news;
                if (!previousMentions.isEmpty()) {
                    previousMentions.forEach(username -> newMentionedNews.setBody(newMentionedNews.getBody().replaceAll("@" + username, "")));
                }
                this.sendNotification(updater, newMentionedNews, NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS);
            }
            this.indexingService.reindex("news", String.valueOf(news.getId()));
        }
        if (!news.getPublicationState().isEmpty() && !"draft".equals(news.getPublicationState())) {
            if (post != null) {
                this.updateNewsActivity(news, post);
            }
            NewsUtils.broadcastEvent("exo.news.updateArticle", updater, news);
        }
        return news;
    }

    @Override
    public void deleteNews(String newsId, Identity currentIdentity, boolean isDraft) throws Exception {
        News news = this.getNewsById(newsId, currentIdentity, false, isDraft ? NewsUtils.NewsObjectType.DRAFT.name().toLowerCase() : NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase());
        if (!news.isCanDelete()) {
            throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " is not authorized to delete news");
        }
        if (isDraft) {
            this.deleteDraftArticle(newsId, currentIdentity.getUserId());
        } else {
            this.indexingService.unindex("news", String.valueOf(news.getId()));
            MetadataObject newsMetadataObject = new MetadataObject("news", newsId);
            this.metadataService.deleteMetadataItemsByObject(newsMetadataObject);
            NewsUtils.broadcastEvent("exo.news.deleteArticle", currentIdentity.getUserId(), news);
        }
    }

    @Override
    public void publishNews(News news, String publisher) throws Exception {
    }

    @Override
    public void unpublishNews(String newsId, String publisher) throws Exception {
    }

    @Override
    public News getNewsById(String newsId, boolean editMode) throws Exception {
        return null;
    }

    @Override
    public News getNewsById(String newsId, Identity currentIdentity, boolean editMode) throws IllegalAccessException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public News getNewsById(String newsId, Identity currentIdentity, boolean editMode, String newsObjectType) throws IllegalAccessException {
        News news = null;
        try {
            if (newsObjectType == null) {
                throw new IllegalArgumentException("Required argument news object type could not be null");
            }
            if (NewsUtils.NewsObjectType.DRAFT.name().toLowerCase().equals(newsObjectType)) {
                news = this.buildDraftArticle(newsId, currentIdentity.getUserId());
            } else if (!NewsUtils.NewsObjectType.LATEST_DRAFT.name().toLowerCase().equals(newsObjectType) && !NewsUtils.NewsObjectType.ARTICLE.name().toLowerCase().equals(newsObjectType)) {
                // empty if block
            }
        }
        catch (Exception exception) {
            LOG.error("An error occurred while retrieving news with id {}", new Object[]{newsId, exception});
        }
        if (news != null) {
            if (editMode) {
                if (!this.canEditNews(news, currentIdentity.getUserId())) {
                    throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not authorized to edit News");
                }
            } else if (!this.canViewNews(news, currentIdentity.getUserId())) {
                throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not authorized to view News");
            }
            news.setCanEdit(this.canEditNews(news, currentIdentity.getUserId()));
            news.setCanDelete(this.canDeleteNews(currentIdentity, news.getAuthor(), news.getSpaceId()));
            news.setCanPublish(NewsUtils.canPublishNews(news.getSpaceId(), currentIdentity));
            news.setCanArchive(this.canArchiveNews(currentIdentity, news.getAuthor()));
            news.setTargets(this.newsTargetingService.getTargetsByNewsId(newsId));
            ExoSocialActivity activity = null;
            try {
                activity = this.activityManager.getActivity(news.getActivityId());
            }
            catch (Exception e) {
                LOG.debug("Error getting activity of News with id {}", new Object[]{news.getActivityId(), e});
            }
            if (activity != null) {
                RealtimeListAccess listAccess = this.activityManager.getCommentsWithListAccess(activity, true);
                news.setCommentsCount(listAccess.getSize());
                news.setLikesCount(activity.getLikeIdentityIds() == null ? 0 : activity.getLikeIdentityIds().length);
            }
        }
        return news;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<News> getNews(NewsFilter filter, Identity currentIdentity) throws Exception {
        List<String> spaces;
        List<Object> newsList = new ArrayList();
        if (filter == null) throw new Exception("Unable to build query, filter is null");
        if (filter.isArchivedNews()) {
            // empty if block
        }
        if (filter.getSearchText() == null || !filter.getSearchText().equals("")) {
            // empty if block
        }
        if (filter.isPublishedNews()) {
            // empty if block
        }
        if ((spaces = filter.getSpaces()) == null || spaces.size() != 0) {
            // empty if block
        }
        if (filter.isDraftNews()) {
            newsList = this.buildDraftArticles(filter, currentIdentity);
        } else if (filter.isScheduledNews()) {
            // empty if block
        }
        newsList.stream().forEach(news -> {
            news.setCanEdit(this.canEditNews((News)news, currentIdentity.getUserId()));
            news.setCanDelete(this.canDeleteNews(currentIdentity, news.getAuthor(), news.getSpaceId()));
            news.setCanPublish(NewsUtils.canPublishNews(news.getSpaceId(), currentIdentity));
            news.setCanArchive(this.canArchiveNews(currentIdentity, news.getAuthor()));
        });
        return newsList;
    }

    @Override
    public List<News> getNewsByTargetName(NewsFilter filter, String targetName, Identity currentIdentity) throws Exception {
        return new ArrayList<News>();
    }

    @Override
    public int getNewsCount(NewsFilter filter) throws Exception {
        return 0;
    }

    @Override
    public void markAsRead(News news, String userId) throws Exception {
    }

    @Override
    public List<News> searchNews(NewsFilter filter, String lang) throws Exception {
        return new ArrayList<News>();
    }

    @Override
    public News getNewsByActivityId(String activityId, Identity currentIdentity) throws IllegalAccessException, ObjectNotFoundException {
        return null;
    }

    @Override
    public News scheduleNews(News news, Identity currentIdentity) throws Exception {
        return null;
    }

    @Override
    public News unScheduleNews(News news, Identity currentIdentity) throws Exception {
        return null;
    }

    @Override
    public List<NewsESSearchResult> search(org.exoplatform.social.core.identity.model.Identity currentIdentity, NewsFilter filter) {
        return new ArrayList<NewsESSearchResult>();
    }

    @Override
    public boolean canScheduleNews(Space space, Identity currentIdentity) {
        return false;
    }

    @Override
    public boolean canViewNews(News news, String authenticatedUser) {
        try {
            Space space;
            String spaceId = news.getSpaceId();
            Space space2 = space = spaceId == null ? null : this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                LOG.warn("Can't find space with id {} when checking access on news with id {}", new Object[]{spaceId, news.getId()});
                return false;
            }
            if (!(news.isPublished() || !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)"published") || this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isMember(space, authenticatedUser) || this.isMemberOfsharedInSpaces(news, authenticatedUser))) {
                return false;
            }
            if (news.isPublished() && news.getAudience().equals("space") && !this.spaceService.isMember(space, authenticatedUser)) {
                return false;
            }
            if (StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)"staged") && !this.canScheduleNews(space, NewsUtils.getUserIdentity(authenticatedUser))) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.warn("Error retrieving access permission for user {} on news with id {}", new Object[]{authenticatedUser, news.getId()});
            return false;
        }
        return true;
    }

    @Override
    public void shareNews(News news, Space space, org.exoplatform.social.core.identity.model.Identity userIdentity, String sharedActivityId) throws Exception {
    }

    @Override
    public void archiveNews(String newsId, String currentUserName) throws Exception {
    }

    @Override
    public void unarchiveNews(String newsId, String currentUserName) throws Exception {
    }

    @Override
    public boolean canArchiveNews(Identity currentIdentity, String newsAuthor) {
        return false;
    }

    private News createDraftArticleForNewPage(News draftArticle, String pageOwnerId, String draftArticleCreator) throws Exception {
        Wiki wiki = this.wikiService.getWikiByTypeAndOwner(WikiType.GROUP.name().toLowerCase(), pageOwnerId);
        Page newsArticlesRootNotePage = null;
        if (wiki != null) {
            newsArticlesRootNotePage = this.noteService.getNoteOfNoteBookByName(WikiType.GROUP.name().toLowerCase(), pageOwnerId, NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME);
            if (newsArticlesRootNotePage == null) {
                newsArticlesRootNotePage = this.createNewsArticlesNoteRootPage(wiki);
            }
        } else {
            pageOwnerId = this.formatWikiOwnerToGroupId(pageOwnerId);
            wiki = this.wikiService.createWiki(WikiType.GROUP.name().toLowerCase(), pageOwnerId);
            newsArticlesRootNotePage = this.createNewsArticlesNoteRootPage(wiki);
        }
        if (newsArticlesRootNotePage != null) {
            DraftPage draftArticlePage = new DraftPage();
            draftArticlePage.setNewPage(true);
            draftArticlePage.setTargetPageId(null);
            draftArticlePage.setTitle(draftArticle.getTitle());
            draftArticlePage.setContent(draftArticle.getBody());
            draftArticlePage.setParentPageId(newsArticlesRootNotePage.getId());
            draftArticlePage.setAuthor(draftArticle.getAuthor());
            draftArticlePage = this.noteService.createDraftForNewPage(draftArticlePage, System.currentTimeMillis());
            draftArticle.setId(draftArticlePage.getId());
            draftArticle.setCreationDate(draftArticlePage.getCreatedDate());
            draftArticle.setUpdateDate(draftArticlePage.getUpdatedDate());
            Space draftArticleSpace = this.spaceService.getSpaceByGroupId(pageOwnerId);
            NewsDraftObject draftArticleMetaDataObject = new NewsDraftObject(NEWS_METADATA_DRAFT_OBJECT_TYPE, draftArticlePage.getId(), null, Long.parseLong(draftArticleSpace.getId()));
            MetadataKey draftArticleMetadataKey = new MetadataKey(NEWS_METADATA_TYPE.getName(), "news", 0L);
            String draftArticleMetadataItemCreatorIdentityId = this.identityManager.getOrCreateUserIdentity(draftArticleCreator).getId();
            HashMap<String, String> draftArticleMetadataItemProperties = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((CharSequence)draftArticle.getUploadId())) {
                Long draftArticleIllustrationId = this.saveArticleIllustration(draftArticle.getUploadId(), null);
                this.setArticleIllustration(draftArticle, draftArticleIllustrationId, NewsUtils.NewsObjectType.DRAFT.name());
                draftArticleMetadataItemProperties.put(NEWS_ILLUSTRATION_ID, String.valueOf(draftArticleIllustrationId));
                draftArticleMetadataItemProperties.put(NEWS_UPLOAD_ID, draftArticle.getUploadId());
            }
            if (StringUtils.isNotEmpty((CharSequence)draftArticle.getSummary())) {
                draftArticleMetadataItemProperties.put(NEWS_SUMMARY, draftArticle.getSummary());
            }
            this.metadataService.createMetadataItem((MetadataObject)draftArticleMetaDataObject, draftArticleMetadataKey, draftArticleMetadataItemProperties, Long.parseLong(draftArticleMetadataItemCreatorIdentityId));
            return draftArticle;
        }
        return null;
    }

    private News recreateIfDraftDeleted(News news) throws Exception {
        return null;
    }

    private News updateDraftArticleForNewPage(News draftArticle, String draftArticleUpdater) throws WikiException, IllegalAccessException, FileStorageException {
        DraftPage draftArticlePage = this.noteService.getDraftNoteById(draftArticle.getId(), draftArticleUpdater);
        if (draftArticlePage != null) {
            draftArticlePage.setTitle(draftArticle.getTitle());
            draftArticlePage.setContent(draftArticle.getBody());
            draftArticlePage = this.noteService.updateDraftForNewPage(draftArticlePage, System.currentTimeMillis());
            Space draftArticleSpace = this.spaceService.getSpaceByGroupId(draftArticlePage.getWikiOwner());
            NewsDraftObject draftArticleMetaDataObject = new NewsDraftObject(NEWS_METADATA_DRAFT_OBJECT_TYPE, draftArticlePage.getId(), null, Long.parseLong(draftArticleSpace.getId()));
            MetadataKey draftArticleMetadataKey = new MetadataKey(NEWS_METADATA_TYPE.getName(), "news", 0L);
            List draftArticleMetadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(draftArticleMetadataKey, (MetadataObject)draftArticleMetaDataObject);
            if (draftArticleMetadataItems != null && !draftArticleMetadataItems.isEmpty()) {
                MetadataItem draftArticleMetadataItem = (MetadataItem)draftArticleMetadataItems.get(0);
                HashMap<String, String> draftArticleMetadataItemProperties = draftArticleMetadataItem.getProperties();
                if (draftArticleMetadataItemProperties == null) {
                    draftArticleMetadataItemProperties = new HashMap<String, String>();
                }
                if (StringUtils.isNotEmpty((CharSequence)draftArticle.getUploadId())) {
                    if (draftArticleMetadataItemProperties.containsKey(NEWS_UPLOAD_ID) && draftArticleMetadataItemProperties.get(NEWS_UPLOAD_ID) != null && draftArticleMetadataItemProperties.containsKey(NEWS_ILLUSTRATION_ID) && draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID) != null) {
                        if (!((String)draftArticleMetadataItemProperties.get(NEWS_UPLOAD_ID)).equals(draftArticle.getUploadId())) {
                            draftArticleIllustrationFileItem = this.fileService.getFile(Long.parseLong((String)draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID)));
                            Long draftArticleIllustrationId = this.saveArticleIllustration(draftArticle.getUploadId(), draftArticleIllustrationFileItem.getFileInfo().getId());
                            draftArticleMetadataItemProperties.put(NEWS_ILLUSTRATION_ID, String.valueOf(draftArticleIllustrationId));
                            this.setArticleIllustration(draftArticle, draftArticleIllustrationId, NewsUtils.NewsObjectType.DRAFT.name());
                        }
                    } else {
                        Long draftArticleIllustrationId = this.saveArticleIllustration(draftArticle.getUploadId(), null);
                        draftArticleMetadataItemProperties.put(NEWS_ILLUSTRATION_ID, String.valueOf(draftArticleIllustrationId));
                        this.setArticleIllustration(draftArticle, draftArticleIllustrationId, NewsUtils.NewsObjectType.DRAFT.name());
                    }
                    draftArticleMetadataItemProperties.put(NEWS_UPLOAD_ID, draftArticle.getUploadId());
                } else if (draftArticleMetadataItemProperties.containsKey(NEWS_UPLOAD_ID) && draftArticleMetadataItemProperties.get(NEWS_UPLOAD_ID) != null && draftArticleMetadataItemProperties.containsKey(NEWS_ILLUSTRATION_ID) && draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID) != null) {
                    draftArticleMetadataItemProperties.remove(NEWS_UPLOAD_ID);
                    draftArticleIllustrationFileItem = this.fileService.getFile(Long.parseLong((String)draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID)));
                    draftArticleMetadataItemProperties.remove(NEWS_ILLUSTRATION_ID);
                    this.fileService.deleteFile(draftArticleIllustrationFileItem.getFileInfo().getId().longValue());
                }
                if (StringUtils.isNotEmpty((CharSequence)draftArticle.getSummary())) {
                    draftArticleMetadataItemProperties.put(NEWS_SUMMARY, draftArticle.getSummary());
                }
                draftArticleMetadataItem.setProperties(draftArticleMetadataItemProperties);
                String draftArticleMetadataItemUpdaterIdentityId = this.identityManager.getOrCreateUserIdentity(draftArticleUpdater).getId();
                this.metadataService.updateMetadataItem(draftArticleMetadataItem, Long.parseLong(draftArticleMetadataItemUpdaterIdentityId));
            }
            return draftArticle;
        }
        return null;
    }

    private News buildDraftArticle(String draftArticleId, String draftArticleCreator) throws WikiException, IllegalAccessException {
        DraftPage draftArticlePage = this.noteService.getDraftNoteById(draftArticleId, draftArticleCreator);
        if (draftArticlePage != null) {
            Map draftArticleMetadataItemProperties;
            News draftArticle = new News();
            draftArticle.setId(draftArticlePage.getId());
            draftArticle.setTitle(draftArticlePage.getTitle());
            draftArticle.setAuthor(draftArticlePage.getAuthor());
            draftArticle.setCreationDate(draftArticlePage.getCreatedDate());
            draftArticle.setUpdateDate(draftArticlePage.getUpdatedDate());
            draftArticle.setBody(draftArticlePage.getContent());
            draftArticle.setPublicationState("draft");
            Space draftArticleSpace = this.spaceService.getSpaceByGroupId(draftArticlePage.getWikiOwner());
            draftArticle.setSpaceId(draftArticleSpace.getId());
            draftArticle.setSpaceAvatarUrl(draftArticleSpace.getAvatarUrl());
            draftArticle.setSpaceDisplayName(draftArticleSpace.getDisplayName());
            boolean hiddenSpace = draftArticleSpace.getVisibility().equals("hidden") && !this.spaceService.isMember(draftArticleSpace, draftArticleCreator) && !this.spaceService.isSuperManager(draftArticleCreator);
            draftArticle.setHiddenSpace(hiddenSpace);
            boolean isSpaceMember = this.spaceService.isSuperManager(draftArticleCreator) || this.spaceService.isMember(draftArticleSpace, draftArticleCreator);
            draftArticle.setSpaceMember(isSpaceMember);
            if (StringUtils.isNotEmpty((CharSequence)draftArticleSpace.getGroupId())) {
                String spaceGroupId = draftArticleSpace.getGroupId().split("/")[2];
                String spaceUrl = "/portal/g/:spaces:" + spaceGroupId + "/" + draftArticleSpace.getPrettyName();
                draftArticle.setSpaceUrl(spaceUrl);
            }
            StringBuilder draftArticleUrl = new StringBuilder("");
            draftArticleUrl.append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/").append(CommonsUtils.getCurrentPortalOwner()).append("/news/detail?newsId=").append(draftArticle.getId()).append("&type=draft");
            draftArticle.setUrl(draftArticleUrl.toString());
            NewsDraftObject draftArticleMetaDataObject = new NewsDraftObject(NEWS_METADATA_DRAFT_OBJECT_TYPE, draftArticle.getId(), null, Long.parseLong(draftArticleSpace.getId()));
            MetadataKey draftArticleMetadataKey = new MetadataKey(NEWS_METADATA_TYPE.getName(), "news", 0L);
            List draftArticleMetadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(draftArticleMetadataKey, (MetadataObject)draftArticleMetaDataObject);
            if (draftArticleMetadataItems != null && !draftArticleMetadataItems.isEmpty() && (draftArticleMetadataItemProperties = ((MetadataItem)draftArticleMetadataItems.get(0)).getProperties()) != null && !draftArticleMetadataItemProperties.isEmpty()) {
                if (draftArticleMetadataItemProperties.containsKey(NEWS_SUMMARY)) {
                    draftArticle.setSummary((String)draftArticleMetadataItemProperties.get(NEWS_SUMMARY));
                }
                if (draftArticleMetadataItemProperties.containsKey(NEWS_ILLUSTRATION_ID) && draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID) != null) {
                    this.setArticleIllustration(draftArticle, Long.valueOf((String)draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID)), NewsUtils.NewsObjectType.DRAFT.name().toLowerCase());
                }
            }
            return draftArticle;
        }
        return null;
    }

    private List<News> buildDraftArticles(NewsFilter filter, Identity currentIdentity) throws Exception {
        List<Long> allowedDraftNewsSpacesIds = NewsUtils.getAllowedDraftNewsSpaces(currentIdentity).stream().map(Space::getId).map(spaceId -> Long.parseLong(spaceId)).toList();
        List<News> draftArticles = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceIds("news", NEWS_METADATA_TYPE.getName(), NEWS_METADATA_DRAFT_OBJECT_TYPE, allowedDraftNewsSpacesIds, (long)filter.getOffset(), (long)filter.getLimit()).stream().map(draftArticle -> {
            try {
                return this.buildDraftArticle(draftArticle.getObjectId(), currentIdentity.getUserId());
            }
            catch (IllegalAccessException | WikiException e) {
                e.printStackTrace();
                return null;
            }
        }).toList();
        return draftArticles;
    }

    private void deleteDraftArticle(String draftArticleId, String draftArticleCreator) throws Exception {
        DraftPage draftArticlePage = this.noteService.getDraftNoteById(draftArticleId, draftArticleCreator);
        if (draftArticlePage != null) {
            this.noteService.removeDraftById(draftArticlePage.getId());
            Space draftArticleSpace = this.spaceService.getSpaceByGroupId(draftArticlePage.getWikiOwner());
            NewsDraftObject draftArticleMetaDataObject = new NewsDraftObject(NEWS_METADATA_DRAFT_OBJECT_TYPE, draftArticlePage.getId(), null, Long.parseLong(draftArticleSpace.getId()));
            MetadataKey draftArticleMetadataKey = new MetadataKey(NEWS_METADATA_TYPE.getName(), "news", 0L);
            List draftArticleMetadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(draftArticleMetadataKey, (MetadataObject)draftArticleMetaDataObject);
            if (draftArticleMetadataItems != null && !draftArticleMetadataItems.isEmpty()) {
                Map draftArticleMetadataItemProperties = ((MetadataItem)draftArticleMetadataItems.get(0)).getProperties();
                if (draftArticleMetadataItemProperties != null && draftArticleMetadataItemProperties.containsKey(NEWS_ILLUSTRATION_ID) && draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID) != null) {
                    FileItem draftArticleIllustrationFileItem = this.fileService.getFile(Long.parseLong((String)draftArticleMetadataItemProperties.get(NEWS_ILLUSTRATION_ID)));
                    this.fileService.deleteFile(draftArticleIllustrationFileItem.getFileInfo().getId().longValue());
                }
                this.metadataService.deleteMetadataItem(((MetadataItem)draftArticleMetadataItems.get(0)).getId(), false);
            }
        }
    }

    private boolean canEditNews(News news, String authenticatedUser) {
        Space space;
        String spaceId = news.getSpaceId();
        Space space2 = space = spaceId == null ? null : this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            return false;
        }
        Identity authenticatedUserIdentity = NewsUtils.getUserIdentity(authenticatedUser);
        if (authenticatedUserIdentity == null) {
            LOG.warn("Can't find user with id {} when checking access on news with id {}", new Object[]{authenticatedUser, news.getId()});
            return false;
        }
        return NewsUtils.canPublishNews(news.getSpaceId(), authenticatedUserIdentity) || this.spaceService.canRedactOnSpace(space, authenticatedUserIdentity);
    }

    private void setArticleIllustration(News article, Long articleIllustrationId, String newsObjectType) {
        try {
            FileItem articleIllustrationFileItem = this.fileService.getFile(articleIllustrationId.longValue());
            if (articleIllustrationFileItem != null) {
                article.setIllustration(articleIllustrationFileItem.getAsByte());
                article.setIllustrationMimeType(articleIllustrationFileItem.getFileInfo().getMimetype());
                article.setIllustrationUpdateDate(articleIllustrationFileItem.getFileInfo().getUpdatedDate());
                long lastModified = article.getIllustrationUpdateDate().getTime();
                article.setIllustrationURL("/portal/rest/v1/news/" + article.getId() + "/illustration?v=" + lastModified + "&type=" + newsObjectType);
            }
        }
        catch (Exception exception) {
            LOG.info((Object)"Failed to set article illustration");
        }
    }

    private Long saveArticleIllustration(String articleUploadId, Long oldArticleIllustrationFileId) {
        UploadResource articleUploadResource;
        if (StringUtils.isEmpty((CharSequence)articleUploadId)) {
            throw new IllegalArgumentException("Article uploadId is mandatory");
        }
        if (oldArticleIllustrationFileId != null && oldArticleIllustrationFileId != 0L) {
            this.fileService.deleteFile(oldArticleIllustrationFileId.longValue());
        }
        if ((articleUploadResource = this.uploadService.getUploadResource(articleUploadId)) == null) {
            throw new IllegalStateException("Can't find article uploaded resource with id : " + articleUploadId);
        }
        try {
            FileInputStream articleIllustrationFileInputStream = new FileInputStream(articleUploadResource.getStoreLocation());
            FileItem articleIllustrationFileItem = new FileItem(null, articleUploadResource.getFileName(), articleUploadResource.getMimeType(), "news", (long)articleUploadResource.getUploadedSize(), new Date(), IdentityConstants.SYSTEM, false, (InputStream)articleIllustrationFileInputStream);
            articleIllustrationFileItem = this.fileService.writeFile(articleIllustrationFileItem);
            Long l = articleIllustrationFileItem != null && articleIllustrationFileItem.getFileInfo() != null ? articleIllustrationFileItem.getFileInfo().getId() : null;
            return l;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while saving article illustration file", e);
        }
        finally {
            this.uploadService.removeUploadResource(articleUploadResource.getUploadId());
        }
    }

    private boolean canDeleteNews(Identity currentIdentity, String posterId, String spaceId) {
        if (currentIdentity == null) {
            return false;
        }
        String authenticatedUser = currentIdentity.getUserId();
        Space currentSpace = this.spaceService.getSpaceById(spaceId);
        return authenticatedUser.equals(posterId) || this.userACL.isSuperUser() || this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isManager(currentSpace, authenticatedUser);
    }

    private boolean isMemberOfsharedInSpaces(News news, String username) {
        for (String sharedInSpaceId : news.getSharedInSpacesList()) {
            Space sharedInSpace = this.spaceService.getSpaceById(sharedInSpaceId);
            if (sharedInSpace == null || !this.spaceService.isMember(sharedInSpace, username)) continue;
            return true;
        }
        return false;
    }

    private Page createNewsArticlesNoteRootPage(Wiki wiki) throws WikiException {
        if (wiki != null) {
            Page newsArticlesRootNotePage = new Page();
            newsArticlesRootNotePage.setWikiType(wiki.getType());
            newsArticlesRootNotePage.setWikiOwner(wiki.getOwner());
            newsArticlesRootNotePage.setName(NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME);
            newsArticlesRootNotePage.setTitle(NEWS_ARTICLES_ROOT_NOTE_PAGE_NAME);
            Date now = Calendar.getInstance().getTime();
            newsArticlesRootNotePage.setCreatedDate(now);
            newsArticlesRootNotePage.setUpdatedDate(now);
            newsArticlesRootNotePage.setContent("");
            newsArticlesRootNotePage.setSyntax(wiki.getPreferences().getWikiPreferencesSyntax().getDefaultSyntax());
            return this.noteService.createNote(wiki, null, newsArticlesRootNotePage);
        }
        return null;
    }

    private String formatWikiOwnerToGroupId(String wikiOwner) {
        if (wikiOwner == null || ((String)wikiOwner).length() == 0) {
            return null;
        }
        if (!((String)wikiOwner).startsWith("/")) {
            wikiOwner = "/" + (String)wikiOwner;
        }
        if (((String)wikiOwner).endsWith("/")) {
            wikiOwner = ((String)wikiOwner).substring(0, ((String)wikiOwner).length() - 1);
        }
        return wikiOwner;
    }

    private void sendNotification(String currentUserId, News news, NotificationConstants.NOTIFICATION_CONTEXT context) throws Exception {
    }

    private void updateNewsActivity(News news, boolean post) {
    }
}

