/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.search;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.news.NewsService;
import org.exoplatform.news.model.News;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;

public class NewsIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    public static final String TYPE = "news";
    private static final Log LOG = ExoLogger.getLogger(NewsIndexingServiceConnector.class);
    private final NewsService newsService;
    private final IdentityManager identityManager;
    private final ActivityManager activityManager;

    public NewsIndexingServiceConnector(IdentityManager identityManager, InitParams initParams, NewsService newsService, ActivityManager activityManager) {
        super(initParams);
        this.newsService = newsService;
        this.identityManager = identityManager;
        this.activityManager = activityManager;
    }

    public String getConnectorName() {
        return TYPE;
    }

    public Document create(String id) {
        return this.getDocument(id);
    }

    public Document update(String id) {
        return this.getDocument(id);
    }

    public List<String> getAllIds(int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    private Document getDocument(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        LOG.debug("Index document for news id={}", new Object[]{id});
        News news = null;
        SessionProvider systemProvider = SessionProvider.createSystemProvider();
        SessionProviderService sessionProviderService = (SessionProviderService)CommonsUtils.getService(SessionProviderService.class);
        sessionProviderService.setSessionProvider(null, systemProvider);
        try {
            news = this.newsService.getNewsById(id, false);
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news " + id), (Throwable)e);
        }
        if (news == null) {
            throw new IllegalStateException("news with id '" + id + "' is mandatory");
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("id", news.getId());
        fields.put("title", news.getTitle());
        String body = news.getBody();
        String summary = news.getSummary();
        if (StringUtils.isBlank((String)body)) {
            body = news.getTitle();
        }
        if (StringUtils.isNotBlank((String)body)) {
            body = StringEscapeUtils.unescapeHtml((String)body);
            try {
                body = HTMLSanitizer.sanitize((String)body);
            }
            catch (Exception e) {
                LOG.warn("Error sanitizing news '{}' body", new Object[]{news.getId()});
            }
            body = this.htmlToText(body);
            fields.put("body", body);
        }
        if (StringUtils.isNotBlank((String)summary)) {
            summary = StringEscapeUtils.unescapeHtml((String)summary);
            try {
                summary = HTMLSanitizer.sanitize((String)summary);
            }
            catch (Exception e) {
                LOG.warn("Error sanitizing news '{}' summary", new Object[]{news.getId()});
            }
            summary = this.htmlToText(summary);
            fields.put("summary", summary);
        }
        if (StringUtils.isNotBlank((String)news.getAuthor())) {
            fields.put("posterId", news.getAuthor());
            Identity posterIdentity = this.identityManager.getOrCreateIdentity("organization", news.getAuthor());
            if (posterIdentity != null && posterIdentity.getProfile() != null && StringUtils.isNotBlank((String)posterIdentity.getProfile().getFullName())) {
                fields.put("posterName", posterIdentity.getProfile().getFullName());
            }
        }
        if (news.getSpaceDisplayName() != null) {
            fields.put("spaceDisplayName", news.getSpaceDisplayName());
        }
        String newsActivities = news.getActivities();
        String ownerIdentityId = null;
        if (newsActivities != null) {
            String newsActivityId = newsActivities.split(";")[0].split(":")[1];
            fields.put("newsActivityId", newsActivityId);
            ExoSocialActivity newsActivity = this.activityManager.getActivity(newsActivityId);
            ActivityStream activityStream = newsActivity.getActivityStream();
            if (newsActivity.getParentId() != null && (activityStream == null || activityStream.getType() == null || StringUtils.isBlank((String)activityStream.getPrettyId()))) {
                ExoSocialActivity parentActivity = this.activityManager.getActivity(newsActivity.getParentId());
                activityStream = parentActivity.getActivityStream();
            }
            if (activityStream != null && activityStream.getType() != null && StringUtils.isNotBlank((String)activityStream.getPrettyId())) {
                String prettyId = activityStream.getPrettyId();
                String providerId = activityStream.getType().getProviderId();
                Identity streamOwner = this.identityManager.getOrCreateIdentity(providerId, prettyId);
                ownerIdentityId = streamOwner.getId();
            }
        } else {
            return null;
        }
        if (news.getCreationDate() != null) {
            fields.put("postedTime", String.valueOf(news.getCreationDate().getTime()));
        }
        if (news.getUpdateDate() != null) {
            fields.put("lastUpdatedTime", String.valueOf(news.getUpdateDate().getTime()));
        }
        return new Document(id, null, news.getUpdateDate(), Collections.singleton(ownerIdentityId), fields);
    }

    private String htmlToText(String source) {
        source = source.replaceAll("<( )*head([^>])*>", "<head>");
        source = source.replaceAll("(<( )*(/)( )*head( )*>)", "</head>");
        source = source.replaceAll("(<head>).*(</head>)", "");
        source = source.replaceAll("<( )*script([^>])*>", "<script>");
        source = source.replaceAll("(<( )*(/)( )*script( )*>)", "</script>");
        source = source.replaceAll("(<script>).*(</script>)", "");
        source = source.replace("javascript:", "");
        source = source.replaceAll("<( )*style([^>])*>", "<style>");
        source = source.replaceAll("(<( )*(/)( )*style( )*>)", "</style>");
        source = source.replaceAll("(<style>).*(</style>)", "");
        source = source.replaceAll("<( )*td([^>])*>", "\t");
        source = source.replaceAll("<( )*br( )*(/)*>", "\n");
        source = source.replaceAll("<( )*li( )*>", "\n");
        source = source.replaceAll("<( )*div([^>])*>", "\n");
        source = source.replaceAll("<( )*tr([^>])*>", "\n");
        source = source.replaceAll("<( )*p([^>])*>", "\n");
        source = source.replaceAll("<[^>]*>", "");
        return source;
    }
}

