/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.search;

import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.news.search.NewsESSearchResult;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NewsESSearchConnector {
    private static final Log LOG = ExoLogger.getLogger(NewsESSearchConnector.class);
    private static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    private final ConfigurationManager configurationManager;
    private final IdentityManager identityManager;
    private final ActivityStorage activityStorage;
    private final ElasticSearchingClient client;
    private final String index;
    private final String searchType;
    private String searchQueryFilePath;
    private String searchQuery;

    public NewsESSearchConnector(ConfigurationManager configurationManager, IdentityManager identityManager, ActivityStorage activityStorage, ElasticSearchingClient client, InitParams initParams) {
        this.configurationManager = configurationManager;
        this.identityManager = identityManager;
        this.activityStorage = activityStorage;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        this.searchType = param.getProperty("searchType");
        if (initParams.containsKey((Object)SEARCH_QUERY_FILE_PATH_PARAM)) {
            this.searchQueryFilePath = initParams.getValueParam(SEARCH_QUERY_FILE_PATH_PARAM).getValue();
            try {
                this.retrieveSearchQuery();
            }
            catch (Exception e) {
                LOG.error("Can't read elasticsearch search query from path {}", new Object[]{this.searchQueryFilePath, e});
            }
        }
    }

    public List<NewsESSearchResult> search(Identity viewerIdentity, String term, long offset, long limit) {
        if (viewerIdentity == null) {
            throw new IllegalArgumentException("Viewer identity is mandatory");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset must be positive");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        if (StringUtils.isBlank((String)term)) {
            throw new IllegalArgumentException("Filter term is mandatory");
        }
        Set streamFeedOwnerIds = this.activityStorage.getStreamFeedOwnerIds(viewerIdentity);
        String esQuery = this.buildQueryStatement(streamFeedOwnerIds, term, offset, limit);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse);
    }

    private String buildQueryStatement(Set<Long> streamFeedOwnerIds, String term, long offset, long limit) {
        term = this.removeSpecialCharacters(term);
        List termsQuery = Arrays.stream(term.split(" ")).filter(StringUtils::isNotBlank).map(word -> {
            if (((String)(word = ((String)word).trim())).length() > 5) {
                word = (String)word + "~1";
            }
            return word;
        }).collect(Collectors.toList());
        String termQuery = StringUtils.join(termsQuery, (String)" AND ");
        return this.retrieveSearchQuery().replaceAll("@term@", term).replaceAll("@term_query@", termQuery).replaceAll("@permissions@", StringUtils.join(streamFeedOwnerIds, (String)",")).replaceAll("@offset@", String.valueOf(offset)).replaceAll("@limit@", String.valueOf(limit));
    }

    private List<NewsESSearchResult> buildResult(String jsonResponse) {
        Map json;
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<NewsESSearchResult> results = new ArrayList<NewsESSearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            try {
                JSONArray bodyExcepts;
                NewsESSearchResult newsSearchResult = new NewsESSearchResult();
                JSONObject jsonHitObject = (JSONObject)jsonHit;
                JSONObject hitSource = (JSONObject)jsonHitObject.get((Object)"_source");
                String id = (String)hitSource.get((Object)"id");
                String posterId = (String)hitSource.get((Object)"posterId");
                String spaceDisplayName = (String)hitSource.get((Object)"spaceDisplayName");
                String newsActivityId = (String)hitSource.get((Object)"newsActivityId");
                Long postedTime = this.parseLong(hitSource, "postedTime");
                Long lastUpdatedTime = this.parseLong(hitSource, "lastUpdatedTime");
                String title = (String)hitSource.get((Object)"title");
                String body = (String)hitSource.get((Object)"body");
                JSONObject highlightSource = (JSONObject)jsonHitObject.get((Object)"highlight");
                ArrayList<String> excerpts = new ArrayList();
                if (highlightSource != null && (bodyExcepts = (JSONArray)highlightSource.get((Object)"body")) != null) {
                    excerpts = Arrays.asList((String[])bodyExcepts.toArray((Object[])new String[0]));
                }
                newsSearchResult.setId(id);
                newsSearchResult.setTitle(title);
                if (posterId != null) {
                    Identity posterIdentity = this.identityManager.getOrCreateIdentity("organization", posterId);
                    newsSearchResult.setPoster(posterIdentity);
                }
                newsSearchResult.setPostedTime(postedTime);
                newsSearchResult.setLastUpdatedTime(lastUpdatedTime);
                newsSearchResult.setSpaceDisplayName(spaceDisplayName);
                String portalName = PortalContainer.getCurrentPortalContainerName();
                String portalOwner = CommonsUtils.getCurrentPortalOwner();
                StringBuilder newsUrl = new StringBuilder("");
                newsUrl.append("/").append(portalName).append("/").append(portalOwner).append("/activity?id=").append(newsActivityId);
                newsSearchResult.setNewsUrl(newsUrl.toString());
                newsSearchResult.setBody(body);
                newsSearchResult.setExcerpts(excerpts);
                results.add(newsSearchResult);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error processing news search result item, ignore it from results", (Throwable)e);
            }
        }
        return results;
    }

    private Long parseLong(JSONObject hitSource, String key) {
        String value = (String)hitSource.get((Object)key);
        return StringUtils.isBlank((String)value) ? null : Long.valueOf(Long.parseLong(value));
    }

    private String retrieveSearchQuery() {
        if (StringUtils.isBlank((String)this.searchQuery) || PropertyManager.isDevelopping()) {
            try {
                InputStream queryFileIS = this.configurationManager.getInputStream(this.searchQueryFilePath);
                this.searchQuery = IOUtil.getStreamContentAsString((InputStream)queryFileIS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving search query from file: " + this.searchQueryFilePath, e);
            }
        }
        return this.searchQuery;
    }

    private String removeSpecialCharacters(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").replaceAll("'", " ");
        return string;
    }
}

